/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LocalLogWriter;
import com.gemstone.gemfire.internal.logging.LogConfig;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.util.LogFileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Pattern;

public class ManagerLogWriter
extends LocalLogWriter {
    public static final String TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY = "gemfire.logging.test.fileSizeLimitInKB";
    private final boolean fileSizeLimitInKB;
    private LogConfig cfg = null;
    private DistributionManager dm = null;
    private LocalLogWriter mainLogger = this;
    private Pattern childLogPattern = null;
    private File logDir = null;
    private int mainLogId = -1;
    private int childId = 0;
    private boolean useChildLogging = false;
    private boolean rolling = false;
    private boolean mainLog = true;
    private File activeLogFile = null;
    protected static final Pattern mainIdPattern = Pattern.compile(".+-\\d+-\\d+\\..+");
    protected static final Pattern metaIdPattern = Pattern.compile("meta-.+-\\d+\\..+");
    protected static final Pattern childIdPattern = Pattern.compile(".+-\\d+-\\d+\\..+");
    private boolean started = false;

    public ManagerLogWriter(int level, PrintStream out) {
        this(level, out, null);
    }

    public ManagerLogWriter(int level, PrintStream out, String connectionName) {
        super(level, out, connectionName);
        this.fileSizeLimitInKB = Boolean.getBoolean(TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY);
    }

    public LogWriterI18n getMainLogger() {
        return this.mainLogger;
    }

    public void setConfig(LogConfig cfg) {
        this.cfg = cfg;
        this.configChanged();
    }

    public void configChanged() {
        this.setLevel(this.cfg.getLogLevel());
        boolean bl = this.useChildLogging = this.cfg.getLogFile() != null && !this.cfg.getLogFile().equals(new File("")) && this.cfg.getLogFileSizeLimit() != 0;
        if (this.useChildLogging()) {
            this.childLogPattern = ManagerLogWriter.getLogPattern(this.cfg.getLogFile().getName());
            this.logDir = ManagerLogWriter.getParentFile(this.cfg.getLogFile());
            this.mainLogId = ManagerLogWriter.calcNextMainId(this.logDir, true);
        }
        if (this.started) {
            if (this.useChildLogging()) {
                if (this.mainLog) {
                    this.rollLog();
                }
            } else {
                this.switchLogs(this.cfg.getLogFile(), true);
            }
        }
    }

    public File getChildLogFile() {
        return this.activeLogFile;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public int getMainLogId() {
        return this.mainLogId;
    }

    public static String formatId(int id) {
        StringBuffer result = new StringBuffer(10);
        result.append('-');
        if (id < 10) {
            result.append('0');
        }
        result.append(id);
        return result.toString();
    }

    private File getNextChildLogFile() {
        String path = this.cfg.getLogFile().getPath();
        int extIdx = path.lastIndexOf(46);
        String ext = "";
        if (extIdx != -1) {
            ext = path.substring(extIdx);
            path = path.substring(0, extIdx);
        }
        path = path + ManagerLogWriter.formatId(this.mainLogId) + ManagerLogWriter.formatId(this.childId) + ext;
        ++this.childId;
        File result = new File(path);
        if (result.exists()) {
            return this.getNextChildLogFile();
        }
        return result;
    }

    public boolean useChildLogging() {
        return this.useChildLogging;
    }

    private long getLogFileSizeLimit() {
        if (this.rolling || this.mainLog) {
            return Long.MAX_VALUE;
        }
        long result = this.cfg.getLogFileSizeLimit();
        if (result == 0L) {
            return Long.MAX_VALUE;
        }
        if (this.fileSizeLimitInKB) {
            return result * 1024L;
        }
        return result * 0x100000L;
    }

    private long getLogDiskSpaceLimit() {
        long result = this.cfg.getLogDiskSpaceLimit();
        return result * 0x100000L;
    }

    private static String getMetaLogFileName(String baseLogFileName, int mainLogId) {
        String metaLogFile = null;
        int extIdx = baseLogFileName.lastIndexOf(46);
        String ext = "";
        if (extIdx != -1) {
            ext = baseLogFileName.substring(extIdx);
            metaLogFile = baseLogFileName.substring(0, extIdx);
        }
        String fileName = new File(metaLogFile).getName();
        String parent = new File(metaLogFile).getParent();
        metaLogFile = "meta-" + fileName + ManagerLogWriter.formatId(mainLogId) + ext;
        if (parent != null) {
            metaLogFile = parent + File.separator + metaLogFile;
        }
        return metaLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void switchLogs(File newLog, boolean newIsMain) {
        this.rolling = true;
        try {
            try {
                if (!newIsMain) {
                    if (this.mainLog && this.mainLogger == this && this.cfg.getLogFile() != null) {
                        String metaLogFile = ManagerLogWriter.getMetaLogFileName(this.cfg.getLogFile().getPath(), this.mainLogId);
                        this.mainLogger = new LocalLogWriter(800, new PrintStream(new FileOutputStream(metaLogFile, true), true));
                        if (this.activeLogFile == null) {
                            this.mainLogger.info(LocalizedStrings.ManagerLogWriter_SWITCHING_TO_LOG__0, this.cfg.getLogFile());
                        }
                    } else {
                        this.mainLogger.info(LocalizedStrings.ManagerLogWriter_ROLLING_CURRENT_LOG_TO_0, newLog);
                    }
                }
                boolean renameOK = true;
                String oldName = this.cfg.getLogFile().getAbsolutePath();
                File tmpFile = null;
                if (this.activeLogFile != null && !this.activeLogFile.getAbsolutePath().equals(newLog.getAbsolutePath())) {
                    File oldFile;
                    File tmpLogDir;
                    PrintStream tmpps;
                    PrintWriter oldPW;
                    boolean isWindows = false;
                    String os = System.getProperty("os.name");
                    if (os != null && os.indexOf("Windows") != -1) {
                        isWindows = true;
                    }
                    if (isWindows && (oldPW = this.setTarget(new PrintWriter(tmpps = OSProcess.redirectOutput(tmpFile = File.createTempFile("mlw", null, tmpLogDir = ManagerLogWriter.getParentFile(this.cfg.getLogFile())), AlertAppender.getInstance().isAlertingDisabled()), true))) != null) {
                        oldPW.close();
                    }
                    if (!(renameOK = LogFileUtils.renameAggressively(oldFile = this.activeLogFile, newLog.getAbsoluteFile()))) {
                        this.mainLogger.warning("Could not delete original file '" + oldFile + "' after copying to '" + newLog.getAbsoluteFile() + "'. Continuing without rolling.");
                    } else {
                        renameOK = true;
                    }
                }
                this.activeLogFile = new File(oldName);
                PrintStream ps = OSProcess.redirectOutput(this.activeLogFile, AlertAppender.getInstance().isAlertingDisabled());
                PrintWriter oldPW = this.setTarget(new PrintWriter(ps, true), this.activeLogFile.length());
                if (oldPW != null) {
                    oldPW.close();
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                this.mainLog = newIsMain;
                if (this.mainLogger == null) {
                    this.mainLogger = this;
                }
                if (!renameOK) {
                    this.mainLogger.warning("Could not rename \"" + this.activeLogFile + "\" to \"" + newLog + "\". Continuing without rolling.");
                }
            }
            catch (IOException ex) {
                this.mainLogger.warning("Could not open log \"" + newLog + "\" because " + ex);
            }
            this.checkDiskSpace(this.activeLogFile);
        }
        finally {
            this.rolling = false;
        }
    }

    public void closingLogFile() {
        PrintWriter pw;
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        this.close();
        if (this.mainLogger != null) {
            this.mainLogger.close();
        }
        if ((pw = this.setTarget(new PrintWriter(out, true))) != null) {
            pw.close();
        }
    }

    private static File getParentFile(File f) {
        File tmp = f.getAbsoluteFile().getParentFile();
        if (tmp == null) {
            tmp = new File(".");
        }
        return tmp;
    }

    public static File getLogNameForOldMainLog(File log, boolean useOldFile) {
        File dir = ManagerLogWriter.getParentFile(log.getAbsoluteFile());
        int previousMainId = ManagerLogWriter.calcNextMainId(dir, true);
        if (useOldFile && previousMainId > 0) {
            --previousMainId;
        }
        if (previousMainId == 0) {
            previousMainId = 1;
        }
        File result = null;
        int childId = ManagerLogWriter.calcNextChildId(log, previousMainId > 0 ? previousMainId : 0);
        StringBuffer buf = new StringBuffer(log.getPath());
        int insertIdx = buf.lastIndexOf(".");
        if (insertIdx == -1) {
            buf.append(ManagerLogWriter.formatId(previousMainId)).append(ManagerLogWriter.formatId(childId));
        } else {
            buf.insert(insertIdx, ManagerLogWriter.formatId(childId));
            buf.insert(insertIdx, ManagerLogWriter.formatId(previousMainId));
        }
        result = new File(buf.toString());
        return result;
    }

    private static Pattern getLogPattern(String name) {
        int extIdx = name.lastIndexOf(46);
        String ext = "";
        if (extIdx != -1) {
            ext = "\\Q" + name.substring(extIdx) + "\\E";
            name = name.substring(0, extIdx);
        }
        name = "\\Q" + name + "\\E" + "-\\d+-\\d+" + ext;
        return Pattern.compile(name);
    }

    public static int calcNextMainId(File dir, boolean toCreateNew) {
        File[] childLogs;
        int result = 0;
        for (File childLog : childLogs = FileUtil.listFiles(dir, new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return mainIdPattern.matcher(name).matches();
            }
        })) {
            String name = childLog.getName();
            int endIdIdx = name.lastIndexOf(45);
            int startIdIdx = name.lastIndexOf(45, endIdIdx - 1);
            String id = name.substring(startIdIdx + 1, endIdIdx);
            try {
                int mid = Integer.parseInt(id);
                if (mid <= result) continue;
                result = mid;
            }
            catch (NumberFormatException mid) {
                // empty catch block
            }
        }
        if (toCreateNew) {
            File[] metaLogs;
            for (File metaLog : metaLogs = FileUtil.listFiles(dir, new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    return metaIdPattern.matcher(name).matches();
                }
            })) {
                String name = metaLog.getName();
                int endIdIdx = name.lastIndexOf(46);
                int startIdIdx = name.lastIndexOf(45, endIdIdx - 1);
                String id = name.substring(startIdIdx + 1, endIdIdx);
                try {
                    int mid = Integer.parseInt(id);
                    if (mid <= result) continue;
                    result = mid;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++result;
        }
        return result;
    }

    public static int calcNextChildId(File log, int mainId) {
        File[] childLogs;
        int result = 0;
        File dir = ManagerLogWriter.getParentFile(log.getAbsoluteFile());
        int endidx1 = log.getName().indexOf(45);
        int endidx2 = log.getName().lastIndexOf(46);
        String baseName = log.getName();
        baseName = endidx1 != -1 ? log.getName().substring(0, endidx1) : log.getName().substring(0, endidx2);
        for (File childLog : childLogs = FileUtil.listFiles(dir, new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return childIdPattern.matcher(name).matches();
            }
        })) {
            String name = childLog.getName();
            if (!name.startsWith(baseName)) continue;
            int endIdIdx = name.lastIndexOf(45);
            int startIdIdx = name.lastIndexOf(45, endIdIdx - 1);
            String id = name.substring(startIdIdx + 1, endIdIdx);
            int startChild = name.lastIndexOf("-");
            int endChild = name.lastIndexOf(".");
            if (startChild <= 0 || endChild <= 0) continue;
            String childId = name.substring(startChild + 1, endChild);
            try {
                int mainLogId = Integer.parseInt(id);
                int childLogId = Integer.parseInt(childId);
                if (mainLogId != mainId || childLogId <= result) continue;
                result = childLogId;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ++result;
    }

    public static void removeOldLogs(LogConfig cfg, File logFile) {
        LocalLogWriter log = new LocalLogWriter(800, System.err);
        ManagerLogWriter.checkDiskSpace("log", null, (long)cfg.getLogDiskSpaceLimit() * 0x100000L, ManagerLogWriter.getParentFile(logFile), ManagerLogWriter.getLogPattern(logFile.getName()), log);
    }

    public static void checkDiskSpace(String type, File newLog, long spaceLimit, File dir, final Pattern logPattern, LogWriterI18n logger) {
        if (spaceLimit == 0L || logPattern == null) {
            return;
        }
        final String newLogName = newLog == null ? null : newLog.getName();
        File[] childLogs = FileUtil.listFiles(dir, new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                if (name.equals(newLogName)) {
                    return false;
                }
                boolean result = logPattern.matcher(name).matches();
                return result;
            }
        });
        if (childLogs == null) {
            if (dir.isDirectory()) {
                logger.warning(LocalizedStrings.ManagerLogWriter_COULD_NOT_CHECK_DISK_SPACE_ON_0_BECAUSE_JAVAIOFILELISTFILES_RETURNED_NULL_THIS_COULD_BE_CAUSED_BY_A_LACK_OF_FILE_DESCRIPTORS, dir);
            }
            return;
        }
        Arrays.sort(childLogs, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                long diff = f1.lastModified() - f2.lastModified();
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        long spaceUsed = 0L;
        for (File childLog : childLogs) {
            spaceUsed += childLog.length();
        }
        for (int fIdx = 0; spaceUsed >= spaceLimit && fIdx < childLogs.length; ++fIdx) {
            long childSize = childLogs[fIdx].length();
            if (childLogs[fIdx].delete()) {
                spaceUsed -= childSize;
                logger.info(LocalizedStrings.ManagerLogWriter_DELETED_INACTIVE__0___1_, new Object[]{type, childLogs[fIdx]});
                continue;
            }
            logger.warning(LocalizedStrings.ManagerLogWriter_COULD_NOT_DELETE_INACTIVE__0___1_, new Object[]{type, childLogs[fIdx]});
        }
        if (spaceUsed > spaceLimit) {
            logger.warning(LocalizedStrings.ManagerLogWriter_COULD_NOT_FREE_SPACE_IN_0_DIRECTORY_THE_SPACE_USED_IS_1_WHICH_EXCEEDS_THE_CONFIGURED_LIMIT_OF_2, new Object[]{type, spaceUsed, spaceLimit});
        }
    }

    private void checkDiskSpace(File newLog) {
        ManagerLogWriter.checkDiskSpace("log", newLog, this.getLogDiskSpaceLimit(), this.logDir, this.childLogPattern, this.mainLogger);
    }

    public void rollLog() {
        this.rollLog(false);
    }

    private void rollLogIfFull() {
        this.rollLog(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollLog(boolean ifFull) {
        if (!this.useChildLogging()) {
            return;
        }
        ManagerLogWriter managerLogWriter = this;
        synchronized (managerLogWriter) {
            if (ifFull && !this.activeLogFull()) {
                return;
            }
            this.switchLogs(this.getNextChildLogFile(), false);
        }
    }

    public void startupComplete() {
        this.started = true;
        this.rollLog();
    }

    public void shuttingDown() {
        if (this.useChildLogging()) {
            this.switchLogs(this.cfg.getLogFile(), true);
        }
    }

    private boolean activeLogFull() {
        long limit = this.getLogFileSizeLimit();
        if (limit == Long.MAX_VALUE) {
            return false;
        }
        return this.getBytesLogged() >= limit;
    }

    @Override
    public String put(int msgLevel, Date msgDate, String connectionName, String threadName, long tid, String msg, String exceptionText) {
        String result = null;
        result = super.put(msgLevel, msgDate, connectionName, threadName, tid, msg, exceptionText);
        return result;
    }

    @Override
    public void writeFormattedMessage(String s) {
        this.rollLogIfFull();
        super.writeFormattedMessage(s);
    }
}

