/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.StandardErrorPrinter;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LoggingThreadGroup
extends ThreadGroup {
    private static final StandardErrorPrinter stderr = new StandardErrorPrinter(Integer.MIN_VALUE);
    private static final Collection<LoggingThreadGroup> loggingThreadGroups = new ArrayList<LoggingThreadGroup>();
    protected volatile InternalLogWriter logWriter;
    protected volatile Logger logger;
    private long uncaughtExceptionsCount;
    private Object dispatchLock = new Object();

    public static LoggingThreadGroup createThreadGroup(String name) {
        return LoggingThreadGroup.createThreadGroup(name, (Logger)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingThreadGroup createThreadGroup(String name, InternalLogWriter logWriter) {
        ThreadGroup group = null;
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            Iterator<LoggingThreadGroup> iter = loggingThreadGroups.iterator();
            while (iter.hasNext()) {
                LoggingThreadGroup group2 = iter.next();
                if (group2.isDestroyed()) {
                    iter.remove();
                    continue;
                }
                if (!name.equals(group2.getName())) continue;
                if (logWriter != group2.logWriter) {
                    group2.logWriter = logWriter;
                }
                group = group2;
                break;
            }
            if (group == null) {
                group = new LoggingThreadGroup(name, logWriter);
                group.setDaemon(false);
                loggingThreadGroups.add((LoggingThreadGroup)group);
            }
        }
        Assert.assertTrue(!group.isDestroyed());
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingThreadGroup createThreadGroup(String name, Logger logger) {
        ThreadGroup group = null;
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            Iterator<LoggingThreadGroup> iter = loggingThreadGroups.iterator();
            while (iter.hasNext()) {
                LoggingThreadGroup group2 = iter.next();
                if (group2.isDestroyed()) {
                    iter.remove();
                    continue;
                }
                if (!name.equals(group2.getName())) continue;
                if (logger != group2.logger) {
                    group2.logger = logger;
                }
                group = group2;
                break;
            }
            if (group == null) {
                group = new LoggingThreadGroup(name, logger);
                group.setDaemon(false);
                loggingThreadGroups.add((LoggingThreadGroup)group);
            }
        }
        Assert.assertTrue(!group.isDestroyed());
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpThreadGroups() {
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            for (LoggingThreadGroup group : loggingThreadGroups) {
                if (group.getName().equals("Distributed system shutdown hook") || group.getName().equals("GemFireConnectionFactory Shutdown Hook")) continue;
                group.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadGroup getThreadGroup(String threadGroupName) {
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            for (LoggingThreadGroup object : loggingThreadGroups) {
                LoggingThreadGroup threadGroup = object;
                if (!threadGroup.getName().equals(threadGroupName)) continue;
                return threadGroup;
            }
            return null;
        }
    }

    LoggingThreadGroup(String name, InternalLogWriter logWriter) {
        super(name);
        this.logWriter = logWriter;
    }

    LoggingThreadGroup(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        Object object = this.dispatchLock;
        synchronized (object) {
            if (ex instanceof VirtualMachineError) {
                SystemFailure.setFailure((VirtualMachineError)ex);
            }
            String threadName = t.getName();
            if (ex instanceof NoClassDefFoundError && threadName.equals("Distributed system shutdown hook")) {
                StringId msg = LocalizedStrings.UNCAUGHT_EXCEPTION_IN_THREAD_0_THIS_MESSAGE_CAN_BE_DISREGARDED_IF_IT_OCCURED_DURING_AN_APPLICATION_SERVER_SHUTDOWN_THE_EXCEPTION_MESSAGE_WAS_1;
                Object[] msgArgs = new Object[]{t, ex.getLocalizedMessage()};
                stderr.info(msg, msgArgs);
                if (this.logger != null) {
                    this.logger.info((Message)LocalizedMessage.create(msg, msgArgs));
                }
                if (this.logWriter != null) {
                    this.logWriter.info(msg, msgArgs);
                }
            } else {
                stderr.severe(LocalizedStrings.UNCAUGHT_EXCEPTION_IN_THREAD_0, t, ex);
                if (this.logger != null) {
                    this.logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.UNCAUGHT_EXCEPTION_IN_THREAD_0, t), ex);
                }
                if (this.logWriter != null) {
                    this.logWriter.severe(LocalizedStrings.UNCAUGHT_EXCEPTION_IN_THREAD_0, t, ex);
                }
            }
            ++this.uncaughtExceptionsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUncaughtExceptionsCount() {
        Object object = this.dispatchLock;
        synchronized (object) {
            this.uncaughtExceptionsCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUncaughtExceptionsCount() {
        Object object = this.dispatchLock;
        synchronized (object) {
            return this.uncaughtExceptionsCount;
        }
    }

    public synchronized void cleanup() {
        this.logger = null;
        this.logWriter = null;
    }
}

