/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.logging.GemFireFormatter;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class GemFireHandler
extends Handler {
    private LogWriter logWriter;

    public GemFireHandler(LogWriter logWriter) {
        this.logWriter = logWriter;
        this.setFormatter(new GemFireFormatter(logWriter));
    }

    @Override
    public void close() {
        this.logWriter = null;
    }

    @Override
    public void flush() {
    }

    private String getMessage(LogRecord record) {
        StringBuilder b = new StringBuilder();
        b.append('(').append("tid=" + record.getThreadID()).append(" msgId=" + record.getSequenceNumber()).append(") ");
        if (record.getMessage() != null) {
            b.append(this.getFormatter().formatMessage(record));
        }
        return b.toString();
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            try {
                if (this.logWriter instanceof LogWriterLogger) {
                    ((LogWriterLogger)this.logWriter).log(record.getLevel().intValue(), this.getMessage(record), record.getThrown());
                } else {
                    ((LogWriterImpl)this.logWriter).put(record.getLevel().intValue(), this.getMessage(record), record.getThrown());
                }
            }
            catch (GemFireException ex) {
                this.reportError(null, ex, 1);
            }
        }
    }
}

