/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;

public final class DebugLogWriter
extends LogWriterImpl {
    private final LogWriterImpl realLogWriter;
    private final String prefix;

    public DebugLogWriter(LogWriterImpl lw, Class c) {
        this.realLogWriter = lw;
        this.prefix = c.getName() + ":";
    }

    @Override
    public int getLogWriterLevel() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void setLogWriterLevel(int newLevel) {
        throw new UnsupportedOperationException("Cannot restrict log level");
    }

    @Override
    public void put(int level, String msg, Throwable exception) {
        this.realLogWriter.put(900, this.prefix + " level " + DebugLogWriter.levelToString(level) + " " + msg, exception);
    }

    @Override
    public void put(int msgLevel, StringId msgId, Object[] params, Throwable exception) {
        String msg = this.prefix + " level " + DebugLogWriter.levelToString(msgLevel) + " " + msgId.toLocalizedString(params);
        this.realLogWriter.put(900, msg, exception);
    }

    @Override
    public boolean configEnabled() {
        return true;
    }

    @Override
    public boolean fineEnabled() {
        return true;
    }

    @Override
    public boolean finerEnabled() {
        return true;
    }

    @Override
    public boolean finestEnabled() {
        return true;
    }

    @Override
    public boolean infoEnabled() {
        return true;
    }

    @Override
    public boolean severeEnabled() {
        return true;
    }

    @Override
    public boolean warningEnabled() {
        return true;
    }

    @Override
    public String getConnectionName() {
        return null;
    }
}

