/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.lang;

import com.gemstone.gemfire.internal.lang.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ObjectUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T defaultIfNull(T ... values) {
        if (values != null) {
            for (T value : values) {
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 != null && obj1.equals(obj2);
    }

    public static boolean equalsIgnoreNull(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    static Class[] getArgumentTypes(Object ... args) {
        Class[] argTypes = null;
        if (args != null) {
            int index = 0;
            argTypes = new Class[args.length];
            for (Object arg : args) {
                argTypes[index++] = ClassUtils.getClass(arg);
            }
        }
        return argTypes;
    }

    public static <T> T invoke(Object obj, String methodName) {
        return ObjectUtils.invoke(obj, methodName, null, (Object[])null);
    }

    public static <T> T invoke(Object obj, String methodName, Object ... arguments) {
        return ObjectUtils.invoke(obj, methodName, ObjectUtils.getArgumentTypes(arguments), arguments);
    }

    public static <T> T invoke(Object obj, String methodName, Class<?>[] parameterTypes, Object ... arguments) {
        assert (obj != null) : String.format("The Object to invoke method (%1$s) on cannot be null!", methodName);
        assert (methodName != null) : String.format("The name of the method to invoke on Object of type (%1$s) cannot be null", obj.getClass().getName());
        try {
            Method method = obj.getClass().getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return (T)method.invoke(obj, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Method (%1$s) does not exist on Object of type (%2$s)!", methodName, obj.getClass().getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("The invocation of method (%1$s) on an Object of type (%2$s) failed!", methodName, obj.getClass().getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("The method (%1$s) on an Object of type (%2$s) is not accessible!", methodName, obj.getClass().getName()), e);
        }
    }
}

