/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.lang;

public abstract class ClassUtils {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Class forName(String className, RuntimeException e) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            throw e;
        }
        catch (NoClassDefFoundError ignore) {
            throw e;
        }
    }

    public static Class getClass(Object obj) {
        return obj == null ? null : obj.getClass();
    }

    public static String getClassName(Object obj) {
        Class objType = ClassUtils.getClass(obj);
        return objType == null ? null : objType.getName();
    }

    public static boolean isClassAvailable(String className) {
        try {
            ClassUtils.forName(className, new IllegalArgumentException(String.format("Class (%1$s) is not available!", className)));
            return true;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    public static boolean isInstanceOf(Class type, Object obj) {
        return type != null && type.isInstance(obj);
    }

    public static boolean isNotInstanceOf(Object obj, Class ... types) {
        boolean condition = true;
        if (types != null) {
            for (int index = 0; index < types.length && condition; condition &= !types[index].isInstance(obj), ++index) {
            }
        }
        return condition;
    }
}

