/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends FilterOutputStream {
    private volatile OutputStream branch;

    public TeeOutputStream(OutputStream out) {
        super(out);
    }

    public TeeOutputStream(OutputStream out, OutputStream branch) {
        this(out);
        this.branch = branch;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getBranchOutputStream() {
        return this.branch;
    }

    public void setBranchOutputStream(OutputStream branch) {
        if (branch == this.out) {
            throw new IllegalArgumentException("TeeOutputStream cannot set branch same as out");
        }
        this.branch = branch;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        OutputStream os = this.branch;
        if (os != null) {
            os.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        OutputStream os = this.branch;
        if (os != null) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        OutputStream os = this.branch;
        if (os != null) {
            os.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("outputStream=").append(this.out);
        sb.append(", branchOutputStream=").append(this.branch);
        return sb.append("}").toString();
    }
}

