/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CompositeOutputStream
extends OutputStream
implements Iterable<OutputStream> {
    protected final Object lock = new Object();
    private volatile Set<OutputStream> streams = Collections.emptySet();

    public CompositeOutputStream(OutputStream ... out) {
        HashSet<OutputStream> newSet = new HashSet<OutputStream>();
        for (OutputStream stream : out) {
            newSet.add(stream);
        }
        this.streams = newSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOutputStream(OutputStream out) {
        Object object = this.lock;
        synchronized (object) {
            Set<OutputStream> oldSet = this.streams;
            if (oldSet.contains(out)) {
                return false;
            }
            HashSet<OutputStream> newSet = new HashSet<OutputStream>(oldSet);
            boolean added = newSet.add(out);
            this.streams = newSet;
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOutputStream(OutputStream out) {
        Object object = this.lock;
        synchronized (object) {
            Set<OutputStream> oldSet = this.streams;
            if (!oldSet.contains(out)) {
                return false;
            }
            if (oldSet.size() == 1) {
                this.streams = Collections.emptySet();
                return true;
            }
            HashSet<OutputStream> newSet = new HashSet<OutputStream>(oldSet);
            boolean removed = newSet.remove(out);
            this.streams = newSet;
            return removed;
        }
    }

    public boolean isEmpty() {
        return this.streams.isEmpty();
    }

    public int size() {
        return this.streams.size();
    }

    @Override
    public Iterator<OutputStream> iterator() {
        return this.streams.iterator();
    }

    @Override
    public void write(int b) throws IOException {
        Set<OutputStream> outputStreams = this.streams;
        for (OutputStream out : outputStreams) {
            out.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        Set<OutputStream> outputStreams = this.streams;
        for (OutputStream out : outputStreams) {
            out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        Set<OutputStream> outputStreams = this.streams;
        for (OutputStream out : outputStreams) {
            try {
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            out.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("size=").append(this.streams.size());
        return sb.append("}").toString();
    }
}

