/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.hll;

import com.gemstone.gemfire.internal.hll.Bits;
import com.gemstone.gemfire.internal.hll.CardinalityMergeException;
import com.gemstone.gemfire.internal.hll.IBuilder;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.hll.MurmurHash;
import com.gemstone.gemfire.internal.hll.RegisterSet;
import com.gemstone.gemfire.internal.redis.executor.hll.HllExecutor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class HyperLogLog
implements ICardinality,
Serializable {
    private static final long serialVersionUID = -4661220245111112301L;
    private final RegisterSet registerSet;
    private final int log2m;
    private final double alphaMM;

    public HyperLogLog(double rsd) {
        this(HyperLogLog.log2m(rsd));
    }

    private static int log2m(double rsd) {
        return (int)(Math.log(1.106 / rsd * (1.106 / rsd)) / Math.log(2.0));
    }

    public HyperLogLog(int log2m) {
        this(log2m, new RegisterSet(1 << log2m));
    }

    @Deprecated
    public HyperLogLog(int log2m, RegisterSet registerSet) {
        if (log2m < 0 || log2m > 30) {
            throw new IllegalArgumentException("log2m argument is " + log2m + " and is outside the range [0, 30]");
        }
        this.registerSet = registerSet;
        this.log2m = log2m;
        int m = 1 << this.log2m;
        this.alphaMM = HyperLogLog.getAlphaMM(log2m, m);
    }

    @Override
    public boolean offerHashed(long hashedValue) {
        int j = (int)(hashedValue >>> 64 - this.log2m);
        int r = Long.numberOfLeadingZeros(hashedValue << this.log2m | (long)((1 << this.log2m - 1) + 1)) + 1;
        return this.registerSet.updateIfGreater(j, r);
    }

    @Override
    public boolean offerHashed(int hashedValue) {
        int j = hashedValue >>> 32 - this.log2m;
        int r = Integer.numberOfLeadingZeros(hashedValue << this.log2m | (1 << this.log2m - 1) + 1) + 1;
        return this.registerSet.updateIfGreater(j, r);
    }

    @Override
    public boolean offer(Object o) {
        int x = MurmurHash.hash(o);
        return this.offerHashed(x);
    }

    @Override
    public long cardinality() {
        double registerSum = 0.0;
        int count = this.registerSet.count;
        double zeros = 0.0;
        for (int j = 0; j < this.registerSet.count; ++j) {
            int val = this.registerSet.get(j);
            registerSum += 1.0 / (double)(1 << val);
            if (val != 0) continue;
            zeros += 1.0;
        }
        double estimate = this.alphaMM * (1.0 / registerSum);
        if (estimate <= 2.5 * (double)count) {
            return Math.round(HyperLogLog.linearCounting(count, zeros));
        }
        return Math.round(estimate);
    }

    @Override
    public int sizeof() {
        return this.registerSet.size * 4;
    }

    @Override
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.writeBytes(dos);
        return baos.toByteArray();
    }

    private void writeBytes(DataOutput serializedByteStream) throws IOException {
        serializedByteStream.writeInt(this.log2m);
        serializedByteStream.writeInt(this.registerSet.size * 4);
        for (int x : this.registerSet.readOnlyBits()) {
            serializedByteStream.writeInt(x);
        }
    }

    public void addAll(HyperLogLog other) throws CardinalityMergeException {
        if (this.sizeof() != other.sizeof()) {
            throw new HyperLogLogMergeException("Cannot merge estimators of different sizes");
        }
        this.registerSet.merge(other.registerSet);
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws CardinalityMergeException {
        HyperLogLog merged = new HyperLogLog(HllExecutor.DEFAULT_HLL_STD_DEV);
        merged.addAll(this);
        if (estimators == null) {
            return merged;
        }
        for (ICardinality estimator : estimators) {
            if (!(estimator instanceof HyperLogLog)) {
                throw new HyperLogLogMergeException("Cannot merge estimators of different class");
            }
            HyperLogLog hll = (HyperLogLog)estimator;
            merged.addAll(hll);
        }
        return merged;
    }

    private Object writeReplace() {
        return new SerializationHolder(this);
    }

    protected static double getAlphaMM(int p, int m) {
        switch (p) {
            case 4: {
                return 0.673 * (double)m * (double)m;
            }
            case 5: {
                return 0.697 * (double)m * (double)m;
            }
            case 6: {
                return 0.709 * (double)m * (double)m;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)m) * (double)m * (double)m;
    }

    protected static double linearCounting(int m, double V) {
        return (double)m * Math.log((double)m / V);
    }

    protected static class HyperLogLogMergeException
    extends CardinalityMergeException {
        public HyperLogLogMergeException(String message) {
            super(message);
        }
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private static final long serialVersionUID = -979314356097156719L;
        private double rsd;

        public Builder(double rsd) {
            this.rsd = rsd;
        }

        @Override
        public HyperLogLog build() {
            return new HyperLogLog(this.rsd);
        }

        @Override
        public int sizeof() {
            int log2m = HyperLogLog.log2m(this.rsd);
            int k = 1 << log2m;
            return RegisterSet.getBits(k) * 4;
        }

        public static HyperLogLog build(byte[] bytes) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return Builder.build(new DataInputStream(bais));
        }

        public static HyperLogLog build(DataInput serializedByteStream) throws IOException {
            int log2m = serializedByteStream.readInt();
            int byteArraySize = serializedByteStream.readInt();
            return new HyperLogLog(log2m, new RegisterSet(1 << log2m, Bits.getBits(serializedByteStream, byteArraySize)));
        }
    }

    private static class SerializationHolder
    implements Externalizable {
        HyperLogLog hyperLogLogHolder;

        public SerializationHolder(HyperLogLog hyperLogLogHolder) {
            this.hyperLogLogHolder = hyperLogLogHolder;
        }

        public SerializationHolder() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.hyperLogLogHolder.writeBytes(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.hyperLogLogHolder = Builder.build(in);
        }

        private Object readResolve() {
            return this.hyperLogLogHolder;
        }
    }
}

