/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.datasource;

import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.datasource.AbstractDataSource;
import com.gemstone.gemfire.internal.datasource.ConfiguredDataSourceProperties;
import com.gemstone.gemfire.internal.datasource.ConnectionProvider;
import com.gemstone.gemfire.internal.datasource.GemFireConnectionPoolManager;
import com.gemstone.gemfire.internal.datasource.PoolException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GemFireConnPooledDataSource
extends AbstractDataSource
implements ConnectionEventListener {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1177231744410855158L;
    protected ConnectionProvider provider;

    public boolean isWrapperFor(Class iface) throws SQLException {
        return true;
    }

    public Object unwrap(Class iface) throws SQLException {
        return iface;
    }

    public GemFireConnPooledDataSource(ConnectionPoolDataSource connPoolDS, ConfiguredDataSourceProperties configs) throws SQLException {
        super(configs);
        if (connPoolDS == null || configs == null) {
            throw new SQLException(LocalizedStrings.GemFireConnPooledDataSource_GEMFIRECONNPOOLEDDATASOURCECONNECTIONPOOLDATASOURCE_CLASS_OBJECT_IS_NULL_OR_CONFIGUREDDATASOURCEPROPERTIES_OBJECT_IS_NULL.toLocalizedString());
        }
        try {
            this.provider = new GemFireConnectionPoolManager(connPoolDS, configs, (ConnectionEventListener)this);
        }
        catch (Exception ex) {
            StringId exception = LocalizedStrings.GemFireConnPooledDataSource_EXCEPTION_CREATING_GEMFIRECONNECTIONPOOLMANAGER;
            logger.error((Message)LocalizedMessage.create(exception, ex.getLocalizedMessage()), (Throwable)ex);
            throw new SQLException(exception.toLocalizedString(ex));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isActive) {
            throw new SQLException(LocalizedStrings.GemFireConnPooledDataSource_GEMFIRECONNPOOLEDDATASOURCEGETCONNECTIONNO_VALID_CONNECTION_AVAILABLE.toLocalizedString());
        }
        PooledConnection connPool = null;
        try {
            connPool = (PooledConnection)this.provider.borrowConnection();
        }
        catch (PoolException cpe) {
            throw new SQLException(cpe.toString());
        }
        return this.getSQLConnection(connPool);
    }

    @Override
    public Connection getConnection(String clUsername, String clPassword) throws SQLException {
        this.checkCredentials(clUsername, clPassword);
        return this.getConnection();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        block3: {
            if (this.isActive) {
                try {
                    PooledConnection conn = (PooledConnection)event.getSource();
                    this.provider.returnConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "GemFireConnPooledDataSource::connectionclosed:Exception =" + ex;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        block3: {
            if (this.isActive) {
                try {
                    PooledConnection conn = (PooledConnection)event.getSource();
                    this.provider.returnAndExpireConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "GemFireConnPooledDataSource::connectionErrorOccured:error in returning and expiring connection due to " + ex;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected boolean validateConnection(Connection conn) {
        try {
            return !conn.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    protected Connection getSQLConnection(PooledConnection poolC) throws SQLException {
        Connection conn = poolC.getConnection();
        boolean val = this.validateConnection(conn);
        if (val) {
            return conn;
        }
        this.provider.returnAndExpireConnection(poolC);
        throw new SQLException(LocalizedStrings.GemFireConnPooledDataSource_GEMFIRECONNPOOLEDDATASOURCEGETCONNFROMCONNPOOLJAVASQLCONNECTION_OBTAINED_IS_INVALID.toLocalizedString());
    }

    public ConnectionProvider getConnectionProvider() {
        return this.provider;
    }

    @Override
    public void clearUp() {
        super.clearUp();
        this.provider.clearUp();
    }
}

