/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.datasource;

import com.gemstone.gemfire.internal.datasource.AbstractPoolCache;
import com.gemstone.gemfire.internal.datasource.ConfiguredDataSourceProperties;
import com.gemstone.gemfire.internal.datasource.PoolException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.logging.log4j.Logger;

public class ConnectionPoolCacheImpl
extends AbstractPoolCache {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -3096029291871746431L;
    private ConnectionPoolDataSource m_cpds;

    public ConnectionPoolCacheImpl(ConnectionPoolDataSource connectionpooldatasource, ConnectionEventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        super(eventListner, configs);
        this.m_cpds = connectionpooldatasource;
        this.initializePool();
    }

    @Override
    void destroyPooledConnection(Object connectionObject) {
        block2: {
            try {
                ((PooledConnection)connectionObject).removeConnectionEventListener((ConnectionEventListener)this.connEventListner);
                ((PooledConnection)connectionObject).close();
                connectionObject = null;
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("AbstractPoolcache::destroyPooledConnection:Exception in closing the connection.Ignoring it. The exeption is {}", new Object[]{ex.getMessage(), ex});
            }
        }
    }

    @Override
    public Object getNewPoolConnection() throws PoolException {
        if (this.m_cpds != null) {
            PooledConnection poolConn = null;
            try {
                poolConn = this.m_cpds.getPooledConnection(this.configProps.getUser(), this.configProps.getPassword());
            }
            catch (SQLException sqx) {
                throw new PoolException(LocalizedStrings.ConnectionPoolCacheImpl_CONNECTIONPOOLCACHEIMPLGENEWCONNECTION_EXCEPTION_IN_CREATING_NEW_POOLEDCONNECTION.toLocalizedString(), sqx);
            }
            poolConn.addConnectionEventListener((ConnectionEventListener)this.connEventListner);
            return poolConn;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ConnectionPoolCacheImpl::geNewConnection: ConnectionPoolCache not intialized with ConnectionPoolDatasource");
        }
        throw new PoolException(LocalizedStrings.ConnectionPoolCacheImpl_CONNECTIONPOOLCACHEIMPLGENEWCONNECTION_CONNECTIONPOOLCACHE_NOT_INTIALIZED_WITH_CONNECTIONPOOLDATASOURCE.toLocalizedString());
    }
}

