/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GatewayReceiverCreation
implements GatewayReceiver {
    private static final Logger logger = LogService.getLogger();
    private Cache cache;
    private String host;
    private int startPort;
    private int endPort;
    private String portRange;
    private List<GatewayTransportFilter> transFilter = new ArrayList<GatewayTransportFilter>();
    private int maxTimeBetweenPings;
    private int socketBufferSize;
    private String bindAddress;
    private boolean manualStart;
    private CacheServer receiver;

    public GatewayReceiverCreation(Cache cache, int startPort, int endPort, int timeBetPings, int buffSize, String bindAdd, List<GatewayTransportFilter> filters, String hostnameForSenders, boolean manualStart) {
        this.cache = cache;
        if (hostnameForSenders == null || hostnameForSenders.isEmpty()) {
            if (bindAdd == null || bindAdd.isEmpty()) {
                try {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayReceiverImpl_USING_LOCAL_HOST));
                    this.host = SocketCreator.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException(LocalizedStrings.GatewayReceiverImpl_COULD_NOT_GET_HOST_NAME.toLocalizedString(), e);
                }
            } else {
                this.host = bindAdd;
            }
        } else {
            this.host = hostnameForSenders;
        }
        this.startPort = startPort;
        this.endPort = endPort;
        this.maxTimeBetweenPings = timeBetPings;
        this.socketBufferSize = buffSize;
        this.bindAddress = bindAdd;
        this.transFilter = filters;
        this.manualStart = manualStart;
    }

    @Override
    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.transFilter;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maxTimeBetweenPings;
    }

    @Override
    public int getPort() {
        return this.startPort;
    }

    public String getPortRange() {
        return this.portRange;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setMaximumTimeBetweenPings(int time) {
        this.maxTimeBetweenPings = time;
    }

    public void setStartPort(int port) {
        this.startPort = port;
    }

    public void setEndPort(int port) {
        this.endPort = port;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    @Override
    public void start() throws IOException {
        if (this.receiver == null) {
            this.receiver = ((CacheCreation)this.cache).addCacheServer(true);
            this.receiver.setPort(this.endPort + 1);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    public void addGatewayTransportFilter(GatewayTransportFilter filter) {
        this.transFilter.add(filter);
    }

    @Override
    public int getStartPort() {
        return this.startPort;
    }

    @Override
    public int getEndPort() {
        return this.endPort;
    }

    @Override
    public boolean isManualStart() {
        return this.manualStart;
    }

    @Override
    public CacheServer getServer() {
        return null;
    }
}

