/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.Logger;

public class ParallelGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    final int index;
    final int nDispatcher;

    protected ParallelGatewaySenderEventProcessor(AbstractGatewaySender sender) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId(), logger), "Event Processor for GatewaySender_" + sender.getId(), sender);
        this.index = 0;
        this.nDispatcher = 1;
        this.initializeMessageQueue(sender.getId());
        this.setDaemon(true);
    }

    protected ParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, Set<Region> userRegions, int id, int nDispatcher) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId(), logger), "Event Processor for GatewaySender_" + sender.getId() + "_" + id, sender);
        this.index = id;
        this.nDispatcher = nDispatcher;
        this.initializeMessageQueue(sender.getId());
        this.setDaemon(true);
    }

    @Override
    protected void initializeMessageQueue(String id) {
        HashSet<Region> targetRs = new HashSet<Region>();
        for (LocalRegion region : ((GemFireCacheImpl)this.sender.getCache()).getApplicationRegions()) {
            if (!region.getAllGatewaySenderIds().contains(id)) continue;
            targetRs.add(region);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The target Regions are(PGSEP) {}", new Object[]{targetRs});
        }
        ParallelGatewaySenderQueue queue = this.sender.getIsHDFSQueue() ? new HDFSParallelGatewaySenderQueue(this.sender, targetRs, this.index, this.nDispatcher) : new ParallelGatewaySenderQueue(this.sender, targetRs, this.index, this.nDispatcher);
        queue.start();
        this.queue = queue;
        if (queue.localSize() > 0) {
            queue.notifyEventProcessorIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        block10: {
            GatewaySenderEventImpl gatewayQueueEvent = null;
            Region region = event.getRegion();
            if (!(region instanceof DistributedRegion) && ((EntryEventImpl)event).getTailKey() == -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ParallelGatewaySenderEventProcessor not enqueing the following event since tailKey is not set. {}", new Object[]{event});
                }
                return;
            }
            try {
                EventID eventID = ((EntryEventImpl)event).getEventId();
                gatewayQueueEvent = !this.sender.getIsHDFSQueue() ? new GatewaySenderEventImpl(operation, event, substituteValue, true, eventID.getBucketID()) : new HDFSGatewayEventImpl(operation, event, substituteValue, true, eventID.getBucketID());
                if (this.getSender().beforeEnqueue(gatewayQueueEvent)) {
                    long start = this.getSender().getStatistics().startTime();
                    try {
                        this.queue.put(gatewayQueueEvent);
                        gatewayQueueEvent = null;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.getSender().getStatistics().endPut(start);
                    break block10;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("The Event {} is filtered.", new Object[]{gatewayQueueEvent});
                }
                this.getSender().getStatistics().incEventsFiltered();
            }
            finally {
                if (gatewayQueueEvent != null) {
                    gatewayQueueEvent.release();
                }
            }
        }
    }

    @Override
    public void clear(PartitionedRegion pr, int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).clear(pr, bucketId);
    }

    @Override
    public void notifyEventProcessorIfRequired(int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).notifyEventProcessorIfRequired();
    }

    @Override
    public BlockingQueue<GatewaySenderEventImpl> getBucketTmpQueue(int bucketId) {
        return ((ParallelGatewaySenderQueue)this.queue).getBucketToTempQueueMap().get(bucketId);
    }

    @Override
    public PartitionedRegion getRegion(String prRegionName) {
        return ((ParallelGatewaySenderQueue)this.queue).getRegion(prRegionName);
    }

    @Override
    public void removeShadowPR(String prRegionName) {
        ((ParallelGatewaySenderQueue)this.queue).removeShadowPR(prRegionName);
    }

    @Override
    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        ((ParallelGatewaySenderQueue)this.queue).conflateEvent(conflatableObject, bucketId, tailKey);
    }

    public HDFSGatewayEventImpl get(PartitionedRegion region, byte[] regionKey, int bucketId) throws ForceReattemptException {
        return ((HDFSParallelGatewaySenderQueue)this.queue).get(region, regionKey, bucketId);
    }

    public HDFSBucketRegionQueue getBucketRegionQueue(PartitionedRegion region, int bucketId) throws ForceReattemptException {
        return ((HDFSParallelGatewaySenderQueue)this.queue).getBucketRegionQueue(region, bucketId);
    }

    @Override
    public void addShadowPartitionedRegionForUserPR(PartitionedRegion pr) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserPR(pr);
    }

    @Override
    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserRR(userRegion);
    }

    @Override
    protected void rebalance() {
    }

    @Override
    public void initializeEventDispatcher() {
        if (logger.isDebugEnabled()) {
            logger.debug(" Creating the GatewayEventCallbackDispatcher");
        }
        this.dispatcher = new GatewaySenderEventCallbackDispatcher(this);
    }
}

