/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ConcurrentParallelGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    protected static final Logger logger = LogService.getLogger();
    protected ParallelGatewaySenderEventProcessor[] processors;
    private GemFireException ex = null;
    final int nDispatcher;

    public ConcurrentParallelGatewaySenderEventProcessor(AbstractGatewaySender sender) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId()), "Event Processor for GatewaySender_" + sender.getId(), sender);
        logger.info("ConcurrentParallelGatewaySenderEventProcessor: dispatcher threads {}", new Object[]{sender.getDispatcherThreads()});
        this.nDispatcher = sender.getDispatcherThreads();
        HashSet<Region> targetRs = new HashSet<Region>();
        for (LocalRegion pr : ((GemFireCacheImpl)sender.getCache()).getApplicationRegions()) {
            if (!pr.getAllGatewaySenderIds().contains(sender.getId())) continue;
            targetRs.add(pr);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The target PRs are {} Dispatchers: {}", new Object[]{targetRs, this.nDispatcher});
        }
        this.createProcessors(sender.getDispatcherThreads(), targetRs);
        this.queue = new ConcurrentParallelGatewaySenderQueue(this.processors);
        this.setDaemon(true);
    }

    protected void createProcessors(int dispatcherThreads, Set<Region> targetRs) {
        this.processors = new ParallelGatewaySenderEventProcessor[this.sender.getDispatcherThreads()];
        if (logger.isDebugEnabled()) {
            logger.debug("Creating AsyncEventProcessor");
        }
        for (int i = 0; i < this.sender.getDispatcherThreads(); ++i) {
            this.processors[i] = new ParallelGatewaySenderEventProcessor(this.sender, targetRs, i, this.sender.getDispatcherThreads());
        }
    }

    @Override
    protected void initializeMessageQueue(String id) {
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        Region region = event.getRegion();
        int bucketId = ((EntryEventImpl)event).getEventId().getBucketID();
        if (bucketId < 0) {
            return;
        }
        int pId = bucketId % this.nDispatcher;
        this.processors[pId].enqueueEvent(operation, event, substituteValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (int i = 0; i < this.processors.length; ++i) {
            if (isDebugEnabled) {
                logger.debug("Starting the ParallelProcessors {}", new Object[]{i});
            }
            this.processors[i].start();
        }
        try {
            this.waitForRunningStatus();
        }
        catch (GatewaySenderException e) {
            this.ex = e;
        }
        ParallelGatewaySenderEventProcessor[] parallelGatewaySenderEventProcessorArray = this.runningStateLock;
        synchronized (this.runningStateLock) {
            if (this.ex != null) {
                this.setException(this.ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.runningStateLock.notifyAll();
            // ** MonitorExit[var2_4] (shouldn't be in output)
            for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
                try {
                    parallelProcessor.join();
                }
                catch (InterruptedException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("Got InterruptedException while waiting for child threads to finish.");
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunningStatus() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            Object object = parallelProcessor.runningStateLock;
            synchronized (object) {
                while (parallelProcessor.getException() == null && parallelProcessor.isStopped()) {
                    try {
                        parallelProcessor.runningStateLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                Exception ex = parallelProcessor.getException();
                if (ex != null) {
                    throw new GatewaySenderException(LocalizedStrings.Sender_COULD_NOT_START_GATEWAYSENDER_0_BECAUSE_OF_EXCEPTION_1.toLocalizedString(this.getId(), ex.getMessage()), ex.getCause());
                }
            }
        }
    }

    @Override
    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        final LoggingThreadGroup loggingThreadGroup = LoggingThreadGroup.createThreadGroup("ConcurrentParallelGatewaySenderEventProcessor Logger Group", logger);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(loggingThreadGroup, task, "ConcurrentParallelGatewaySenderEventProcessor Stopper Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable> stopperCallables = new ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable>();
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            stopperCallables.add(new AbstractGatewaySenderEventProcessor.SenderStopperCallable(parallelProcessor));
        }
        ExecutorService stopperService = Executors.newFixedThreadPool(this.processors.length, threadFactory);
        try {
            List futures = stopperService.invokeAll(stopperCallables);
            for (Future f : futures) {
                try {
                    Boolean b = (Boolean)f.get();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("ConcurrentParallelGatewaySenderEventProcessor: {} stopped dispatching: {}", new Object[]{b != false ? "Successfully" : "Unsuccesfully", this});
                }
                catch (ExecutionException e) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewaySender_0_CAUGHT_EXCEPTION_WHILE_STOPPING_1, this.sender), e.getCause());
                }
            }
        }
        catch (InterruptedException e) {
            throw new InternalGemFireException(e.getMessage());
        }
        catch (RejectedExecutionException rejectedExecutionEx) {
            throw rejectedExecutionEx;
        }
        this.setIsStopped(true);
        stopperService.shutdown();
        this.closeProcessor();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Stopped dispatching: {}", new Object[]{this});
        }
    }

    @Override
    public void closeProcessor() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.closeProcessor();
        }
    }

    @Override
    public void pauseDispatching() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.pauseDispatching();
        }
        super.pauseDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Paused dispatching: {}", new Object[]{this});
        }
    }

    @Override
    public void waitForDispatcherToPause() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.waitForDispatcherToPause();
        }
    }

    @Override
    public void resumeDispatching() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.resumeDispatching();
        }
        super.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Resumed dispatching: {}", new Object[]{this});
        }
    }

    @Override
    protected void waitForResumption() throws InterruptedException {
        super.waitForResumption();
    }

    public List<ParallelGatewaySenderEventProcessor> getProcessors() {
        LinkedList<ParallelGatewaySenderEventProcessor> l = new LinkedList<ParallelGatewaySenderEventProcessor>();
        for (int i = 0; i < this.processors.length; ++i) {
            l.add(this.processors[i]);
        }
        return l;
    }

    @Override
    public RegionQueue getQueue() {
        return this.queue;
    }

    @Override
    public GatewaySenderEventDispatcher getDispatcher() {
        return this.processors[0].getDispatcher();
    }

    @Override
    protected void rebalance() {
    }

    @Override
    public void initializeEventDispatcher() {
    }
}

