/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GatewaySenderEventCallbackDispatcher
implements GatewaySenderEventDispatcher {
    private static final Logger logger = LogService.getLogger();
    protected final AbstractGatewaySenderEventProcessor eventProcessor;
    private volatile List<AsyncEventListener> eventListeners = Collections.emptyList();
    private final Object eventLock = new Object();

    public GatewaySenderEventCallbackDispatcher(AbstractGatewaySenderEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
        this.initializeEventListeners();
    }

    @Override
    public boolean dispatchBatch(List events, boolean isRetry) {
        GatewaySenderStats statistics = this.eventProcessor.sender.getStatistics();
        boolean success = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("About to dispatch batch");
            }
            long start = statistics.startTime();
            success = this.dispatchBatch(events);
            statistics.endBatch(start, events.size());
            if (logger.isDebugEnabled()) {
                logger.debug("Done dispatching the batch");
            }
        }
        catch (GatewaySenderException start) {
        }
        catch (CancelException e) {
            this.eventProcessor.setIsStopped(true);
            throw e;
        }
        catch (Exception e) {
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.SerialGatewayEventCallbackDispatcher_STOPPING_THE_PROCESSOR_BECAUSE_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_PROCESSING_A_BATCH), (Throwable)e);
            this.eventProcessor.setIsStopped(true);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsyncEventListener(AsyncEventListener listener) {
        Object object = this.eventLock;
        synchronized (object) {
            List<AsyncEventListener> oldListeners = this.eventListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<AsyncEventListener> newListeners = new ArrayList<AsyncEventListener>(oldListeners);
                newListeners.add(listener);
                this.eventListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterGatewayEventListener(AsyncEventListener listener) {
        Object object = this.eventLock;
        synchronized (object) {
            ArrayList<AsyncEventListener> newListeners;
            List<AsyncEventListener> oldListeners = this.eventListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList<AsyncEventListener>(oldListeners)).remove(listener)) {
                this.eventListeners = newListeners;
            }
        }
    }

    protected void initializeEventListeners() {
        for (AsyncEventListener listener : this.eventProcessor.getSender().getAsyncEventListeners()) {
            this.registerAsyncEventListener(listener);
        }
    }

    protected boolean dispatchBatch(List events) throws GatewaySenderException {
        if (events.isEmpty()) {
            return true;
        }
        int batchId = this.eventProcessor.getBatchId();
        boolean successAll = true;
        try {
            for (AsyncEventListener listener : this.eventListeners) {
                boolean successOne = listener.processEvents(events);
                if (successOne) continue;
                successAll = false;
            }
        }
        catch (Exception e) {
            StringId alias = LocalizedStrings.SerialGatewayEventCallbackDispatcher__0___EXCEPTION_DURING_PROCESSING_BATCH__1_;
            Object[] aliasArgs = new Object[]{this, batchId};
            String exMsg = alias.toLocalizedString(aliasArgs);
            GatewaySenderException ge = new GatewaySenderException(exMsg, e);
            logger.warn((Message)LocalizedMessage.create(alias, aliasArgs), (Throwable)ge);
            throw ge;
        }
        return successAll;
    }

    @Override
    public boolean isRemoteDispatcher() {
        return false;
    }

    @Override
    public boolean isConnectedToRemote() {
        return false;
    }

    @Override
    public void stop() {
    }
}

