/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GatewaySenderEventCallbackArgument
extends WrappedCallbackArgument
implements DataSerializableFixedID {
    private int originatingDSId = -1;
    private Set<Integer> receipientDSIds;

    public GatewaySenderEventCallbackArgument() {
    }

    public GatewaySenderEventCallbackArgument(Object originalCallbackArg) {
        super(originalCallbackArg);
    }

    public GatewaySenderEventCallbackArgument(GatewaySenderEventCallbackArgument geca) {
        super(geca.getOriginalCallbackArg());
        this.originatingDSId = geca.originatingDSId;
        if (geca.receipientDSIds != null) {
            this.receipientDSIds = new HashSet<Integer>(geca.receipientDSIds);
        }
    }

    public GatewaySenderEventCallbackArgument(Object originalCallbackArg, int originatingDSId, List<Integer> originalReceivers, boolean serializeCBArg) {
        super(originalCallbackArg, serializeCBArg);
        this.originatingDSId = originatingDSId;
        this.initializeReceipientDSIds(originalReceivers);
    }

    public int getOriginatingDSId() {
        return this.originatingDSId;
    }

    public void setOriginatingDSId(int originatingDSId) {
        this.originatingDSId = originatingDSId;
    }

    public Set<Integer> getRecipientDSIds() {
        return this.receipientDSIds;
    }

    public void initializeReceipientDSIds(List<Integer> originalGatewaysReceivers) {
        this.receipientDSIds = new HashSet<Integer>();
        for (Integer id : originalGatewaysReceivers) {
            this.receipientDSIds.add(id);
        }
    }

    @Override
    public int getDSFID() {
        return -135;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeInteger(this.originatingDSId, out);
        if (this.receipientDSIds != null) {
            out.writeInt(this.receipientDSIds.size());
            for (Integer gateway : this.receipientDSIds) {
                out.writeInt(gateway);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.originatingDSId = DataSerializer.readInteger(in);
        this.receipientDSIds = new HashSet<Integer>();
        int numberOfRecipientGateways = in.readInt();
        for (int i = 0; i < numberOfRecipientGateways; ++i) {
            this.receipientDSIds.add(in.readInt());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewaySenderEventCallbackArgument [").append("originalCallbackArg=").append(this.getOriginalCallbackArg()).append(";originatingSenderId=").append(this.originatingDSId).append(";recipientGatewayReceivers=").append(this.receipientDSIds).append("]");
        return buffer.toString();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

