/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.versions;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataSerializable;
import com.gemstone.gemfire.internal.cache.versions.RVVExceptionB;
import com.gemstone.gemfire.internal.cache.versions.RVVExceptionT;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

abstract class RVVException
implements Comparable<RVVException>,
Cloneable,
VersionedDataSerializable {
    protected static boolean UseTreeSetsForTesting = false;
    protected static final long RVV_MAX_BITSET_SPAN = 1024L;
    long previousVersion;
    long nextVersion;

    static RVVException createException(long previousVersion, long nextVersion) {
        return RVVException.createException(previousVersion, nextVersion, 0L);
    }

    static RVVException createException(long previousVersion, long nextVersion, long initialExceptionCount) {
        long delta = nextVersion - previousVersion;
        if (UseTreeSetsForTesting || delta > 1024L && initialExceptionCount * 512L < delta) {
            return new RVVExceptionT(previousVersion, nextVersion);
        }
        return new RVVExceptionB(previousVersion, nextVersion);
    }

    RVVException(long previousVersion, long nextVersion) {
        this.previousVersion = previousVersion;
        this.nextVersion = nextVersion;
    }

    static RVVException createException(DataInput in) throws IOException {
        long previousVersion = InternalDataSerializer.readUnsignedVL(in);
        int size = (int)InternalDataSerializer.readUnsignedVL(in);
        long last = previousVersion;
        long[] versions = new long[size];
        for (int i = 0; i < size; ++i) {
            long value;
            long delta = InternalDataSerializer.readUnsignedVL(in);
            versions[i] = value = delta + last;
            last = value;
        }
        long delta = InternalDataSerializer.readUnsignedVL(in);
        long nextVersion = last + delta;
        RVVException result = RVVException.createException(previousVersion, nextVersion, size);
        for (int i = 0; i < size; ++i) {
            result.addReceived(versions[i]);
        }
        return result;
    }

    public abstract boolean contains(long var1);

    public abstract boolean isEmpty();

    protected abstract void addReceived(long var1);

    @Override
    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.writeUnsignedVL(this.previousVersion, out);
        this.writeReceived(out);
    }

    public abstract void add(long var1);

    public boolean isFilled() {
        return this.previousVersion + 1L >= this.nextVersion;
    }

    public abstract RVVException clone();

    @Override
    public int compareTo(RVVException o) {
        long thisVal = this.previousVersion;
        long anotherVal = o.previousVersion;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public boolean sameAs(RVVException other) {
        return this.previousVersion == other.previousVersion && this.nextVersion == other.nextVersion;
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("change the test to use sameAs");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("this class does not support hashing at this time");
    }

    protected abstract void writeReceived(DataOutput var1) throws IOException;

    public abstract ReceivedVersionsIterator receivedVersionsIterator();

    public abstract long getHighestReceivedVersion();

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public boolean shouldChangeForm() {
        return false;
    }

    public RVVException changeForm() {
        throw new IllegalStateException("Should not be called");
    }

    public abstract class ReceivedVersionsIterator {
        abstract boolean hasNext();

        abstract long next();

        abstract void remove();
    }
}

