/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.operations.UnregisterInterestOperationContext;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UnregisterInterestList
extends BaseCommand {
    private static final UnregisterInterestList singleton = new UnregisterInterestList();

    public static Command getCommand() {
        return singleton;
    }

    private UnregisterInterestList() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part numberOfKeysPart = null;
        String regionName = null;
        Object key = null;
        List<Object> keys = null;
        int numberOfKeys = 0;
        int partNumber = 0;
        servConn.setAsTrue(2);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        Part isClosingListPart = msg.getPart(1);
        byte[] isClosingListPartBytes = (byte[])isClosingListPart.getObject();
        boolean isClosingList = isClosingListPartBytes[0] == 1;
        boolean keepalive = false;
        try {
            Part keepalivePart = msg.getPart(2);
            byte[] keepalivePartBytes = (byte[])keepalivePart.getObject();
            keepalive = keepalivePartBytes[0] == 1;
        }
        catch (Exception e) {
            UnregisterInterestList.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        numberOfKeysPart = msg.getPart(3);
        numberOfKeys = numberOfKeysPart.getInt();
        partNumber = 4;
        keys = new ArrayList<Object>();
        for (int i = 0; i < numberOfKeys; ++i) {
            keyPart = msg.getPart(partNumber + i);
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                UnregisterInterestList.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            keys.add(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for the following {} keys in region {}: {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), numberOfKeys, regionName, keys});
        }
        if (keys.isEmpty() || regionName == null) {
            StringId errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = LocalizedStrings.UnRegisterInterestList_THE_INPUT_LIST_OF_KEYS_IS_EMPTY_AND_THE_INPUT_REGION_NAME_IS_NULL_FOR_THE_UNREGISTER_INTEREST_REQUEST;
            } else if (keys.isEmpty()) {
                errMessage = LocalizedStrings.UnRegisterInterestList_THE_INPUT_LIST_OF_KEYS_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_EMPTY;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", new Object[]{servConn.getName(), s});
            UnregisterInterestList.writeErrorResponse(msg, 23, s, servConn);
            servConn.setAsTrue(1);
        } else {
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                try {
                    UnregisterInterestOperationContext unregisterContext = authzRequest.unregisterInterestListAuthorize(regionName, keys);
                    keys = (List)unregisterContext.getKey();
                }
                catch (NotAuthorizedException ex) {
                    UnregisterInterestList.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
            servConn.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, keys, isClosingList, servConn.getProxyID(), keepalive);
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent unregister interest response for the following {} keys in region {}: {}", new Object[]{servConn.getName(), numberOfKeys, regionName, keys});
            }
        }
    }
}

