/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.WaitForViewInstallation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.FindRemoteTXMessage;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PeerTXStateStub;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class TXFailoverCommand
extends BaseCommand {
    private static final Command singleton = new TXFailoverCommand();

    public static Command getCommand() {
        return singleton;
    }

    private TXFailoverCommand() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        servConn.setAsTrue(2);
        InternalDistributedMember client = (InternalDistributedMember)servConn.getProxyID().getDistributedMember();
        int uniqId = msg.getTransactionId();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: Transaction {} from {} is failing over to this server", new Object[]{uniqId, client});
        }
        TXId txId = new TXId(client, uniqId);
        TXManagerImpl mgr = (TXManagerImpl)servConn.getCache().getCacheTransactionManager();
        mgr.waitForCompletingTransaction(txId);
        if (mgr.isHostedTxRecentlyCompleted(txId)) {
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            mgr.removeHostedTXState(txId);
            return;
        }
        boolean wasInProgress = mgr.setInProgress(true);
        TXStateProxy tx = mgr.getTXState();
        Assert.assertTrue(tx != null);
        if (!tx.isRealDealLocal()) {
            FindRemoteTXMessage.FindRemoteTXMessageReplyProcessor processor = FindRemoteTXMessage.send(servConn.getCache(), txId);
            try {
                processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleAsUnexpected();
            }
            InternalDistributedMember hostingMember = processor.getHostingMember();
            if (hostingMember != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TX: txState is not local, bootstrapping PeerTXState stub for targetNode: {}", new Object[]{hostingMember});
                }
                tx.setLocalTXState(new PeerTXStateStub(tx, hostingMember, client));
            } else {
                GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
                try {
                    WaitForViewInstallation.send((DistributionManager)cache.getDistributionManager());
                }
                catch (InterruptedException e) {
                    cache.getDistributionManager().getCancelCriterion().checkCancelInProgress(e);
                    Thread.currentThread().interrupt();
                }
                if (processor.getTxCommitMessage() != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("TX: for txId: {} rebuilt a recently completed tx", new Object[]{txId});
                    }
                    mgr.saveTXCommitMessageForClientFailover(txId, processor.getTxCommitMessage());
                } else {
                    TXFailoverCommand.writeException(msg, new TransactionDataNodeHasDepartedException("Could not find transaction host for " + txId), false, servConn);
                    servConn.setAsTrue(1);
                    mgr.removeHostedTXState(txId);
                    return;
                }
            }
        }
        if (!wasInProgress) {
            mgr.setInProgress(false);
        }
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
    }
}

