/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.Invalidate;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.io.IOException;

public class Invalidate70
extends Invalidate {
    private static final Invalidate70 singleton = new Invalidate70();

    public static Command getCommand() {
        return singleton;
    }

    private Invalidate70() {
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 2;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags);
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        pr.getPrStats().incPRMetaDataSentCount();
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", new Object[]{servConn.getName(), origMsg.getTransactionId()});
        }
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 2;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags);
        if (versionTag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("wrote version tag in response: {}", new Object[]{versionTag});
            }
            replyMsg.addObjPart(versionTag);
        } else if (logger.isDebugEnabled()) {
            logger.debug("response has no version tag");
        }
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", new Object[]{servConn.getName(), origMsg.getTransactionId(), replyMsg.getNumberOfParts()});
        }
    }
}

