/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.pdx.internal.PdxType;
import java.io.IOException;
import java.util.Map;

public class GetPdxTypes70
extends BaseCommand {
    private static final GetPdxTypes70 singleton = new GetPdxTypes70();

    public static Command getCommand() {
        return singleton;
    }

    private GetPdxTypes70() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        Map<Integer, PdxType> types;
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx types from {}", new Object[]{servConn.getName(), servConn.getSocketString()});
        }
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            types = cache.getPdxRegistry().typeMap();
        }
        catch (Exception e) {
            GetPdxTypes70.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(msg.getTransactionId());
        responseMsg.addObjPart(types);
        responseMsg.send(servConn);
        servConn.setAsTrue(1);
    }
}

