/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import java.io.IOException;
import java.util.Map;

public class GetPdxEnums70
extends BaseCommand {
    private static final GetPdxEnums70 singleton = new GetPdxEnums70();

    public static Command getCommand() {
        return singleton;
    }

    private GetPdxEnums70() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        Map<Integer, EnumInfo> enums;
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx enums from {}", new Object[]{servConn.getName(), servConn.getSocketString()});
        }
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            enums = cache.getPdxRegistry().enumMap();
        }
        catch (Exception e) {
            GetPdxEnums70.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(msg.getTransactionId());
        responseMsg.addObjPart(enums);
        responseMsg.send(servConn);
        servConn.setAsTrue(1);
    }
}

