/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.IOException;

public class GetPDXEnumById
extends BaseCommand {
    private static final GetPDXEnumById singleton = new GetPDXEnumById();

    public static Command getCommand() {
        return singleton;
    }

    private GetPDXEnumById() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        EnumInfo result;
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx enum by id request ({} parts) from {}", new Object[]{servConn.getName(), msg.getNumberOfParts(), servConn.getSocketString()});
        }
        int enumId = msg.getPart(0).getInt();
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            result = registry.getEnumInfoById(enumId);
        }
        catch (Exception e) {
            GetPDXEnumById.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(msg.getTransactionId());
        responseMsg.addObjPart(result);
        responseMsg.send(servConn);
        servConn.setAsTrue(1);
    }
}

