/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList651;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.Request;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class GetAll651
extends BaseCommand {
    private static final GetAll651 singleton = new GetAll651();

    public static Command getCommand() {
        return singleton;
    }

    protected GetAll651() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keysPart = null;
        String regionName = null;
        Object[] keys = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        keysPart = msg.getPart(1);
        try {
            keys = (Object[])keysPart.getObject();
        }
        catch (Exception e) {
            GetAll651.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(servConn.getName()).append(": Received getAll request (").append(msg.getPayloadLength()).append(" bytes) from ").append(servConn.getSocketString()).append(" for region ").append(regionName).append(" keys ");
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    buffer.append(keys[i]).append(" ");
                }
            } else {
                buffer.append("NULL");
            }
            logger.debug(buffer.toString());
        }
        if (regionName == null) {
            String message = null;
            message = LocalizedStrings.GetAll_THE_INPUT_REGION_NAME_FOR_THE_GETALL_REQUEST_IS_NULL.toLocalizedString();
            logger.warn("{}: {}", new Object[]{servConn.getName(), message});
            GetAll651.writeChunkedErrorResponse(msg, 58, message, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during getAll request";
                GetAll651.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
                chunkedResponseMsg.setMessageType(1);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                try {
                    this.fillAndSendGetAllResponseChunks(region, regionName, keys, servConn);
                    servConn.setAsTrue(1);
                }
                catch (Exception e) {
                    GetAll651.checkForInterrupt(servConn, e);
                    GetAll651.writeChunkedException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
        }
    }

    private void fillAndSendGetAllResponseChunks(Region region, String regionName, Object[] keys, ServerConnection servConn) throws IOException {
        int numKeys;
        Iterator allKeysIter;
        if (keys != null) {
            allKeysIter = null;
            numKeys = keys.length;
        } else {
            Set allKeys = region.keySet();
            allKeysIter = allKeys.iterator();
            numKeys = allKeys.size();
        }
        ObjectPartList651 values = this.getObjectPartsList(keys == null);
        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
        AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
        Request request = (Request)Request.getCommand();
        Object[] valueAndIsObject = new Object[3];
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (int i = 0; i < numKeys; ++i) {
            boolean isObject;
            Object value;
            Object key;
            boolean keyNotPresent;
            block16: {
                GetOperationContext getContext;
                block15: {
                    if (values.size() == maximumChunkSize) {
                        GetAll651.sendGetAllResponseChunk(region, values, false, servConn);
                        values.clear();
                    }
                    keyNotPresent = false;
                    key = keys != null ? keys[i] : allKeysIter.next();
                    if (isDebugEnabled) {
                        logger.debug("{}: Getting value for key={}", new Object[]{servConn.getName(), key});
                    }
                    getContext = null;
                    if (authzRequest != null) {
                        try {
                            getContext = authzRequest.getAuthorize(regionName, key, null);
                            if (!isDebugEnabled) break block15;
                            logger.debug("{}: Passed GET pre-authorization for key={}", new Object[]{servConn.getName(), key});
                        }
                        catch (NotAuthorizedException ex) {
                            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key}), (Throwable)ex);
                            values.addExceptionPart(key, ex);
                            continue;
                        }
                    }
                }
                request.getValueAndIsObject(region, key, null, servConn, valueAndIsObject);
                value = valueAndIsObject[0];
                isObject = (Boolean)valueAndIsObject[1];
                keyNotPresent = (Boolean)valueAndIsObject[2];
                if (isDebugEnabled) {
                    logger.debug("{}: Retrieved value for key={}: {}", new Object[]{servConn.getName(), key, value});
                }
                if (postAuthzRequest != null) {
                    try {
                        getContext = postAuthzRequest.getAuthorize(regionName, key, value, isObject, getContext);
                        byte[] serializedValue = getContext.getSerializedValue();
                        value = serializedValue == null ? getContext.getObject() : (Object)serializedValue;
                        isObject = getContext.isObject();
                        if (!isDebugEnabled) break block16;
                        logger.debug("{}: Passed GET post-authorization for key={}: {}", new Object[]{servConn.getName(), key, value});
                    }
                    catch (NotAuthorizedException ex) {
                        logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key}), (Throwable)ex);
                        values.addExceptionPart(key, ex);
                        continue;
                    }
                }
            }
            if (isDebugEnabled) {
                logger.debug("{}: Returning value for key={}: {}", new Object[]{servConn.getName(), key, value});
            }
            if (keyNotPresent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: key={} is not present on server.", new Object[]{servConn.getName(), key});
                }
                values.addObjectPartForAbsentKey(key, value);
                continue;
            }
            values.addObjectPart(key, value, isObject, null);
        }
        GetAll651.sendGetAllResponseChunk(region, values, true, servConn);
        servConn.setAsTrue(1);
    }

    protected ObjectPartList651 getObjectPartsList(boolean includeKeys) {
        ObjectPartList651 values = new ObjectPartList651(maximumChunkSize, includeKeys);
        return values;
    }

    private static void sendGetAllResponseChunk(Region region, ObjectPartList651 list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} getAll response chunk for region={} values={} chunk=<{}>", new Object[]{servConn.getName(), lastChunk ? " last " : " ", region.getFullPath(), list, chunkedResponseMsg});
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

