/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.operations.ExecuteFunctionOperationContext;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.PartitionedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender65;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.HashSet;

public class ExecuteRegionFunction66
extends BaseCommand {
    private static final ExecuteRegionFunction66 singleton = new ExecuteRegionFunction66();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteRegionFunction66() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        byte isReExecute;
        boolean isBucketsAsFilter;
        String regionName = null;
        Object function = null;
        Object args = null;
        MemberMappedArgument memberMappedArg = null;
        HashSet<Object> filter = null;
        byte hasResult = 0;
        int removedNodesSize = 0;
        HashSet<Object> removedNodesSet = null;
        int filterSize = 0;
        int partNumber = 0;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        byte functionState = 0;
        int functionTimeout = 0;
        try {
            int i;
            Object obj;
            byte[] bytes = msg.getPart(0).getSerializedForm();
            functionState = bytes[0];
            if (bytes.length >= 5 && servConn.getClientVersion().ordinal() >= Version.GFE_8009.ordinal()) {
                functionTimeout = Part.decodeInt(bytes, 1);
            }
            if ((hasResult = functionState != 1 ? (byte)((functionState & 2) - 1) : functionState) == 1) {
                servConn.setAsTrue(2);
                servConn.setAsTrue(3);
            }
            regionName = msg.getPart(1).getString();
            function = msg.getPart(2).getStringOrObject();
            args = msg.getPart(3).getObject();
            Part part = msg.getPart(4);
            if (part != null && (obj = part.getObject()) instanceof MemberMappedArgument) {
                memberMappedArg = (MemberMappedArgument)obj;
            }
            byte[] flags = msg.getPart(5).getSerializedForm();
            if (servConn.getClientVersion().ordinal() > Version.GFE_81.ordinal()) {
                isBucketsAsFilter = (flags[0] & 2) != 0;
                isReExecute = (flags[0] & 1) != 0 ? (byte)1 : 0;
            } else {
                isReExecute = flags[0];
                isBucketsAsFilter = false;
            }
            filterSize = msg.getPart(6).getInt();
            if (filterSize != 0) {
                filter = new HashSet<Object>();
                partNumber = 7;
                for (i = 0; i < filterSize; ++i) {
                    filter.add(msg.getPart(partNumber + i).getStringOrObject());
                }
            }
            if ((removedNodesSize = msg.getPart(partNumber = 7 + filterSize).getInt()) != 0) {
                removedNodesSet = new HashSet<Object>();
                ++partNumber;
                for (i = 0; i < removedNodesSize; ++i) {
                    removedNodesSet.add(msg.getPart(partNumber + i).getStringOrObject());
                }
            }
        }
        catch (ClassNotFoundException exception) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
            if (hasResult == 1) {
                ExecuteRegionFunction66.writeChunkedException(msg, exception, false, servConn);
            } else {
                ExecuteRegionFunction66.writeException(msg, exception, false, servConn);
            }
            servConn.setAsTrue(1);
            return;
        }
        if (function == null || regionName == null) {
            String message = null;
            if (function == null) {
                message = LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("function");
            }
            if (regionName == null) {
                message = LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("region");
            }
            logger.warn("{}: {}", new Object[]{servConn.getName(), message});
            this.sendError(hasResult, msg, message, servConn);
            return;
        }
        Region region = crHelper.getRegion(regionName);
        if (region == null) {
            String message = LocalizedStrings.ExecuteRegionFunction_THE_REGION_NAMED_0_WAS_NOT_FOUND_DURING_EXECUTE_FUNCTION_REQUEST.toLocalizedString(regionName);
            logger.warn("{}: {}", new Object[]{servConn.getName(), message});
            this.sendError(hasResult, msg, message, servConn);
            return;
        }
        HandShake handShake = (HandShake)servConn.getHandshake();
        int earlierClientReadTimeout = handShake.getClientReadTimeout();
        handShake.setClientReadTimeout(functionTimeout);
        ServerToClientFunctionResultSender resultSender = null;
        Function functionObject = null;
        try {
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = LocalizedStrings.ExecuteRegionFunction_THE_FUNCTION_0_HAS_NOT_BEEN_REGISTERED.toLocalizedString(function);
                    logger.warn("{}: {}", new Object[]{servConn.getName(), message});
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
                byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                if (logger.isDebugEnabled()) {
                    logger.debug("Function State on server side: {} on client: {}", new Object[]{functionStateOnServerSide, functionState});
                }
                if (functionStateOnServerSide != functionState) {
                    String message = LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(function);
                    logger.warn("{}: {}", new Object[]{servConn.getName(), message});
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            String functionName = functionObject.getId();
            String regionPath = region.getFullPath();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionName, regionPath, filter, args, functionObject.optimizeForWrite());
            }
            AbstractExecution execution = (AbstractExecution)FunctionService.onRegion(region);
            ChunkedMessage m = servConn.getFunctionResponseMessage();
            m.setTransactionId(msg.getTransactionId());
            resultSender = new ServerToClientFunctionResultSender65(m, 60, servConn, functionObject, executeContext);
            if (execution instanceof PartitionedRegionFunctionExecutor) {
                if (hasResult == 1 && filter != null && filter.size() == 1) {
                    ServerConnection.executeFunctionOnLocalNodeOnly((byte)1);
                }
                execution = new PartitionedRegionFunctionExecutor((PartitionedRegion)region, filter, args, memberMappedArg, resultSender, removedNodesSet, isBucketsAsFilter);
            } else {
                execution = new DistributedRegionFunctionExecutor((DistributedRegion)region, filter, args, memberMappedArg, resultSender);
            }
            if (isReExecute == 1) {
                execution = execution.setIsReExecute();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on Server: {} with Execution: {} functionState={} reExecute={} hasResult={}", new Object[]{functionObject.getId(), servConn, execution, functionState, isReExecute, hasResult});
            }
            if (hasResult == 1) {
                if (function instanceof String) {
                    switch (functionState) {
                        case 2: {
                            execution.execute((String)function, true, false, false).getResult();
                            break;
                        }
                        case 3: {
                            execution.execute((String)function, true, true, false).getResult();
                            break;
                        }
                        case 7: {
                            execution.execute((String)function, true, true, true).getResult();
                            break;
                        }
                        case 6: {
                            execution.execute((String)function, true, false, true).getResult();
                        }
                    }
                } else {
                    execution.execute(functionObject).getResult();
                }
            } else {
                if (function instanceof String) {
                    switch (functionState) {
                        case 0: {
                            execution.execute((String)function, false, false, false);
                            break;
                        }
                        case 4: {
                            execution.execute((String)function, false, false, true);
                        }
                    }
                } else {
                    execution.execute(functionObject);
                }
                this.writeReply(msg, servConn);
            }
        }
        catch (IOException ioe) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioe);
            String message = LocalizedStrings.ExecuteRegionFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
            this.sendException(hasResult, msg, message, servConn, ioe);
        }
        catch (FunctionException fe) {
            String message = fe.getMessage();
            Throwable cause = fe.getCause();
            if (cause instanceof FunctionInvocationTargetException || cause instanceof QueryInvocationTargetException) {
                if (cause instanceof InternalFunctionInvocationTargetException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{function}), (Throwable)fe);
                    }
                } else if (functionObject.isHA()) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function + " :" + message));
                } else {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)fe);
                }
                resultSender.setException(fe);
            } else {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)fe);
                this.sendException(hasResult, msg, message, servConn, fe);
            }
        }
        catch (Exception e) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
            String message = e.getMessage();
            this.sendException(hasResult, msg, message, servConn, e);
        }
        finally {
            handShake.setClientReadTimeout(earlierClientReadTimeout);
            ServerConnection.executeFunctionOnLocalNodeOnly((byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(byte hasResult, Message msg, String message, ServerConnection servConn, Throwable e) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction66.writeFunctionResponseException(msg, 2, message, servConn, e);
            } else {
                ExecuteRegionFunction66.writeException(msg, e, false, servConn);
            }
            servConn.setAsTrue(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(byte hasResult, Message msg, String message, ServerConnection servConn) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction66.writeFunctionResponseError(msg, 61, message, servConn);
            } else {
                ExecuteRegionFunction66.writeErrorResponse(msg, 61, message, servConn);
            }
            servConn.setAsTrue(1);
        }
    }

    protected static void writeFunctionResponseException(Message origMsg, int messageType2, String message, ServerConnection servConn, Throwable e) throws IOException {
        ChunkedMessage functionResponseMsg = servConn.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        int numParts = 0;
        if (functionResponseMsg.headerHasBeenSent()) {
            if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
                functionResponseMsg.setNumberOfParts(3);
                functionResponseMsg.addObjPart(e);
                functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
                functionResponseMsg.addObjPart(fe.getFailedNodeSet());
                numParts = 3;
            } else {
                functionResponseMsg.setNumberOfParts(2);
                functionResponseMsg.addObjPart(e);
                functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                numParts = 2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: ", new Object[]{servConn.getName(), e});
            }
            functionResponseMsg.setServerConnection(servConn);
            functionResponseMsg.setLastChunkAndNumParts(true, numParts);
            functionResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setMessageType(messageType2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
                chunkedResponseMsg.setNumberOfParts(3);
                chunkedResponseMsg.addObjPart(e);
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
                chunkedResponseMsg.addObjPart(fe.getFailedNodeSet());
                numParts = 3;
            } else {
                chunkedResponseMsg.setNumberOfParts(2);
                chunkedResponseMsg.addObjPart(e);
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                numParts = 2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: ", new Object[]{servConn.getName(), e});
            }
            chunkedResponseMsg.setServerConnection(servConn);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numParts);
            chunkedResponseMsg.sendChunk(servConn);
        }
    }
}

