/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class CloseConnection
extends BaseCommand {
    private static final CloseConnection singleton = new CloseConnection();

    public static Command getCommand() {
        return singleton;
    }

    private CloseConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CacheServerStats stats = servConn.getCacheServerStats();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadCloseConnectionRequestTime(start - oldStart);
        try {
            Part keepalivePart;
            byte[] keepaliveByte;
            servConn.setClientDisconnectCleanly();
            String clientHost = servConn.getSocketHost();
            int clientPort = servConn.getSocketPort();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received close request ({} bytes) from {}:{}", new Object[]{servConn.getName(), msg.getPayloadLength(), clientHost, clientPort});
            }
            boolean keepalive = (keepaliveByte = (keepalivePart = msg.getPart(0)).getSerializedForm()) != null && keepaliveByte[0] != 0;
            servConn.getAcceptor().getCacheClientNotifier().setKeepAlive(servConn.getProxyID(), keepalive);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Processed close request from {}:{}, keepAlive: {}", new Object[]{servConn.getName(), clientHost, clientPort, keepalive});
            }
        }
        finally {
            servConn.setFlagProcessMessagesAsFalse();
            stats.incProcessCloseConnectionTime(DistributionStats.getStatTime() - start);
        }
    }
}

