/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.Releasable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class ObjectPartList
implements DataSerializableFixedID,
Releasable {
    private static final Logger logger = LogService.getLogger();
    protected static final byte BYTES = 0;
    protected static final byte OBJECT = 1;
    protected static final byte EXCEPTION = 2;
    protected static final byte KEY_NOT_AT_SERVER = 3;
    protected byte[] objectTypeArray;
    protected boolean hasKeys;
    protected List keys;
    protected List objects;

    public void addPart(Object key, Object value, byte objectType, VersionTag versionTag) {
        int maxSize;
        int size = this.objects.size();
        if (size >= (maxSize = this.objectTypeArray.length)) {
            throw new IndexOutOfBoundsException("Cannot add object part beyond " + maxSize + " elements");
        }
        if (this.hasKeys) {
            if (key == null) {
                throw new IllegalArgumentException("Cannot add null key");
            }
            this.keys.add(key);
        }
        this.objectTypeArray[size] = objectType;
        this.objects.add(value);
    }

    public ObjectPartList() {
        this.objectTypeArray = null;
        this.hasKeys = false;
        this.keys = null;
        this.objects = new ArrayList();
    }

    public ObjectPartList(int maxSize, boolean hasKeys) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Invalid size " + maxSize + " to ObjectPartList constructor");
        }
        this.objectTypeArray = new byte[maxSize];
        this.hasKeys = hasKeys;
        this.keys = hasKeys ? new ArrayList() : null;
        this.objects = new ArrayList();
    }

    public void addObjectPart(Object key, Object value, boolean isObject, VersionTag versionTag) {
        this.addPart(key, value, isObject ? (byte)1 : 0, versionTag);
    }

    public void addExceptionPart(Object key, Exception ex) {
        this.addPart(key, ex, (byte)2, null);
    }

    public void addObjectPartForAbsentKey(Object key, Object value) {
        throw new IllegalAccessError("inappropriate use of ObjectPartList");
    }

    public void addAll(ObjectPartList other) {
        if (logger.isTraceEnabled(LogMarker.OBJECT_PART_LIST)) {
            logger.trace(LogMarker.OBJECT_PART_LIST, "OPL.addAll: other={}\nthis={}", new Object[]{other, this});
        }
        if (this.hasKeys) {
            if (other.keys != null) {
                if (this.keys == null) {
                    this.keys = new ArrayList(other.keys);
                } else {
                    this.keys.addAll(other.keys);
                }
            }
        } else if (other.hasKeys) {
            this.hasKeys = true;
            this.keys = new ArrayList(other.keys);
        }
        this.objects.addAll(other.objects);
    }

    public List getKeys() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.keys);
    }

    public List getKeysForTest() {
        return this.keys;
    }

    public List getObjects() {
        if (this.objects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.objects);
    }

    public List getObjectsForTest() {
        return this.objects;
    }

    public int size() {
        if (this.hasKeys) {
            return this.keys.size();
        }
        return this.objects.size();
    }

    public void reinit(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Invalid size " + maxSize + " to ObjectPartList.reinit");
        }
        this.objectTypeArray = new byte[maxSize];
        this.objects.clear();
        this.keys.clear();
    }

    public void clear() {
        this.release();
        this.objects.clear();
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.hasKeys);
        if (this.objectTypeArray != null) {
            int numObjects = this.objects.size();
            out.writeInt(numObjects);
            for (int index = 0; index < numObjects; ++index) {
                Object value = this.objects.get(index);
                byte objectType = this.objectTypeArray[index];
                if (this.hasKeys) {
                    DataSerializer.writeObject(this.keys.get(index), out);
                }
                out.writeBoolean(objectType == 2);
                if (objectType == 1 && value instanceof byte[]) {
                    out.write((byte[])value);
                    continue;
                }
                if (objectType == 2) {
                    DataSerializer.writeByteArray(CacheServerHelper.serialize(value), out);
                    DataSerializer.writeString(value.toString(), out);
                    continue;
                }
                DataSerializer.writeObject(value, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int numObjects;
        this.hasKeys = in.readBoolean();
        if (this.hasKeys) {
            this.keys = new ArrayList();
        }
        if ((numObjects = in.readInt()) > 0) {
            for (int index = 0; index < numObjects; ++index) {
                Object value;
                boolean isException;
                if (this.hasKeys) {
                    Object key = DataSerializer.readObject(in);
                    this.keys.add(key);
                }
                if (isException = in.readBoolean()) {
                    byte[] exBytes = DataSerializer.readByteArray(in);
                    value = CacheServerHelper.deserialize(exBytes);
                    DataSerializer.readString(in);
                } else {
                    value = DataSerializer.readObject(in);
                }
                this.objects.add(value);
            }
        }
    }

    @Override
    public int getDSFID() {
        return 25;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void release() {
        for (Object v : this.objects) {
            OffHeapHelper.release(v);
        }
    }
}

