/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.SocketUtils;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.MessageStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.MessageTooLargeException;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class Message {
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x40000000;
    public static int MAX_MESSAGE_SIZE = Integer.getInteger("gemfire.client.max-message-size", 0x40000000);
    private static final Logger logger = LogService.getLogger();
    private static final int PART_HEADER_SIZE = 5;
    private static final int FIXED_LENGTH = 17;
    private static final ThreadLocal<ByteBuffer> tlCommBuffer = new ThreadLocal();
    protected int msgType;
    protected int payloadLength = 0;
    protected int numberOfParts = 0;
    protected int transactionId = -1;
    protected int currentPart = 0;
    protected Part[] partsList = null;
    protected ByteBuffer cachedCommBuffer;
    protected Socket socket = null;
    protected SocketChannel sockCh = null;
    protected OutputStream os = null;
    protected InputStream is = null;
    protected boolean messageModified = true;
    protected boolean isRetry;
    private byte flags = 0;
    protected MessageStats msgStats = null;
    protected ServerConnection sc = null;
    private int maxIncomingMessageLength = -1;
    private Semaphore dataLimiter = null;
    private Semaphore msgLimiter = null;
    private boolean hdrRead = false;
    private int chunkSize = 1024;
    protected Part securePart = null;
    private boolean isMetaRegion = false;
    public static final byte MESSAGE_HAS_SECURE_PART = 2;
    public static final byte MESSAGE_IS_RETRY = 4;
    public static final byte MESSAGE_IS_RETRY_MASK = -5;
    public static final ThreadLocal<Integer> messageType = new ThreadLocal();
    Version version;

    public Message(int numberOfParts, Version destVersion) {
        this.version = destVersion;
        Assert.assertTrue(destVersion != null, "Attempt to create an unversioned message");
        this.partsList = new Part[numberOfParts];
        this.numberOfParts = numberOfParts;
        for (int i = 0; i < this.partsList.length; ++i) {
            this.partsList[i] = new Part();
        }
    }

    public boolean isSecureMode() {
        return this.securePart != null;
    }

    public byte[] getSecureBytes() throws IOException, ClassNotFoundException {
        return (byte[])this.securePart.getObject();
    }

    public void setMessageType(int msgType) {
        this.messageModified = true;
        if (!MessageType.validate(msgType)) {
            throw new IllegalArgumentException(LocalizedStrings.Message_INVALID_MESSAGETYPE.toLocalizedString());
        }
        this.msgType = msgType;
    }

    public void setVersion(Version clientVersion) {
        this.version = clientVersion;
    }

    public void setMessageHasSecurePartFlag() {
        this.flags = (byte)(this.flags | 2);
    }

    public void clearMessageHasSecurePartFlag() {
        this.flags = (byte)(this.flags & 2);
    }

    public void setNumberOfParts(int numberOfParts) {
        this.messageModified = true;
        this.currentPart = 0;
        this.numberOfParts = numberOfParts;
        if (numberOfParts > this.partsList.length) {
            Part[] newPartsList = new Part[numberOfParts];
            for (int i = 0; i < numberOfParts; ++i) {
                newPartsList[i] = i < this.partsList.length ? this.partsList[i] : new Part();
            }
            this.partsList = newPartsList;
        }
    }

    void setParts(Part[] parts) {
        this.partsList = parts;
    }

    public void setTransactionId(int transactionId) {
        this.messageModified = true;
        this.transactionId = transactionId;
    }

    public void setIsRetry() {
        this.isRetry = true;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getNextPartNumber() {
        return this.currentPart;
    }

    public void addStringPart(String str) {
        if (str == null) {
            this.addRawPart(null, false);
        } else {
            HeapDataOutputStream hdos = new HeapDataOutputStream(str);
            this.messageModified = true;
            Part part = this.partsList[this.currentPart];
            part.setPartState(hdos, false);
            ++this.currentPart;
        }
    }

    public void addBytesPart(byte[] newPart) {
        this.addRawPart(newPart, false);
    }

    public void addStringOrObjPart(Object o) {
        if (o instanceof String || o == null) {
            this.addStringPart((String)o);
        } else {
            this.serializeAndAddPart(o, false);
        }
    }

    public void addDeltaPart(HeapDataOutputStream hdos) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(hdos, false);
        ++this.currentPart;
    }

    public void addObjPart(Object o) {
        this.addObjPart(o, false);
    }

    public void addObjPartNoCopying(Object o) {
        if (o == null || o instanceof byte[]) {
            this.addRawPart((byte[])o, false);
        } else {
            this.serializeAndAddPartNoCopying(o);
        }
    }

    public void addObjPart(Object o, boolean zipValues) {
        if (o == null || o instanceof byte[]) {
            this.addRawPart((byte[])o, false);
        } else {
            this.serializeAndAddPart(o, zipValues);
        }
    }

    public void addPartInAnyForm(Object o, boolean isObject) {
        if (o == null) {
            this.addRawPart((byte[])o, false);
        } else if (o instanceof byte[]) {
            this.addRawPart((byte[])o, isObject);
        } else if (o instanceof StoredObject) {
            this.messageModified = true;
            Part part = this.partsList[this.currentPart];
            part.setPartState((StoredObject)o, isObject);
            ++this.currentPart;
        } else {
            this.serializeAndAddPart(o, false);
        }
    }

    private void serializeAndAddPartNoCopying(Object o) {
        Version v = this.version;
        if (this.version.equals(Version.CURRENT)) {
            v = null;
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(this.chunkSize, v, true);
        try {
            BlobHelper.serializeTo(o, hdos);
        }
        catch (IOException ex) {
            throw new SerializationException("failed serializing object", ex);
        }
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(hdos, true);
        ++this.currentPart;
    }

    private void serializeAndAddPart(Object o, boolean zipValues) {
        if (zipValues) {
            throw new UnsupportedOperationException("zipValues no longer supported");
        }
        Version v = this.version;
        if (this.version.equals(Version.CURRENT)) {
            v = null;
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(this.chunkSize, v);
        try {
            BlobHelper.serializeTo(o, hdos);
        }
        catch (IOException ex) {
            throw new SerializationException("failed serializing object", ex);
        }
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(hdos, true);
        ++this.currentPart;
    }

    public void addIntPart(int v) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setInt(v);
        ++this.currentPart;
    }

    public void addLongPart(long v) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setLong(v);
        ++this.currentPart;
    }

    public void addRawPart(byte[] newPart, boolean isObject) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(newPart, isObject);
        ++this.currentPart;
    }

    public int getMessageType() {
        return this.msgType;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public int getHeaderLength() {
        return 17;
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public Part getPart(int index) {
        if (index < this.numberOfParts) {
            Part p = this.partsList[index];
            if (this.version != null) {
                p.setVersion(this.version);
            }
            return p;
        }
        return null;
    }

    public static ByteBuffer setTLCommBuffer(ByteBuffer bb) {
        ByteBuffer result = tlCommBuffer.get();
        tlCommBuffer.set(bb);
        return result;
    }

    public ByteBuffer getCommBuffer() {
        if (this.cachedCommBuffer != null) {
            return this.cachedCommBuffer;
        }
        return tlCommBuffer.get();
    }

    public void clear() {
        ByteBuffer buffer;
        this.isRetry = false;
        int len = this.payloadLength;
        if (len != 0) {
            this.payloadLength = 0;
        }
        if (this.hdrRead && this.msgStats != null) {
            this.msgStats.decMessagesBeingReceived(len);
        }
        if ((buffer = this.getCommBuffer()) != null) {
            buffer.clear();
        }
        this.clearParts();
        if (len != 0 && this.dataLimiter != null) {
            this.dataLimiter.release(len);
            this.dataLimiter = null;
            this.maxIncomingMessageLength = 0;
        }
        if (this.hdrRead) {
            if (this.msgLimiter != null) {
                this.msgLimiter.release(1);
                this.msgLimiter = null;
            }
            this.hdrRead = false;
        }
        this.flags = 0;
    }

    protected void packHeaderInfoForSending(int msgLen, boolean isSecurityHeader) {
        byte flagsByte = this.flags;
        if (isSecurityHeader) {
            flagsByte = (byte)(flagsByte | 2);
        }
        if (this.isRetry) {
            flagsByte = (byte)(flagsByte | 4);
        }
        this.getCommBuffer().putInt(this.msgType).putInt(msgLen).putInt(this.numberOfParts).putInt(this.transactionId).put(flagsByte);
    }

    protected Part getSecurityPart() {
        if (this.sc != null) {
            return this.sc.updateAndGetSecurityPart();
        }
        return null;
    }

    public void setSecurePart(byte[] bytes) {
        this.securePart = new Part();
        this.securePart.setPartState(bytes, false);
    }

    public void setMetaRegion(boolean isMetaRegion) {
        this.isMetaRegion = isMetaRegion;
    }

    public boolean getAndResetIsMetaRegion() {
        boolean isMetaRegion = this.isMetaRegion;
        this.isMetaRegion = false;
        return isMetaRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendBytes(boolean clearMessage) throws IOException {
        if (this.sc != null) {
            this.sc.updateProcessingMessage();
        }
        if (this.socket != null) {
            ByteBuffer cb = this.getCommBuffer();
            if (cb == null) {
                throw new IOException("No buffer");
            }
            int msgLen = 0;
            ByteBuffer byteBuffer = cb;
            synchronized (byteBuffer) {
                long totalPartLen = 0L;
                long headerLen = 0L;
                int partsToTransmit = this.numberOfParts;
                for (int i = 0; i < this.numberOfParts; ++i) {
                    Part part = this.partsList[i];
                    headerLen += 5L;
                    totalPartLen += (long)part.getLength();
                }
                Part securityPart = this.getSecurityPart();
                if (securityPart == null) {
                    securityPart = this.securePart;
                }
                if (securityPart != null) {
                    headerLen += 5L;
                    totalPartLen += (long)securityPart.getLength();
                    ++partsToTransmit;
                }
                if (headerLen + totalPartLen > Integer.MAX_VALUE) {
                    throw new MessageTooLargeException("Message size (" + (headerLen + totalPartLen) + ") exceeds maximum integer value");
                }
                msgLen = (int)(headerLen + totalPartLen);
                if (msgLen > MAX_MESSAGE_SIZE) {
                    throw new MessageTooLargeException("Message size (" + msgLen + ") exceeds gemfire.client.max-message-size setting (" + MAX_MESSAGE_SIZE + ")");
                }
                cb.clear();
                this.packHeaderInfoForSending(msgLen, securityPart != null);
                for (int i = 0; i < partsToTransmit; ++i) {
                    Part part;
                    Part part2 = part = i == this.numberOfParts ? securityPart : this.partsList[i];
                    if (cb.remaining() < 5) {
                        this.flushBuffer();
                    }
                    int partLen = part.getLength();
                    cb.putInt(partLen);
                    cb.put(part.getTypeCode());
                    if (partLen <= cb.remaining()) {
                        part.writeTo(cb);
                        continue;
                    }
                    this.flushBuffer();
                    if (this.sockCh != null) {
                        part.writeTo(this.sockCh, cb);
                    } else {
                        part.writeTo(this.os, cb);
                    }
                    if (this.msgStats == null) continue;
                    this.msgStats.incSentBytes(partLen);
                }
                if (cb.position() != 0) {
                    this.flushBuffer();
                }
                this.messageModified = false;
                if (this.sockCh == null) {
                    this.os.flush();
                }
            }
            if (clearMessage) {
                this.clearParts();
            }
        } else {
            throw new IOException(LocalizedStrings.Message_DEAD_CONNECTION.toLocalizedString());
        }
    }

    protected void flushBuffer() throws IOException {
        ByteBuffer cb = this.getCommBuffer();
        if (this.sockCh != null) {
            cb.flip();
            do {
                this.sockCh.write(cb);
            } while (cb.remaining() > 0);
        } else {
            this.os.write(cb.array(), 0, cb.position());
        }
        if (this.msgStats != null) {
            this.msgStats.incSentBytes(cb.position());
        }
        cb.clear();
    }

    private void read() throws IOException {
        this.clearParts();
        this.readHeaderAndPayload();
    }

    protected final void fetchHeader() throws IOException {
        ByteBuffer cb = this.getCommBuffer();
        cb.clear();
        this.msgType = -1;
        int hdr = 0;
        int headerLength = this.getHeaderLength();
        if (this.sockCh != null) {
            cb.limit(headerLength);
            do {
                int bytesRead;
                if ((bytesRead = this.sockCh.read(cb)) == -1) {
                    throw new EOFException(LocalizedStrings.Message_THE_CONNECTION_HAS_BEEN_RESET_WHILE_READING_THE_HEADER.toLocalizedString());
                }
                if (this.msgStats == null) continue;
                this.msgStats.incReceivedBytes(bytesRead);
            } while (cb.remaining() > 0);
            cb.flip();
        } else {
            do {
                int bytesRead = -1;
                bytesRead = this.is.read(cb.array(), hdr, headerLength - hdr);
                if (bytesRead == -1) {
                    throw new EOFException(LocalizedStrings.Message_THE_CONNECTION_HAS_BEEN_RESET_WHILE_READING_THE_HEADER.toLocalizedString());
                }
                hdr += bytesRead;
                if (this.msgStats == null) continue;
                this.msgStats.incReceivedBytes(bytesRead);
            } while (hdr < headerLength);
            cb.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaderAndPayload() throws IOException {
        boolean interrupted;
        this.fetchHeader();
        ByteBuffer cb = this.getCommBuffer();
        int type = cb.getInt();
        int len = cb.getInt();
        int numParts = cb.getInt();
        int txid = cb.getInt();
        byte bits = cb.get();
        cb.clear();
        if (!MessageType.validate(type)) {
            throw new IOException(LocalizedStrings.Message_INVALID_MESSAGE_TYPE_0_WHILE_READING_HEADER.toLocalizedString(type));
        }
        int timeToWait = 0;
        if (this.sc != null) {
            this.sc.setProcessingMessage();
            timeToWait = this.sc.getClientReadTimeout();
        }
        this.hdrRead = true;
        if (this.msgLimiter != null) {
            while (true) {
                this.sc.getCachedRegionHelper().checkCancelInProgress(null);
                interrupted = Thread.interrupted();
                try {
                    if (timeToWait == 0) {
                        this.msgLimiter.acquire(1);
                    } else if (!this.msgLimiter.tryAcquire(1, timeToWait, TimeUnit.MILLISECONDS)) {
                        if (this.msgStats != null && this.msgStats instanceof CacheServerStats) {
                            ((CacheServerStats)this.msgStats).incConnectionsTimedOut();
                        }
                        throw new IOException(LocalizedStrings.Message_OPERATION_TIMED_OUT_ON_SERVER_WAITING_ON_CONCURRENT_MESSAGE_LIMITER_AFTER_WAITING_0_MILLISECONDS.toLocalizedString(timeToWait));
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
        if (len > 0) {
            if (this.maxIncomingMessageLength > 0 && len > this.maxIncomingMessageLength) {
                throw new IOException(LocalizedStrings.Message_MESSAGE_SIZE_0_EXCEEDED_MAX_LIMIT_OF_1.toLocalizedString(len, this.maxIncomingMessageLength));
            }
            if (this.dataLimiter != null) {
                while (true) {
                    if (this.sc != null) {
                        this.sc.getCachedRegionHelper().checkCancelInProgress(null);
                    }
                    interrupted = Thread.interrupted();
                    try {
                        if (timeToWait == 0) {
                            this.dataLimiter.acquire(len);
                        } else {
                            int newTimeToWait = timeToWait;
                            if (this.msgLimiter != null) {
                                newTimeToWait -= (int)this.sc.getCurrentMessageProcessingTime();
                            }
                            if (newTimeToWait <= 0 || !this.msgLimiter.tryAcquire(1, newTimeToWait, TimeUnit.MILLISECONDS)) {
                                throw new IOException(LocalizedStrings.Message_OPERATION_TIMED_OUT_ON_SERVER_WAITING_ON_CONCURRENT_DATA_LIMITER_AFTER_WAITING_0_MILLISECONDS.toLocalizedString(timeToWait));
                            }
                        }
                        this.payloadLength = len;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.msgStats != null) {
            this.msgStats.incMessagesBeingReceived(len);
            this.payloadLength = len;
        }
        this.isRetry = (bits & 4) != 0;
        this.flags = bits = (byte)(bits & 0xFFFFFFFB);
        this.msgType = type;
        this.readPayloadFields(numParts, len);
        this.msgType = type;
        this.payloadLength = len;
        this.transactionId = txid;
        this.flags = bits;
        if (this.sc != null) {
            this.sc.updateProcessingMessage();
        }
    }

    protected void readPayloadFields(int numParts, int len) throws IOException {
        if (len > 0 && numParts <= 0 || len <= 0 && numParts > 0) {
            throw new IOException(LocalizedStrings.Message_PART_LENGTH_0_AND_NUMBER_OF_PARTS_1_INCONSISTENT.toLocalizedString(len, numParts));
        }
        Integer msgType = messageType.get();
        if (msgType != null && msgType == 5) {
            messageType.set(null);
            int pingParts = 10;
            if (numParts > pingParts) {
                throw new IOException("Part length ( " + numParts + " ) is  inconsistent for " + MessageType.getString(msgType) + " operation.");
            }
        }
        this.setNumberOfParts(numParts);
        if (numParts <= 0) {
            return;
        }
        if (len < 0) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Message_RPL_NEG_LEN__0, len));
            throw new IOException(LocalizedStrings.Message_DEAD_CONNECTION.toLocalizedString());
        }
        ByteBuffer cb = this.getCommBuffer();
        cb.clear();
        cb.flip();
        int readSecurePart = 0;
        readSecurePart = this.checkAndSetSecurityPart();
        int bytesRemaining = len;
        for (int i = 0; i < numParts + readSecurePart || readSecurePart == 1 && cb.remaining() > 0; ++i) {
            int bytesReadThisTime = this.readPartChunk(bytesRemaining);
            bytesRemaining -= bytesReadThisTime;
            Part part = i < numParts ? this.partsList[i] : this.securePart;
            int partLen = cb.getInt();
            byte partType = cb.get();
            byte[] partBytes = null;
            if (partLen > 0) {
                partBytes = new byte[partLen];
                int alreadyReadBytes = cb.remaining();
                if (alreadyReadBytes > 0) {
                    if (partLen < alreadyReadBytes) {
                        alreadyReadBytes = partLen;
                    }
                    cb.get(partBytes, 0, alreadyReadBytes);
                }
                int off = alreadyReadBytes;
                int remaining = partLen - off;
                while (remaining > 0) {
                    if (this.sockCh != null) {
                        int bytesThisTime = remaining;
                        cb.clear();
                        if (bytesThisTime > cb.capacity()) {
                            bytesThisTime = cb.capacity();
                        }
                        cb.limit(bytesThisTime);
                        int res = this.sockCh.read(cb);
                        if (res != -1) {
                            cb.flip();
                            bytesRemaining -= res;
                            remaining -= res;
                            cb.get(partBytes, off, res);
                            off += res;
                            if (this.msgStats == null) continue;
                            this.msgStats.incReceivedBytes(res);
                            continue;
                        }
                        throw new EOFException(LocalizedStrings.Message_THE_CONNECTION_HAS_BEEN_RESET_WHILE_READING_A_PART.toLocalizedString());
                    }
                    int res = 0;
                    res = this.is.read(partBytes, off, remaining);
                    if (res != -1) {
                        bytesRemaining -= res;
                        remaining -= res;
                        off += res;
                        if (this.msgStats == null) continue;
                        this.msgStats.incReceivedBytes(res);
                        continue;
                    }
                    throw new EOFException(LocalizedStrings.Message_THE_CONNECTION_HAS_BEEN_RESET_WHILE_READING_A_PART.toLocalizedString());
                }
            }
            part.init(partBytes, partType);
        }
    }

    protected int checkAndSetSecurityPart() {
        if ((this.flags | 2) == this.flags) {
            this.securePart = new Part();
            return 1;
        }
        this.securePart = null;
        return 0;
    }

    private int readPartChunk(int bytesRemaining) throws IOException {
        ByteBuffer cb = this.getCommBuffer();
        if (cb.remaining() >= 5) {
            return 0;
        }
        if (cb.position() != 0) {
            cb.compact();
        } else {
            cb.position(cb.limit());
            cb.limit(cb.capacity());
        }
        int bytesRead = 0;
        if (this.sc != null) {
            this.sc.updateProcessingMessage();
        }
        if (this.sockCh != null) {
            int remaining = cb.remaining();
            if (remaining > bytesRemaining) {
                remaining = bytesRemaining;
                cb.limit(cb.position() + bytesRemaining);
            }
            while (remaining > 0) {
                int res = this.sockCh.read(cb);
                if (res != -1) {
                    remaining -= res;
                    bytesRead += res;
                    if (this.msgStats == null) continue;
                    this.msgStats.incReceivedBytes(res);
                    continue;
                }
                throw new EOFException(LocalizedStrings.Message_THE_CONNECTION_HAS_BEEN_RESET_WHILE_READING_THE_PAYLOAD.toLocalizedString());
            }
        } else {
            int bufSpace = cb.capacity() - cb.position();
            int bytesToRead = bufSpace;
            if (bytesRemaining < bytesToRead) {
                bytesToRead = bytesRemaining;
            }
            int pos = cb.position();
            while (bytesToRead > 0) {
                int res = 0;
                res = this.is.read(cb.array(), pos, bytesToRead);
                if (res != -1) {
                    bytesToRead -= res;
                    pos += res;
                    bytesRead += res;
                    if (this.msgStats == null) continue;
                    this.msgStats.incReceivedBytes(res);
                    continue;
                }
                throw new EOFException(LocalizedStrings.Message_THE_CONNECTION_HAS_BEEN_RESET_WHILE_READING_THE_PAYLOAD.toLocalizedString());
            }
            cb.position(pos);
        }
        cb.flip();
        return bytesRead;
    }

    public void clearParts() {
        for (int i = 0; i < this.partsList.length; ++i) {
            this.partsList[i].clear();
        }
        this.currentPart = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("type=").append(MessageType.getString(this.msgType));
        sb.append("; payloadLength=").append(this.payloadLength);
        sb.append("; numberOfParts=").append(this.numberOfParts);
        sb.append("; transactionId=").append(this.transactionId);
        sb.append("; currentPart=").append(this.currentPart);
        sb.append("; messageModified=").append(this.messageModified);
        sb.append("; flags=").append(Integer.toHexString(this.flags));
        for (int i = 0; i < this.numberOfParts; ++i) {
            sb.append("; part[").append(i).append("]={");
            sb.append(this.partsList[i].toString());
            sb.append("}");
        }
        return sb.toString();
    }

    public void setComms(ServerConnection sc, Socket socket, ByteBuffer bb, MessageStats msgStats) throws IOException {
        this.sc = sc;
        this.setComms(socket, bb, msgStats);
    }

    public void setComms(Socket socket, ByteBuffer bb, MessageStats msgStats) throws IOException {
        this.sockCh = socket.getChannel();
        if (this.sockCh == null) {
            this.setComms(socket, SocketUtils.getInputStream(socket), SocketUtils.getOutputStream(socket), bb, msgStats);
        } else {
            this.setComms(socket, null, null, bb, msgStats);
        }
    }

    public void setComms(Socket socket, InputStream is, OutputStream os, ByteBuffer bb, MessageStats msgStats) throws IOException {
        Assert.assertTrue(socket != null);
        this.socket = socket;
        this.sockCh = socket.getChannel();
        this.is = is;
        this.os = os;
        this.cachedCommBuffer = bb;
        this.msgStats = msgStats;
    }

    public void unsetComms() {
        this.socket = null;
        this.sockCh = null;
        this.is = null;
        this.os = null;
        this.cachedCommBuffer = null;
        this.msgStats = null;
    }

    public void send() throws IOException {
        this.send(true);
    }

    public void send(ServerConnection servConn) throws IOException {
        if (this.sc != servConn) {
            throw new IllegalStateException("this.sc was not correctly set");
        }
        this.send(true);
    }

    public void send(boolean clearMessage) throws IOException {
        this.sendBytes(clearMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recv() throws IOException {
        if (this.socket != null) {
            ByteBuffer byteBuffer = this.getCommBuffer();
            synchronized (byteBuffer) {
                this.read();
            }
        } else {
            throw new IOException(LocalizedStrings.Message_DEAD_CONNECTION.toLocalizedString());
        }
    }

    public void recv(ServerConnection sc, int maxMessageLength, Semaphore dataLimiter, Semaphore msgLimiter) throws IOException {
        this.sc = sc;
        this.maxIncomingMessageLength = maxMessageLength;
        this.dataLimiter = dataLimiter;
        this.msgLimiter = msgLimiter;
        this.recv();
    }
}

