/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.query.internal.cq.InternalCqQuery;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Sendable;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public class ClientUpdateMessageImpl
implements ClientUpdateMessage,
Sizeable,
EntryEventImpl.NewValueImporter {
    private static final long serialVersionUID = 7037106666445312400L;
    private static final Logger logger = LogService.getLogger();
    protected EnumListenerEvent _operation;
    private String _regionName;
    private Object _keyOfInterest;
    private Object _value;
    protected byte _valueIsObject;
    protected Object _callbackArgument;
    protected ClientProxyMembershipID _membershipId;
    protected EventID _eventIdentifier;
    private boolean _shouldConflate = false;
    private volatile boolean _isInterestListPassed;
    private volatile boolean _hasCqs = false;
    private ClientCqConcurrentMap _clientCqs = null;
    private volatile Set<ClientProxyMembershipID> _clientInterestList;
    private volatile Set<ClientProxyMembershipID> _clientInterestListInv;
    private transient boolean _isNetLoad = false;
    private byte[] deltaBytes = null;
    private VersionTag versionTag;
    private static final int CONSTANT_MEMORY_OVERHEAD;

    public ClientUpdateMessageImpl(EnumListenerEvent operation, LocalRegion region, Object keyOfInterest, Object value, byte valueIsObject, Object callbackArgument, ClientProxyMembershipID memberId, EventID eventIdentifier) {
        this(operation, region, keyOfInterest, value, null, valueIsObject, callbackArgument, memberId, eventIdentifier, null);
    }

    public ClientUpdateMessageImpl(EnumListenerEvent operation, LocalRegion region, Object keyOfInterest, Object value, byte[] delta, byte valueIsObject, Object callbackArgument, ClientProxyMembershipID memberId, EventID eventIdentifier, VersionTag versionTag) {
        this._operation = operation;
        this._regionName = region.getFullPath();
        this._keyOfInterest = keyOfInterest;
        this._value = value;
        this._valueIsObject = valueIsObject;
        this._callbackArgument = callbackArgument;
        this._membershipId = memberId;
        this._eventIdentifier = eventIdentifier;
        this._shouldConflate = this.isUpdate() && region.getEnableConflation();
        this.deltaBytes = delta;
        this.versionTag = versionTag;
    }

    protected ClientUpdateMessageImpl(EnumListenerEvent operation, ClientProxyMembershipID memberId, EventID eventIdentifier) {
        this._operation = operation;
        this._membershipId = memberId;
        this._eventIdentifier = eventIdentifier;
    }

    public ClientUpdateMessageImpl() {
    }

    @Override
    public String getRegionName() {
        return this._regionName;
    }

    @Override
    public Object getKeyOfInterest() {
        return this._keyOfInterest;
    }

    @Override
    public EnumListenerEvent getOperation() {
        return this._operation;
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public boolean valueIsObject() {
        return this._valueIsObject == 1;
    }

    public Object getCallbackArgument() {
        return this._callbackArgument;
    }

    @Override
    public boolean shouldBeConflated() {
        return this._shouldConflate;
    }

    @Override
    public String getRegionToConflate() {
        return this._regionName;
    }

    @Override
    public Object getKeyToConflate() {
        return this._keyOfInterest;
    }

    @Override
    public Object getValueToConflate() {
        return this._value;
    }

    @Override
    public void setLatestValue(Object value) {
        this._value = value;
    }

    @Override
    public ClientProxyMembershipID getMembershipId() {
        return this._membershipId;
    }

    @Override
    public EventID getEventId() {
        return this._eventIdentifier;
    }

    @Override
    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    @Override
    public boolean isCreate() {
        return this._operation == EnumListenerEvent.AFTER_CREATE;
    }

    @Override
    public boolean isUpdate() {
        return this._operation == EnumListenerEvent.AFTER_UPDATE;
    }

    @Override
    public boolean isDestroy() {
        return this._operation == EnumListenerEvent.AFTER_DESTROY;
    }

    @Override
    public boolean isInvalidate() {
        return this._operation == EnumListenerEvent.AFTER_INVALIDATE;
    }

    @Override
    public boolean isDestroyRegion() {
        return this._operation == EnumListenerEvent.AFTER_REGION_DESTROY;
    }

    @Override
    public boolean isClearRegion() {
        return this._operation == EnumListenerEvent.AFTER_REGION_CLEAR;
    }

    public boolean isInvalidateRegion() {
        return this._operation == EnumListenerEvent.AFTER_REGION_INVALIDATE;
    }

    public boolean isClientCompatible() {
        return false;
    }

    @Override
    public Message getMessage(CacheClientProxy proxy, boolean notify) throws IOException {
        throw new Error("ClientUpdateMessage.getMessage(proxy) should not be invoked");
    }

    protected Message getMessage(CacheClientProxy proxy, byte[] latestValue) throws IOException {
        Version clientVersion = proxy.getVersion();
        byte[] serializedValue = null;
        Message message = null;
        boolean conflation = false;
        boolean bl = conflation = proxy.clientConflation == 1 || proxy.clientConflation == 0 && this.shouldBeConflated();
        if (latestValue != null) {
            serializedValue = latestValue;
        } else if (this.deltaBytes == null || this.isCreate()) {
            serializedValue = CacheServerHelper.serialize(latestValue);
            this._value = serializedValue;
        }
        if (clientVersion.compareTo(Version.GFE_70) >= 0) {
            message = this.getGFE70Message(proxy, serializedValue, conflation, clientVersion);
        } else if (clientVersion.compareTo(Version.GFE_65) >= 0) {
            message = this.getGFE65Message(proxy, serializedValue, conflation, clientVersion);
        } else if (clientVersion.compareTo(Version.GFE_61) >= 0) {
            message = this.getGFE61Message(proxy, serializedValue, conflation, clientVersion);
        } else if (clientVersion.compareTo(Version.GFE_57) >= 0) {
            message = this.getGFEMessage(proxy.getProxyID(), latestValue, clientVersion);
        } else {
            throw new IOException("Unsupported client version for server-to-client message creation: " + clientVersion);
        }
        return message;
    }

    protected Message getGFEMessage(ClientProxyMembershipID proxyId, byte[] latestValue, Version clientVersion) throws IOException {
        boolean clientHasCq;
        Message message = null;
        int cqMsgParts = 0;
        boolean bl = clientHasCq = this._hasCqs && this.getCqs(proxyId) != null;
        if (clientHasCq) {
            cqMsgParts = this.getCqs(proxyId).length * 2 + 1;
        }
        if (this.isCreate() || this.isUpdate()) {
            if (this._clientInterestListInv != null && this._clientInterestListInv.contains(proxyId)) {
                message = new Message(6, clientVersion);
                message.setMessageType(15);
                message.addStringPart(this._regionName);
                message.addStringOrObjPart(this._keyOfInterest);
                message.addObjPart(this._callbackArgument);
                message.addObjPart(this.isClientInterested(proxyId));
                message.addObjPart(Boolean.FALSE);
            } else {
                message = new Message(7 + cqMsgParts, clientVersion);
                if (this.isCreate()) {
                    message.setMessageType(27);
                } else {
                    message.setMessageType(28);
                }
                message.addStringPart(this._regionName);
                message.addStringOrObjPart(this._keyOfInterest);
                message.addRawPart(latestValue, this._valueIsObject == 1);
                message.addObjPart(this._callbackArgument);
                message.addObjPart(this.isClientInterested(proxyId));
                message.addObjPart(clientHasCq);
                if (clientHasCq) {
                    this.addCqsToMessage(proxyId, message);
                }
            }
        } else if (this.isDestroy() || this.isInvalidate()) {
            message = new Message(6 + cqMsgParts, clientVersion);
            if (this.isDestroy()) {
                message.setMessageType(16);
            } else {
                message.setMessageType(15);
            }
            message.addStringPart(this._regionName);
            message.addStringOrObjPart(this._keyOfInterest);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(this.isClientInterested(proxyId));
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isDestroyRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(17);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isClearRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(36);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isInvalidateRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(55);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else {
            throw new InternalGemFireError("Don't know what kind of message");
        }
        message.setTransactionId(0);
        message.addObjPart(this._eventIdentifier);
        return message;
    }

    protected Message getGFE61Message(CacheClientProxy proxy, byte[] latestValue, boolean conflation, Version clientVersion) throws IOException {
        boolean clientHasCq;
        Message message = null;
        ClientProxyMembershipID proxyId = proxy.getProxyID();
        int cqMsgParts = 0;
        boolean bl = clientHasCq = this._hasCqs && this.getCqs(proxyId) != null;
        if (clientHasCq) {
            cqMsgParts = this.getCqs(proxyId).length * 2 + 1;
        }
        if (this.isCreate() || this.isUpdate()) {
            if (this._clientInterestListInv != null && this._clientInterestListInv.contains(proxyId)) {
                message = new Message(6, clientVersion);
                message.setMessageType(15);
                message.addStringPart(this._regionName);
                message.addStringOrObjPart(this._keyOfInterest);
                message.addObjPart(this._callbackArgument);
                message.addObjPart(this.isClientInterested(proxyId));
                message.addObjPart(Boolean.FALSE);
            } else {
                boolean isClientInterested = this.isClientInterested(proxyId);
                message = new Message(8 + cqMsgParts, clientVersion);
                if (this.isCreate()) {
                    message.setMessageType(27);
                    message.addStringPart(this._regionName);
                    message.addStringOrObjPart(this._keyOfInterest);
                    message.addObjPart(Boolean.FALSE);
                    message.addRawPart(latestValue, this._valueIsObject == 1);
                } else {
                    message.setMessageType(28);
                    message.addStringPart(this._regionName);
                    message.addStringOrObjPart(this._keyOfInterest);
                    if (!(this.deltaBytes == null || conflation || proxy.isMarkerEnqueued() || proxy.getRegionsWithEmptyDataPolicy().containsKey(this._regionName))) {
                        message.addObjPart(Boolean.TRUE);
                        message.addBytesPart(this.deltaBytes);
                        proxy.getStatistics().incDeltaMessagesSent();
                    } else {
                        message.addObjPart(Boolean.FALSE);
                        byte[] l = latestValue;
                        if (l == null) {
                            if (!(this._value instanceof byte[])) {
                                this._value = CacheServerHelper.serialize(this._value);
                            }
                            l = (byte[])this._value;
                        }
                        message.addRawPart(l, this._valueIsObject == 1);
                    }
                }
                message.addObjPart(this._callbackArgument);
                message.addObjPart(isClientInterested);
                message.addObjPart(clientHasCq);
                if (clientHasCq) {
                    this.addCqsToMessage(proxyId, message);
                }
            }
        } else if (this.isDestroy() || this.isInvalidate()) {
            message = new Message(6 + cqMsgParts, clientVersion);
            if (this.isDestroy()) {
                message.setMessageType(16);
            } else {
                message.setMessageType(15);
            }
            message.addStringPart(this._regionName);
            message.addStringOrObjPart(this._keyOfInterest);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(this.isClientInterested(proxyId));
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isDestroyRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(17);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isClearRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(36);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isInvalidateRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(55);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else {
            throw new InternalGemFireError("Don't know what kind of message");
        }
        message.setTransactionId(0);
        message.addObjPart(this._eventIdentifier);
        return message;
    }

    protected Message getGFE65Message(CacheClientProxy proxy, byte[] p_latestValue, boolean conflation, Version clientVersion) throws IOException {
        boolean clientHasCq;
        byte[] latestValue = p_latestValue;
        Message message = null;
        ClientProxyMembershipID proxyId = proxy.getProxyID();
        int cqMsgParts = 0;
        boolean bl = clientHasCq = this._hasCqs && this.getCqs(proxyId) != null;
        if (clientHasCq) {
            cqMsgParts = this.getCqs(proxyId).length * 2 + 1;
        }
        if (this.isCreate() || this.isUpdate()) {
            if (this._clientInterestListInv != null && this._clientInterestListInv.contains(proxyId)) {
                if (cqMsgParts > 0) {
                    ++cqMsgParts;
                }
                message = new Message(6 + cqMsgParts, clientVersion);
                message.setMessageType(15);
                message.addStringPart(this._regionName);
                message.addStringOrObjPart(this._keyOfInterest);
            } else {
                message = new Message(8 + cqMsgParts, clientVersion);
                if (this.isCreate()) {
                    message.setMessageType(27);
                    message.addStringPart(this._regionName);
                    message.addStringOrObjPart(this._keyOfInterest);
                    message.addObjPart(Boolean.FALSE);
                    message.addRawPart(latestValue, this._valueIsObject == 1);
                } else {
                    message.setMessageType(28);
                    message.addStringPart(this._regionName);
                    message.addStringOrObjPart(this._keyOfInterest);
                    if (!(this.deltaBytes == null || conflation || proxy.isMarkerEnqueued() || proxy.getRegionsWithEmptyDataPolicy().containsKey(this._regionName))) {
                        message.addObjPart(Boolean.TRUE);
                        message.addBytesPart(this.deltaBytes);
                        proxy.getStatistics().incDeltaMessagesSent();
                    } else {
                        message.addObjPart(Boolean.FALSE);
                        if (latestValue == null) {
                            if (!(this._value instanceof byte[])) {
                                this._value = CacheServerHelper.serialize(this._value);
                            }
                            latestValue = (byte[])this._value;
                        }
                        message.addRawPart(latestValue, this._valueIsObject == 1);
                    }
                }
            }
            message.addObjPart(this._callbackArgument);
            message.addObjPart(this.isClientInterested(proxyId));
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                if (message.getMessageType() == 15) {
                    message.addIntPart(this.isCreate() ? 27 : 28);
                }
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isDestroy() || this.isInvalidate()) {
            if (this.isDestroy()) {
                message = new Message(6 + cqMsgParts, clientVersion);
                message.setMessageType(16);
            } else {
                if (clientHasCq) {
                    ++cqMsgParts;
                }
                message = new Message(6 + cqMsgParts, clientVersion);
                message.setMessageType(15);
            }
            message.addStringPart(this._regionName);
            message.addStringOrObjPart(this._keyOfInterest);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(this.isClientInterested(proxyId));
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                if (this.isInvalidate()) {
                    message.addIntPart(15);
                }
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isDestroyRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(17);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isClearRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(36);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isInvalidateRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(55);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else {
            throw new InternalGemFireError("Don't know what kind of message");
        }
        message.setTransactionId(0);
        message.addObjPart(this._eventIdentifier);
        return message;
    }

    protected Message getGFE70Message(CacheClientProxy proxy, byte[] p_latestValue, boolean conflation, Version clientVersion) throws IOException {
        boolean clientHasCq;
        byte[] latestValue = p_latestValue;
        Message message = null;
        ClientProxyMembershipID proxyId = proxy.getProxyID();
        int cqMsgParts = 0;
        boolean bl = clientHasCq = this._hasCqs && this.getCqs(proxyId) != null;
        if (clientHasCq) {
            cqMsgParts = this.getCqs(proxyId).length * 2 + 1;
        }
        if (this.isCreate() || this.isUpdate()) {
            if (this._clientInterestListInv != null && this._clientInterestListInv.contains(proxyId)) {
                if (cqMsgParts > 0) {
                    ++cqMsgParts;
                }
                message = new Message(7 + cqMsgParts, clientVersion);
                message.setMessageType(15);
                message.addStringPart(this._regionName);
                message.addStringOrObjPart(this._keyOfInterest);
            } else {
                message = new Message(9 + cqMsgParts, clientVersion);
                if (this.isCreate()) {
                    message.setMessageType(27);
                    message.addStringPart(this._regionName);
                    message.addStringOrObjPart(this._keyOfInterest);
                    message.addObjPart(Boolean.FALSE);
                    message.addRawPart(latestValue, this._valueIsObject == 1);
                } else {
                    message.setMessageType(28);
                    message.addStringPart(this._regionName);
                    message.addStringOrObjPart(this._keyOfInterest);
                    if (!(this.deltaBytes == null || conflation || proxy.isMarkerEnqueued() || proxy.getRegionsWithEmptyDataPolicy().containsKey(this._regionName))) {
                        message.addObjPart(Boolean.TRUE);
                        message.addBytesPart(this.deltaBytes);
                        proxy.getStatistics().incDeltaMessagesSent();
                    } else {
                        message.addObjPart(Boolean.FALSE);
                        if (latestValue == null) {
                            if (!(this._value instanceof byte[])) {
                                this._value = CacheServerHelper.serialize(this._value);
                            }
                            latestValue = (byte[])this._value;
                        }
                        message.addRawPart(latestValue, this._valueIsObject == 1);
                    }
                }
            }
            message.addObjPart(this._callbackArgument);
            if (this.versionTag != null) {
                this.versionTag.setCanonicalIDs(proxy.getCache().getDistributionManager());
            }
            message.addObjPart(this.versionTag);
            message.addObjPart(this.isClientInterested(proxyId));
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                if (message.getMessageType() == 15) {
                    message.addIntPart(this.isCreate() ? 27 : 28);
                }
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isDestroy() || this.isInvalidate()) {
            if (this.isDestroy()) {
                message = new Message(7 + cqMsgParts, clientVersion);
                message.setMessageType(16);
            } else {
                if (clientHasCq) {
                    ++cqMsgParts;
                }
                message = new Message(7 + cqMsgParts, clientVersion);
                message.setMessageType(15);
            }
            message.addStringPart(this._regionName);
            message.addStringOrObjPart(this._keyOfInterest);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(this.versionTag);
            message.addObjPart(this.isClientInterested(proxyId));
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                if (this.isInvalidate()) {
                    message.addIntPart(15);
                }
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isDestroyRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(17);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isClearRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(36);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else if (this.isInvalidateRegion()) {
            message = new Message(4 + cqMsgParts, clientVersion);
            message.setMessageType(55);
            message.addStringPart(this._regionName);
            message.addObjPart(this._callbackArgument);
            message.addObjPart(clientHasCq);
            if (clientHasCq) {
                this.addCqsToMessage(proxyId, message);
            }
        } else {
            throw new InternalGemFireError("Don't know what kind of message");
        }
        message.setTransactionId(0);
        message.addObjPart(this._eventIdentifier);
        return message;
    }

    @Override
    public boolean isNetLoad() {
        return this._isNetLoad;
    }

    @Override
    public void setIsNetLoad(boolean isNetLoad) {
        this._isNetLoad = isNetLoad;
    }

    @Override
    public boolean hasCqs(ClientProxyMembershipID clientId) {
        CqNameToOp cqs;
        return this._clientCqs != null && (cqs = (CqNameToOp)this._clientCqs.get(clientId)) != null && !cqs.isEmpty();
    }

    @Override
    public boolean hasCqs() {
        return this._hasCqs;
    }

    public String[] getCqs(ClientProxyMembershipID clientId) {
        CqNameToOp cqs;
        String[] cqNames = null;
        if (this._clientCqs != null && (cqs = (CqNameToOp)this._clientCqs.get(clientId)) != null && !cqs.isEmpty()) {
            cqNames = cqs.getNames();
        }
        return cqNames;
    }

    public ClientCqConcurrentMap getClientCqs() {
        return this._clientCqs;
    }

    public void addClientCqs(ClientProxyMembershipID clientId, CqNameToOp filteredCqs) {
        if (this._clientCqs == null) {
            this._clientCqs = new ClientCqConcurrentMap();
            this._hasCqs = true;
        }
        this._clientCqs.put(clientId, filteredCqs);
    }

    public void addClientCq(ClientProxyMembershipID clientId, String cqName, Integer cqEvent) {
        CqNameToOp cqInfo;
        if (this._clientCqs == null) {
            this._clientCqs = new ClientCqConcurrentMap();
            this._hasCqs = true;
        }
        if ((cqInfo = (CqNameToOp)this._clientCqs.get(clientId)) == null) {
            cqInfo = new CqNameToOpSingleEntry(cqName, cqEvent);
            this._clientCqs.put(clientId, cqInfo);
        } else if (!cqInfo.isFull()) {
            cqInfo.add(cqName, cqEvent);
        } else {
            cqInfo = new CqNameToOpHashMap((CqNameToOpSingleEntry)cqInfo);
            cqInfo.add(cqName, cqEvent);
            this._clientCqs.put(clientId, cqInfo);
        }
    }

    private void addCqsToMessage(ClientProxyMembershipID proxyId, Message message) {
        CqNameToOp cqs;
        if (this._clientCqs != null && (cqs = (CqNameToOp)this._clientCqs.get(proxyId)) != null) {
            message.addIntPart(cqs.size() * 2);
            cqs.addToMessage(message);
        }
    }

    public void removeClientCq(ClientProxyMembershipID clientId, InternalCqQuery cqToClose) {
        CqNameToOp cqs = this.getClientCq(clientId);
        if (cqs != null) {
            cqs.delete(cqToClose.getName());
            if (cqs.isEmpty()) {
                this._clientCqs.remove(clientId);
            }
        }
    }

    @Override
    public void setRegionName(String regionName) {
        this._regionName = regionName;
    }

    public void setEventIdentifier(EventID eventId) {
        if (this._eventIdentifier == null) {
            this._eventIdentifier = eventId;
        }
    }

    public void setClientCqs(ClientCqConcurrentMap clientCqs) {
        if (this._clientCqs == null) {
            this._clientCqs = clientCqs;
        }
    }

    public void addClientInterestList(Set clientIds, boolean receiveValues) {
        if (receiveValues) {
            if (this._clientInterestList == null) {
                this._clientInterestList = clientIds;
            } else {
                this._clientInterestList.addAll(clientIds);
            }
        } else if (this._clientInterestListInv == null) {
            this._clientInterestListInv = clientIds;
        } else {
            this._clientInterestListInv.addAll(clientIds);
        }
    }

    public void addClientInterestList(ClientProxyMembershipID clientId, boolean receiveValues) {
        if (receiveValues) {
            HashSet<ClientProxyMembershipID> newInterests = this._clientInterestList == null ? new HashSet<ClientProxyMembershipID>() : new HashSet<ClientProxyMembershipID>(this._clientInterestList);
            newInterests.add(clientId);
            this._clientInterestList = newInterests;
        } else {
            HashSet<ClientProxyMembershipID> newInterests = this._clientInterestListInv == null ? new HashSet<ClientProxyMembershipID>() : new HashSet<ClientProxyMembershipID>(this._clientInterestListInv);
            newInterests.add(clientId);
            this._clientInterestListInv = newInterests;
        }
    }

    @Override
    public boolean isClientInterested(ClientProxyMembershipID clientId) {
        return this._clientInterestList != null && this._clientInterestList.contains(clientId) || this._clientInterestListInv != null && this._clientInterestListInv.contains(clientId);
    }

    public boolean isClientInterestedInUpdates(ClientProxyMembershipID clientId) {
        return this._clientInterestList != null && this._clientInterestList.contains(clientId);
    }

    public boolean isClientInterestedInInvalidates(ClientProxyMembershipID clientId) {
        return this._clientInterestListInv != null && this._clientInterestListInv.contains(clientId);
    }

    protected Object deserialize(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(serializedBytes));
            deserializedObject = DataSerializer.readObject(dis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientUpdateMessageImpl[").append("op=").append(this._operation).append(";region=").append(this._regionName).append(";key=").append(this._keyOfInterest);
        if (logger.isTraceEnabled()) {
            buffer.append(";value=").append(this._value instanceof byte[] ? this.deserialize((byte[])this._value) : this._value);
        }
        buffer.append(";isObject=").append(this._valueIsObject).append(";cbArg=").append(this._callbackArgument).append(";memberId=").append(this._membershipId).append(";eventId=").append(this._eventIdentifier).append(";shouldConflate=").append(this._shouldConflate).append(";versionTag=").append(this.versionTag).append(";hasCqs=").append(this._hasCqs).append("]");
        return buffer.toString();
    }

    @Override
    public int getDSFID() {
        return 35;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeByte(this._operation.getEventCode());
        DataSerializer.writeString(this._regionName, out);
        DataSerializer.writeObject(this._keyOfInterest, out);
        if (this._value instanceof byte[]) {
            DataSerializer.writeByteArray((byte[])this._value, out);
        } else {
            DataSerializer.writeByteArray(CacheServerHelper.serialize(this._value), out);
        }
        out.writeByte(this._valueIsObject);
        DataSerializer.writeObject(this._membershipId, out);
        out.writeBoolean(this._shouldConflate);
        out.writeBoolean(this._isInterestListPassed);
        DataSerializer.writeByteArray(this.deltaBytes, out);
        out.writeBoolean(this._hasCqs);
        DataSerializer.writeObject(this._callbackArgument, out);
        DataSerializer.writeHashSet((HashSet)this._clientInterestList, out);
        DataSerializer.writeHashSet((HashSet)this._clientInterestListInv, out);
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this._operation = EnumListenerEvent.getEnumListenerEvent(in.readByte());
        this._regionName = DataSerializer.readString(in);
        this._keyOfInterest = DataSerializer.readObject(in);
        this._value = DataSerializer.readByteArray(in);
        this._valueIsObject = in.readByte();
        this._membershipId = ClientProxyMembershipID.readCanonicalized(in);
        this._shouldConflate = in.readBoolean();
        this._isInterestListPassed = in.readBoolean();
        this.deltaBytes = DataSerializer.readByteArray(in);
        this._hasCqs = in.readBoolean();
        this._callbackArgument = DataSerializer.readObject(in);
        CacheClientNotifier ccn = CacheClientNotifier.getInstance();
        HashSet ids = DataSerializer.readHashSet(in);
        if (ccn != null && ids != null) {
            ids = (HashSet)ccn.getProxyIDs(ids);
        }
        this._clientInterestList = ids;
        ids = DataSerializer.readHashSet(in);
        if (ccn != null && ids != null) {
            ids = (HashSet)ccn.getProxyIDs(ids);
        }
        this._clientInterestListInv = ids;
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    private Object getOriginalCallbackArgument() {
        Object result = this._callbackArgument;
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        return result;
    }

    @Override
    public int getSizeInBytes() {
        int size = CONSTANT_MEMORY_OVERHEAD;
        if (this._value != null) {
            size += CachedDeserializableFactory.calcMemSize(this._value);
        }
        return size += this.sizeOf(this.getOriginalCallbackArgument());
    }

    private int sizeOf(Object obj) {
        int size = 0;
        if (obj == null) {
            return size;
        }
        size = obj instanceof String ? ObjectSizer.DEFAULT.sizeof(obj) : (obj instanceof Integer ? 4 : (obj instanceof Long ? 8 : CachedDeserializableFactory.calcMemSize(obj) - 8));
        return size;
    }

    @Override
    public boolean needsNoAuthorizationCheck() {
        return false;
    }

    @Override
    public CqNameToOp getClientCq(ClientProxyMembershipID clientId) {
        if (this._clientCqs != null) {
            return (CqNameToOp)this._clientCqs.get(clientId);
        }
        return null;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public boolean prefersNewSerialized() {
        return true;
    }

    @Override
    public boolean isUnretainedNewReferenceOk() {
        return false;
    }

    @Override
    public void importNewObject(Object nv, boolean isSerialized) {
        if (!isSerialized) {
            throw new IllegalStateException("Expected importNewBytes to be called.");
        }
        try {
            this._value = CacheServerHelper.serialize(nv);
        }
        catch (IOException e) {
            throw new GemFireIOException("Exception serializing entry value", e);
        }
    }

    @Override
    public void importNewBytes(byte[] nv, boolean isSerialized) {
        if (!isSerialized) {
            this._valueIsObject = 0;
        }
        this._value = nv;
    }

    static {
        int size = 0;
        size += 8;
        size += 40;
        size += 5;
        size += 202;
        CONSTANT_MEMORY_OVERHEAD = size += 8;
    }

    public static class CqNameToOpHashMap
    extends HashMap<String, Integer>
    implements CqNameToOp {
        public CqNameToOpHashMap(int initialCapacity) {
            super(initialCapacity, 1.0f);
        }

        public CqNameToOpHashMap(CqNameToOpSingleEntry se) {
            super(2, 1.0f);
            this.add(se.name, se.op);
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            out.writeByte(67);
            DataSerializer.writeHashMap(this, out);
        }

        @Override
        public String[] getNames() {
            String[] cqNames = new String[this.size()];
            cqNames = this.keySet().toArray(cqNames);
            return cqNames;
        }

        @Override
        public void addToMessage(Message message) {
            for (Map.Entry entry : this.entrySet()) {
                String cq = (String)entry.getKey();
                message.addStringPart(cq);
                int op = (Integer)entry.getValue();
                message.addIntPart(op);
            }
        }

        @Override
        public void add(String name, Integer op) {
            this.put(name, op);
        }

        @Override
        public void delete(String name) {
            this.remove(name);
        }

        @Override
        public boolean isFull() {
            return false;
        }
    }

    public static class CqNameToOpSingleEntry
    implements CqNameToOp {
        private String name;
        private int op;

        public CqNameToOpSingleEntry(String name, Integer op) {
            this.name = name;
            this.op = op;
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            out.writeByte(67);
            int size = this.size();
            InternalDataSerializer.writeArrayLength(size, out);
            if (size > 0) {
                DataSerializer.writeObject(this.name, out);
                DataSerializer.writeObject(this.op, out);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.name == null;
        }

        @Override
        public void addToMessage(Message message) {
            if (!this.isEmpty()) {
                message.addStringPart(this.name);
                message.addIntPart(this.op);
            }
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public String[] getNames() {
            if (this.isEmpty()) {
                return new String[0];
            }
            return new String[]{this.name};
        }

        @Override
        public void add(String name, Integer op) {
            if (this.isEmpty()) {
                this.name = name;
                this.op = op;
            } else if (this.name.equals(name)) {
                this.op = op;
            } else {
                throw new IllegalStateException("tried to add to a full CqNameToOpSingleEntry");
            }
        }

        @Override
        public void delete(String name) {
            if (name.equals(this.name)) {
                this.name = null;
            }
        }

        @Override
        public boolean isFull() {
            return !this.isEmpty();
        }
    }

    public static interface CqNameToOp
    extends Sendable {
        public boolean isEmpty();

        public boolean isFull();

        public void addToMessage(Message var1);

        public int size();

        public String[] getNames();

        public void add(String var1, Integer var2);

        public void delete(String var1);
    }

    public static class ClientCqConcurrentMap
    extends ConcurrentHashMap<ClientProxyMembershipID, CqNameToOp> {
        public ClientCqConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            super(initialCapacity, loadFactor, concurrencyLevel);
        }

        public ClientCqConcurrentMap() {
            super(16, 1.0f, 1);
        }
    }
}

