/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ClientPingMessageImpl
implements ClientMessage {
    private static final long serialVersionUID = 5423895238521508743L;

    @Override
    public Message getMessage(CacheClientProxy proxy, boolean notify) throws IOException {
        Version clientVersion = proxy.getVersion();
        Message message = null;
        if (clientVersion.compareTo(Version.GFE_6622) < 0) {
            throw new IOException("Unsupported client version for server-to-client message creation: " + clientVersion);
        }
        message = this.getGFEMessage();
        return message;
    }

    protected Message getGFEMessage() throws IOException {
        Message message = new Message(0, Version.CURRENT);
        message.setMessageType(99);
        message.setTransactionId(0);
        return message;
    }

    @Override
    public boolean shouldBeConflated() {
        return true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public int getDSFID() {
        return -122;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public EventID getEventId() {
        return null;
    }

    @Override
    public String getRegionToConflate() {
        return "gemfire_reserved_region_name_for_client_ping";
    }

    @Override
    public Object getKeyToConflate() {
        return "ping";
    }

    @Override
    public Object getValueToConflate() {
        return "ping";
    }

    @Override
    public void setLatestValue(Object value) {
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

