/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ClientMarkerMessageImpl
implements ClientMessage {
    private static final long serialVersionUID = 5423895238521508743L;
    private EventID eventId;

    public ClientMarkerMessageImpl(EventID eventId) {
        this.eventId = eventId;
    }

    public ClientMarkerMessageImpl() {
    }

    @Override
    public Message getMessage(CacheClientProxy proxy, boolean notify) throws IOException {
        Version clientVersion = proxy.getVersion();
        Message message = null;
        if (clientVersion.compareTo(Version.GFE_57) < 0) {
            throw new IOException("Unsupported client version for server-to-client message creation: " + clientVersion);
        }
        message = this.getGFEMessage();
        return message;
    }

    protected Message getGFEMessage() throws IOException {
        Message message = new Message(1, Version.CURRENT);
        message.setMessageType(54);
        message.setTransactionId(0);
        message.addObjPart(this.eventId);
        return message;
    }

    @Override
    public boolean shouldBeConflated() {
        return true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.eventId, out);
    }

    @Override
    public int getDSFID() {
        return -77;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.eventId = (EventID)DataSerializer.readObject(in);
    }

    @Override
    public EventID getEventId() {
        return this.eventId;
    }

    @Override
    public String getRegionToConflate() {
        return "gemfire_reserved_region_name_for_durable_client_marker";
    }

    @Override
    public Object getKeyToConflate() {
        return "marker";
    }

    @Override
    public Object getValueToConflate() {
        return "marker";
    }

    @Override
    public void setLatestValue(Object value) {
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

