/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.MessageStats;

public class CacheClientProxyStats
implements MessageStats {
    private static final StatisticsType _type;
    private static final String MESSAGES_RECEIVED = "messagesReceived";
    private static final String MESSAGES_QUEUED = "messagesQueued";
    private static final String MESSAGES_NOT_QUEUED_ORIGINATOR = "messagesNotQueuedOriginator";
    private static final String MESSAGES_NOT_QUEUED_NOT_INTERESTED = "messagesNotQueuedNotInterested";
    private static final String MESSAGES_FAILED_QUEUED = "messagesFailedQueued";
    private static final String MESSAGE_QUEUE_SIZE = "messageQueueSize";
    private static final String MESSAGES_PROCESSED = "messagesProcessed";
    private static final String MESSAGE_PROCESSING_TIME = "messageProcessingTime";
    private static final String DELTA_MESSAGES_SENT = "deltaMessagesSent";
    private static final String DELTA_FULL_MESSAGES_SENT = "deltaFullMessagesSent";
    private static final String CQ_COUNT = "cqCount";
    private static final int _messagesReceivedId;
    private static final int _messagesQueuedId;
    private static final int _messagesNotQueuedOriginatorId;
    private static final int _messagesNotQueuedNotInterestedId;
    private static final int _messagesFailedQueuedId;
    private static final int _messageQueueSizeId;
    private static final int _messagesProcessedId;
    private static final int _messageProcessingTimeId;
    private static final int _deltaMessagesSentId;
    private static final int _deltaFullMessagesSentId;
    private static final int _cqCountId;
    private static final int _sentBytesId;
    private final Statistics _stats;

    public CacheClientProxyStats(StatisticsFactory factory, String name) {
        this._stats = factory.createAtomicStatistics(_type, "cacheClientProxyStats-" + name);
    }

    public void close() {
        this._stats.close();
    }

    public int getMessagesReceived() {
        return this._stats.getInt(_messagesReceivedId);
    }

    public int getMessagesQueued() {
        return this._stats.getInt(_messagesQueuedId);
    }

    public int getMessagesNotQueuedOriginator() {
        return this._stats.getInt(_messagesNotQueuedOriginatorId);
    }

    public int getMessagesNotQueuedNotInterested() {
        return this._stats.getInt(_messagesNotQueuedNotInterestedId);
    }

    public int getMessagesFailedQueued() {
        return this._stats.getInt(_messagesFailedQueuedId);
    }

    public int getMessageQueueSize() {
        return this._stats.getInt(_messageQueueSizeId);
    }

    public int getMessagesProcessed() {
        return this._stats.getInt(_messagesProcessedId);
    }

    public long getMessageProcessingTime() {
        return this._stats.getLong(_messageProcessingTimeId);
    }

    public int getDeltaMessagesSent() {
        return this._stats.getInt(_deltaMessagesSentId);
    }

    public int getDeltaFullMessagesSent() {
        return this._stats.getInt(_deltaFullMessagesSentId);
    }

    public int getCqCount() {
        return this._stats.getInt(_cqCountId);
    }

    public void incMessagesReceived() {
        this._stats.incInt(_messagesReceivedId, 1);
    }

    public void incMessagesQueued() {
        this._stats.incInt(_messagesQueuedId, 1);
    }

    public void incMessagesNotQueuedOriginator() {
        this._stats.incInt(_messagesNotQueuedOriginatorId, 1);
    }

    public void incMessagesNotQueuedNotInterested() {
        this._stats.incInt(_messagesNotQueuedNotInterestedId, 1);
    }

    public void incMessagesFailedQueued() {
        this._stats.incInt(_messagesFailedQueuedId, 1);
    }

    public void incCqCount() {
        this._stats.incInt(_cqCountId, 1);
    }

    public void decCqCount() {
        this._stats.incInt(_cqCountId, -1);
    }

    public void setQueueSize(int size) {
        this._stats.setInt(_messageQueueSizeId, size);
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    public void endMessage(long start) {
        long ts = DistributionStats.getStatTime();
        this._stats.incInt(_messagesProcessedId, 1);
        long elapsed = ts - start;
        this._stats.incLong(_messageProcessingTimeId, elapsed);
    }

    public void incDeltaMessagesSent() {
        this._stats.incInt(_deltaMessagesSentId, 1);
    }

    public void incDeltaFullMessagesSent() {
        this._stats.incInt(_deltaFullMessagesSentId, 1);
    }

    @Override
    public final void incReceivedBytes(long v) {
    }

    @Override
    public final void incSentBytes(long v) {
        this._stats.incLong(_sentBytesId, v);
    }

    @Override
    public void incMessagesBeingReceived(int bytes) {
    }

    @Override
    public void decMessagesBeingReceived(int bytes) {
    }

    static {
        String statName = "CacheClientProxyStatistics";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(statName, statName, new StatisticDescriptor[]{f.createIntCounter(MESSAGES_RECEIVED, "Number of client messages received.", "operations"), f.createIntCounter(MESSAGES_QUEUED, "Number of client messages added to the message queue.", "operations"), f.createIntCounter(MESSAGES_FAILED_QUEUED, "Number of client messages attempted but failed to be added to the message queue.", "operations"), f.createIntCounter(MESSAGES_NOT_QUEUED_ORIGINATOR, "Number of client messages received but not added to the message queue because the receiving proxy represents the client originating the message.", "operations"), f.createIntCounter(MESSAGES_NOT_QUEUED_NOT_INTERESTED, "Number of client messages received but not added to the message queue because the client represented by the receiving proxy was not interested in the message's key.", "operations"), f.createIntGauge(MESSAGE_QUEUE_SIZE, "Size of the message queue.", "operations"), f.createIntCounter(MESSAGES_PROCESSED, "Number of client messages removed from the message queue and sent.", "operations"), f.createLongCounter(MESSAGE_PROCESSING_TIME, "Total time spent sending messages to clients.", "nanoseconds"), f.createIntCounter(DELTA_MESSAGES_SENT, "Number of client messages containing only delta bytes dispatched to the client.", "operations"), f.createIntCounter(DELTA_FULL_MESSAGES_SENT, "Number of client messages dispatched in reponse to failed delta at client.", "operations"), f.createLongCounter(CQ_COUNT, "Number of CQs on the client.", "operations"), f.createLongCounter("sentBytes", "Total number of bytes sent to client.", "bytes")});
        _messagesReceivedId = _type.nameToId(MESSAGES_RECEIVED);
        _messagesQueuedId = _type.nameToId(MESSAGES_QUEUED);
        _messagesNotQueuedOriginatorId = _type.nameToId(MESSAGES_NOT_QUEUED_ORIGINATOR);
        _messagesNotQueuedNotInterestedId = _type.nameToId(MESSAGES_NOT_QUEUED_NOT_INTERESTED);
        _messagesFailedQueuedId = _type.nameToId(MESSAGES_FAILED_QUEUED);
        _messageQueueSizeId = _type.nameToId(MESSAGE_QUEUE_SIZE);
        _messagesProcessedId = _type.nameToId(MESSAGES_PROCESSED);
        _messageProcessingTimeId = _type.nameToId(MESSAGE_PROCESSING_TIME);
        _deltaMessagesSentId = _type.nameToId(DELTA_MESSAGES_SENT);
        _deltaFullMessagesSentId = _type.nameToId(DELTA_FULL_MESSAGES_SENT);
        _cqCountId = _type.nameToId(CQ_COUNT);
        _sentBytesId = _type.nameToId("sentBytes");
    }
}

