/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.operations.QueryOperationContext;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.CqEntry;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.cq.ServerCQ;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class BaseCommandQuery
extends BaseCommand {
    protected static boolean processQuery(Message msg, Query query, String queryString, Set regionNames, long start, ServerCQ cqQuery, QueryOperationContext queryContext, ServerConnection servConn, boolean sendResults) throws IOException, InterruptedException {
        return BaseCommandQuery.processQueryUsingParams(msg, query, queryString, regionNames, start, cqQuery, queryContext, servConn, sendResults, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean processQueryUsingParams(Message msg, Query query, String queryString, Set regionNames, long start, ServerCQ cqQuery, QueryOperationContext queryContext, ServerConnection servConn, boolean sendResults, Object[] params) throws IOException, InterruptedException {
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        CacheServerStats stats = servConn.getCacheServerStats();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadQueryRequestTime(start - oldStart);
        if (servConn.getClientVersion().compareTo(Version.GFE_70) >= 0) {
            ((DefaultQuery)query).setRemoteQuery(true);
        }
        try {
            Object result = null;
            result = params != null ? query.execute(params) : query.execute();
            for (String regionName : regionNames) {
                if (crHelper.getRegion(regionName) != null) continue;
                throw new RegionDestroyedException(LocalizedStrings.BaseCommand_REGION_DESTROYED_DURING_THE_EXECUTION_OF_THE_QUERY.toLocalizedString(), regionName);
            }
            AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
            if (postAuthzRequest != null) {
                queryContext = cqQuery == null ? postAuthzRequest.queryAuthorize(queryString, regionNames, result, queryContext, params) : postAuthzRequest.executeCQAuthorize(cqQuery.getName(), queryString, regionNames, result, queryContext);
                result = queryContext.getQueryResult();
            }
            if (result instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)result;
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Result size for : {} is {}", new Object[]{query.getQueryString(), selectResults.size()});
                }
                CollectionType collectionType = null;
                boolean sendCqResultsWithKey = true;
                boolean isStructs = false;
                boolean hasSerializedObjects = ((DefaultQuery)query).isKeepSerialized();
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Result for :{} has serialized objects: {}", new Object[]{query.getQueryString(), hasSerializedObjects});
                }
                collectionType = selectResults.getCollectionType();
                isStructs = collectionType.getElementType().isStructType();
                if (cqQuery != null && (sendCqResultsWithKey = BaseCommandQuery.sendCqResultsWithKey(servConn))) {
                    collectionType = new CollectionTypeImpl(Collection.class, (ObjectType)new StructTypeImpl(new String[]{"key", "value"}));
                    isStructs = collectionType.getElementType().isStructType();
                }
                int numberOfChunks = (int)Math.ceil((double)selectResults.size() * 1.0 / (double)maximumChunkSize);
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Query results size: {}: Entries in chunk: {}: Number of chunks: {}", new Object[]{servConn.getName(), selectResults.size(), maximumChunkSize, numberOfChunks});
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessQueryTime(start - oldStart2);
                if (sendResults) {
                    queryResponseMsg.setMessageType(1);
                    queryResponseMsg.setTransactionId(msg.getTransactionId());
                    queryResponseMsg.sendHeader();
                }
                if (sendResults && numberOfChunks == 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("{}: Creating chunk: 0", new Object[]{servConn.getName()});
                    }
                    BaseCommandQuery.writeQueryResponseChunk(new Object[0], collectionType, true, servConn);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Sent chunk (1 of 1) of query response for query {}", new Object[]{servConn.getName(), queryString});
                    }
                } else if (hasSerializedObjects) {
                    BaseCommandQuery.sendResultsAsObjectPartList(numberOfChunks, servConn, selectResults.asList(), isStructs, collectionType, queryString, cqQuery, sendCqResultsWithKey, sendResults);
                } else {
                    BaseCommandQuery.sendResultsAsObjectArray(selectResults, numberOfChunks, servConn, isStructs, collectionType, queryString, cqQuery, sendCqResultsWithKey, sendResults);
                }
                if (cqQuery != null) {
                    cqQuery.setCqResultsCacheInitialized();
                }
            } else {
                if (!(result instanceof Integer)) {
                    throw new QueryInvalidException(LocalizedStrings.BaseCommand_UNKNOWN_RESULT_TYPE_0.toLocalizedString(result.getClass()));
                }
                if (sendResults) {
                    queryResponseMsg.setMessageType(1);
                    queryResponseMsg.setTransactionId(msg.getTransactionId());
                    queryResponseMsg.sendHeader();
                    BaseCommandQuery.writeQueryResponseChunk(result, null, true, servConn);
                }
            }
            msg.clearParts();
        }
        catch (QueryInvalidException e) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand_UNEXPECTED_QUERYINVALIDEXCEPTION_WHILE_PROCESSING_QUERY_0, queryString), (Throwable)e);
            QueryInvalidException qie = new QueryInvalidException(LocalizedStrings.BaseCommand_0_QUERYSTRING_IS_1.toLocalizedString(e.getLocalizedMessage(), queryString));
            BaseCommandQuery.writeQueryResponseException(msg, qie, false, servConn);
            return false;
        }
        catch (DistributedSystemDisconnectedException se) {
            if (msg != null && logger.isDebugEnabled()) {
                logger.debug("{}: ignoring message of type {} from client {} because shutdown occurred during message processing.", new Object[]{servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getProxyID()});
            }
            servConn.setFlagProcessMessagesAsFalse();
            return false;
        }
        catch (Exception e2222) {
            QueryException e2222;
            BaseCommandQuery.checkForInterrupt(servConn, e2222);
            DefaultQuery defaultQuery = (DefaultQuery)query;
            if (defaultQuery.isCanceled()) {
                e2222 = new QueryException(defaultQuery.getQueryCanceledException().getMessage(), e2222.getCause());
            }
            BaseCommandQuery.writeQueryResponseException(msg, e2222, false, servConn);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent query response for query {}", new Object[]{servConn.getName(), queryString});
        }
        stats.incWriteQueryResponseTime(DistributionStats.getStatTime() - start);
        return true;
    }

    private static boolean sendCqResultsWithKey(ServerConnection servConn) {
        Version clientVersion = servConn.getClientVersion();
        return clientVersion.compareTo(Version.GFE_65) >= 0;
    }

    protected static void sendCqResponse(int msgType, String msgStr, int txId, Throwable e, ServerConnection servConn) throws IOException {
        ChunkedMessage cqMsg = servConn.getChunkedResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("CQ Response message :{}", new Object[]{msgStr});
        }
        switch (msgType) {
            case 6: {
                cqMsg.setNumberOfParts(1);
                break;
            }
            case 47: {
                logger.warn(msgStr);
                cqMsg.setNumberOfParts(1);
                break;
            }
            case 50: {
                String exMsg = "";
                if (e != null) {
                    exMsg = e.getLocalizedMessage();
                }
                logger.info(msgStr + exMsg, e);
                msgStr = msgStr + exMsg;
                cqMsg.setNumberOfParts(1);
                break;
            }
            default: {
                msgType = 50;
                cqMsg.setNumberOfParts(1);
                msgStr = msgStr + LocalizedStrings.BaseCommand_UNKNOWN_QUERY_EXCEPTION.toLocalizedString();
            }
        }
        cqMsg.setMessageType(msgType);
        cqMsg.setTransactionId(txId);
        cqMsg.sendHeader();
        cqMsg.addStringPart(msgStr);
        cqMsg.setLastChunk(true);
        cqMsg.sendChunk(servConn);
        cqMsg.setLastChunk(true);
        if (logger.isDebugEnabled()) {
            logger.debug("CQ Response sent successfully");
        }
    }

    private static void sendResultsAsObjectArray(SelectResults selectResults, int numberOfChunks, ServerConnection servConn, boolean isStructs, CollectionType collectionType, String queryString, ServerCQ cqQuery, boolean sendCqResultsWithKey, boolean sendResults) throws IOException {
        int resultIndex = 0;
        int cqResultIndex = 0;
        Object[] objs = selectResults.toArray();
        for (int j = 0; j < numberOfChunks; ++j) {
            boolean incompleteArray = false;
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Creating chunk: {}", new Object[]{servConn.getName(), j});
            }
            Object[] results = new Object[maximumChunkSize];
            for (int i = 0; i < maximumChunkSize; ++i) {
                if (resultIndex == selectResults.size()) {
                    incompleteArray = true;
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Adding entry [{}] to query results: {}", new Object[]{servConn.getName(), resultIndex, objs[resultIndex]});
                }
                if (cqQuery != null) {
                    CqEntry e = (CqEntry)objs[resultIndex];
                    if (e.getValue() == null) {
                        ++resultIndex;
                        --i;
                        continue;
                    }
                    if (!cqQuery.isPR()) {
                        cqQuery.addToCqResultKeys(e.getKey());
                    }
                    results[i] = sendCqResultsWithKey ? e.getKeyValuePair() : e.getValue();
                } else {
                    results[i] = isStructs && objs[resultIndex] instanceof Struct ? ((Struct)objs[resultIndex]).getFieldValues() : objs[resultIndex];
                }
                ++resultIndex;
                ++cqResultIndex;
            }
            if (incompleteArray) {
                Object[] newResults = cqQuery != null ? new Object[cqResultIndex % maximumChunkSize] : new Object[resultIndex % maximumChunkSize];
                for (int i = 0; i < newResults.length; ++i) {
                    newResults[i] = results[i];
                }
                results = newResults;
            }
            if (sendResults) {
                BaseCommandQuery.writeQueryResponseChunk(results, collectionType, resultIndex == selectResults.size(), servConn);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent chunk ({} of {}) of query response for query: {}", new Object[]{servConn.getName(), j + 1, numberOfChunks, queryString});
                }
            }
            if (resultIndex == selectResults.size()) break;
        }
    }

    private static void sendResultsAsObjectPartList(int numberOfChunks, ServerConnection servConn, List objs, boolean isStructs, CollectionType collectionType, String queryString, ServerCQ cqQuery, boolean sendCqResultsWithKey, boolean sendResults) throws IOException {
        int resultIndex = 0;
        Object result = null;
        for (int j = 0; j < numberOfChunks; ++j) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Creating chunk: {}", new Object[]{servConn.getName(), j});
            }
            ObjectPartList serializedObjs = new ObjectPartList(maximumChunkSize, false);
            for (int i = 0; i < maximumChunkSize && resultIndex != objs.size(); ++i) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Adding entry [{}] to query results: {}", new Object[]{servConn.getName(), resultIndex, objs.get(resultIndex)});
                }
                if (cqQuery != null) {
                    CqEntry e = (CqEntry)objs.get(resultIndex);
                    if (e.getValue() == null) {
                        ++resultIndex;
                        continue;
                    }
                    if (!cqQuery.isPR()) {
                        cqQuery.addToCqResultKeys(e.getKey());
                    }
                    result = sendCqResultsWithKey ? e.getKeyValuePair() : e.getValue();
                } else {
                    result = objs.get(resultIndex);
                }
                if (sendResults) {
                    BaseCommandQuery.addToObjectPartList(serializedObjs, result, collectionType, false, servConn, isStructs);
                }
                ++resultIndex;
            }
            if (!sendResults) continue;
            BaseCommandQuery.writeQueryResponseChunk(serializedObjs, collectionType, j + 1 == numberOfChunks, servConn);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("{}: Sent chunk ({} of {}) of query response for query: {}", new Object[]{servConn.getName(), j + 1, numberOfChunks, queryString});
        }
    }

    private static void addToObjectPartList(ObjectPartList serializedObjs, Object res, CollectionType collectionType, boolean lastChunk, ServerConnection servConn, boolean isStructs) throws IOException {
        if (isStructs && res instanceof Struct) {
            Object[] values = ((Struct)res).getFieldValues();
            ObjectPartList serializedValueObjs = new ObjectPartList(values.length, false);
            for (Object value : values) {
                if (value instanceof CachedDeserializable) {
                    serializedValueObjs.addPart(null, ((CachedDeserializable)value).getSerializedValue(), (byte)1, null);
                    continue;
                }
                BaseCommandQuery.addDeSerializedObjectToObjectPartList(serializedValueObjs, value);
            }
            serializedObjs.addPart(null, serializedValueObjs, (byte)1, null);
        } else if (res instanceof Object[]) {
            Object[] values = (Object[])res;
            ObjectPartList serializedValueObjs = new ObjectPartList(values.length, false);
            for (Object value : values) {
                if (value instanceof CachedDeserializable) {
                    serializedValueObjs.addPart(null, ((CachedDeserializable)value).getSerializedValue(), (byte)1, null);
                    continue;
                }
                BaseCommandQuery.addDeSerializedObjectToObjectPartList(serializedValueObjs, value);
            }
            serializedObjs.addPart(null, serializedValueObjs, (byte)1, null);
        } else if (res instanceof CachedDeserializable) {
            serializedObjs.addPart(null, ((CachedDeserializable)res).getSerializedValue(), (byte)1, null);
        } else {
            BaseCommandQuery.addDeSerializedObjectToObjectPartList(serializedObjs, res);
        }
    }

    private static void addDeSerializedObjectToObjectPartList(ObjectPartList objPartList, Object obj) {
        if (obj instanceof byte[]) {
            objPartList.addPart(null, obj, (byte)0, null);
        } else {
            objPartList.addPart(null, obj, (byte)1, null);
        }
    }
}

