/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.CacheServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientHealthMonitor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.management.membership.ClientMembershipEvent;
import com.gemstone.gemfire.management.membership.ClientMembershipListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class InternalClientMembership {
    private static final Logger logger = LogService.getLogger();
    private static volatile List<ClientMembershipListener> clientMembershipListeners = Collections.emptyList();
    private static final Object membershipLock = new Object();
    private static ThreadPoolExecutor executor;
    private static final ThreadGroup threadGroup;
    private static final List systems;
    private static boolean isMonitoring;
    private static boolean forceSynchronous;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startMonitoring() {
        if (isMonitoring) {
            return;
        }
        List list = systems;
        synchronized (list) {
            List existingSystems = InternalDistributedSystem.addConnectListener(new InternalDistributedSystem.ConnectListener(){

                @Override
                public void onConnect(InternalDistributedSystem sys) {
                    InternalClientMembership.addInternalDistributedSystem(sys);
                }
            });
            isMonitoring = true;
            for (InternalDistributedSystem sys : existingSystems) {
                try {
                    if (!sys.isConnected()) continue;
                    InternalClientMembership.addInternalDistributedSystem(sys);
                }
                catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {}
            }
        }
    }

    private InternalClientMembership() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientMembershipListener(ClientMembershipListener listener) {
        InternalClientMembership.startMonitoring();
        Object object = membershipLock;
        synchronized (object) {
            List<ClientMembershipListener> oldListeners = clientMembershipListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<ClientMembershipListener> newListeners = new ArrayList<ClientMembershipListener>(oldListeners);
                newListeners.add(listener);
                clientMembershipListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClientMembershipListener(ClientMembershipListener listener) {
        InternalClientMembership.startMonitoring();
        Object object = membershipLock;
        synchronized (object) {
            ArrayList<ClientMembershipListener> newListeners;
            List<ClientMembershipListener> oldListeners = clientMembershipListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList<ClientMembershipListener>(oldListeners)).remove(listener)) {
                clientMembershipListeners = newListeners;
            }
        }
    }

    public static ClientMembershipListener[] getClientMembershipListeners() {
        InternalClientMembership.startMonitoring();
        List<ClientMembershipListener> l = clientMembershipListeners;
        ClientMembershipListener[] listeners = l.toArray(new ClientMembershipListener[l.size()]);
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAllListeners() {
        InternalClientMembership.startMonitoring();
        Object object = membershipLock;
        synchronized (object) {
            clientMembershipListeners = new ArrayList<ClientMembershipListener>();
        }
    }

    public static Map getConnectedClients(boolean onlyClientsNotifiedByThisServer) {
        ClientHealthMonitor chMon = ClientHealthMonitor.getInstance();
        Set filterProxyIDs = null;
        if (onlyClientsNotifiedByThisServer) {
            for (CacheServerImpl cacheServerImpl : CacheFactory.getAnyInstance().getCacheServers()) {
                AcceptorImpl ai = cacheServerImpl.getAcceptor();
                if (ai == null || ai.getCacheClientNotifier() == null) continue;
                if (filterProxyIDs != null) {
                    filterProxyIDs.addAll(ai.getCacheClientNotifier().getActiveClients());
                    continue;
                }
                filterProxyIDs = ai.getCacheClientNotifier().getActiveClients();
            }
        }
        Map map = chMon.getConnectedClients(filterProxyIDs);
        return map;
    }

    public static Map getStatusForAllClientsIgnoreSubscriptionStatus() {
        Map result = new HashMap();
        if (ClientHealthMonitor.getInstance() != null) {
            result = ClientHealthMonitor.getInstance().getStatusForAllClients();
        }
        return result;
    }

    public static Map getConnectedClients() {
        HashMap allClients = new HashMap();
        for (CacheServerImpl cacheServerImpl : CacheFactory.getAnyInstance().getCacheServers()) {
            AcceptorImpl ai = cacheServerImpl.getAcceptor();
            if (ai == null || ai.getCacheClientNotifier() == null) continue;
            allClients.putAll(ai.getCacheClientNotifier().getAllClients());
        }
        if (ClientHealthMonitor.getInstance() != null) {
            ClientHealthMonitor.getInstance().fillInClientInfo(allClients);
        }
        return allClients;
    }

    public static Map getClientQueueSizes() {
        HashMap clientQueueSizes = new HashMap();
        GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (c == null) {
            return clientQueueSizes;
        }
        for (CacheServerImpl bsi : c.getCacheServers()) {
            AcceptorImpl ai = bsi.getAcceptor();
            if (ai == null || ai.getCacheClientNotifier() == null) continue;
            clientQueueSizes.putAll(ai.getCacheClientNotifier().getClientQueueSizes());
        }
        return clientQueueSizes;
    }

    public static Map getConnectedServers() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Map<String, Pool> poolMap = PoolManager.getAll();
        for (PoolImpl poolImpl : poolMap.values()) {
            Map<ServerLocation, Endpoint> eps = poolImpl.getEndpointMap();
            for (Map.Entry<ServerLocation, Endpoint> entry : eps.entrySet()) {
                ServerLocation loc = entry.getKey();
                Endpoint ep = entry.getValue();
                String server = loc.getHostName() + "[" + loc.getPort() + "]";
                Integer count = (Integer)map.get(server);
                if (count == null) {
                    map.put(server, 1);
                    continue;
                }
                map.put(server, count + 1);
            }
        }
        return map;
    }

    public static Map getConnectedIncomingGateways() {
        HashMap connectedIncomingGateways = null;
        ClientHealthMonitor chMon = ClientHealthMonitor.getInstance();
        connectedIncomingGateways = chMon == null ? new HashMap() : chMon.getConnectedIncomingGateways();
        return connectedIncomingGateways;
    }

    public static void notifyJoined(final DistributedMember member, final boolean client) {
        InternalClientMembership.startMonitoring();
        ThreadPoolExecutor queuedExecutor = executor;
        if (queuedExecutor == null) {
            return;
        }
        final InternalClientMembershipEvent event = new InternalClientMembershipEvent(member, client);
        if (forceSynchronous) {
            InternalClientMembership.doNotifyClientMembershipListener(member, client, event, EventType.CLIENT_JOINED);
        } else {
            try {
                queuedExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InternalClientMembership.doNotifyClientMembershipListener(member, client, event, EventType.CLIENT_JOINED);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public static void notifyLeft(final DistributedMember member, final boolean client) {
        InternalClientMembership.startMonitoring();
        ThreadPoolExecutor queuedExecutor = executor;
        if (queuedExecutor == null) {
            return;
        }
        final InternalClientMembershipEvent event = new InternalClientMembershipEvent(member, client);
        if (forceSynchronous) {
            InternalClientMembership.doNotifyClientMembershipListener(member, client, event, EventType.CLIENT_LEFT);
        } else {
            try {
                queuedExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InternalClientMembership.doNotifyClientMembershipListener(member, client, event, EventType.CLIENT_LEFT);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public static void notifyCrashed(final DistributedMember member, final boolean client) {
        ThreadPoolExecutor queuedExecutor = executor;
        if (queuedExecutor == null) {
            return;
        }
        final InternalClientMembershipEvent event = new InternalClientMembershipEvent(member, client);
        if (forceSynchronous) {
            InternalClientMembership.doNotifyClientMembershipListener(member, client, event, EventType.CLIENT_CRASHED);
        } else {
            try {
                queuedExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InternalClientMembership.doNotifyClientMembershipListener(member, client, event, EventType.CLIENT_CRASHED);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static void doNotifyClientMembershipListener(DistributedMember member, boolean client, ClientMembershipEvent clientMembershipEvent, EventType eventType) {
        for (ClientMembershipListener listener : clientMembershipListeners) {
            try {
                if (eventType.equals((Object)EventType.CLIENT_JOINED)) {
                    listener.memberJoined(clientMembershipEvent);
                    continue;
                }
                if (eventType.equals((Object)EventType.CLIENT_LEFT)) {
                    listener.memberLeft(clientMembershipEvent);
                    continue;
                }
                listener.memberCrashed(clientMembershipEvent);
            }
            catch (CancelException e) {
                return;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_UNEXPECTED_EXCEPTION), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addInternalDistributedSystem(InternalDistributedSystem s) {
        List list = systems;
        synchronized (list) {
            s.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                public String toString() {
                    return "Disconnect listener for InternalClientMembership";
                }

                @Override
                public void onDisconnect(InternalDistributedSystem ss) {
                    InternalClientMembership.removeInternalDistributedSystem(ss);
                }
            });
            systems.add(s);
            InternalClientMembership.ensureExecutorIsRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeInternalDistributedSystem(InternalDistributedSystem sys) {
        List list = systems;
        synchronized (list) {
            systems.remove(sys);
            if (systems.isEmpty()) {
                if (executor != null) {
                    executor.shutdown();
                }
                executor = null;
            }
        }
    }

    private static void ensureExecutorIsRunning() {
        if (executor == null) {
            final ThreadGroup group = threadGroup;
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable command) {
                    Thread thread = new Thread(group, command, "ClientMembership Event Invoker");
                    thread.setDaemon(true);
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
            executor = new ThreadPoolExecutor(1, 1, 15L, TimeUnit.SECONDS, q, tf);
        }
    }

    public static void setForceSynchronous(boolean value) {
        forceSynchronous = value;
    }

    static {
        threadGroup = LoggingThreadGroup.createThreadGroup("ClientMembership Event Invoker Group", logger);
        systems = new ArrayList(1);
        isMonitoring = false;
        forceSynchronous = false;
    }

    private static enum EventType {
        CLIENT_JOINED,
        CLIENT_LEFT,
        CLIENT_CRASHED;

    }

    protected static class InternalClientMembershipEvent
    implements ClientMembershipEvent {
        private final DistributedMember member;
        private final boolean client;

        protected InternalClientMembershipEvent(DistributedMember member, boolean client) {
            this.member = member;
            this.client = client;
        }

        @Override
        public DistributedMember getMember() {
            return this.member;
        }

        @Override
        public String getMemberId() {
            return this.member == null ? "unknown" : this.member.getId();
        }

        @Override
        public boolean isClient() {
            return this.client;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[ClientMembershipEvent: ");
            sb.append("member=").append(this.member);
            sb.append(", isClient=").append(this.client);
            sb.append("]");
            return sb.toString();
        }
    }
}

