/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.query.mock;

import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.PreferBytesCachedDeserializable;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.cache.persistence.query.ResultMap;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.CachedDeserializableComparator;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.ItrAdapter;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.NaturalComparator;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.ReverseComparator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class SortedResultMapImpl
implements ResultMap {
    private final ConcurrentSkipListMap<Object, Object> map;

    public SortedResultMapImpl(boolean reverse) {
        Comparator<Object> comparator = new CachedDeserializableComparator(new NaturalComparator());
        if (reverse) {
            comparator = new ReverseComparator(comparator);
        }
        this.map = new ConcurrentSkipListMap(comparator);
    }

    @Override
    public void put(Object key, Object value) {
        this.map.put(this.toDeserializable(key), this.toDeserializable(value));
    }

    @Override
    public void remove(Object key) {
        this.map.remove(key);
    }

    @Override
    public ResultMap.Entry getEntry(Object key) {
        if (this.map.containsKey(key)) {
            return new EntryImpl(this.toDeserializable(key), (CachedDeserializable)this.map.get(key));
        }
        return null;
    }

    @Override
    public CachedDeserializable get(Object key) {
        return (CachedDeserializable)this.map.get(key);
    }

    @Override
    public CloseableIterator<ResultMap.Entry> iterator(Object start, boolean startInclusive, Object end, boolean endInclusive) {
        return new IterImpl(this.map.subMap(start, startInclusive, end, endInclusive).entrySet().iterator());
    }

    @Override
    public CloseableIterator<ResultMap.Entry> iterator(Object start, boolean startInclusive) {
        return new IterImpl(this.map.subMap(start, (Object)startInclusive).entrySet().iterator());
    }

    @Override
    public CloseableIterator<ResultMap.Entry> iterator() {
        return new IterImpl(this.map.entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> keyIterator(Object start, boolean startInclusive, Object end, boolean endInclusive) {
        return new ItrAdapter(this.map.subMap(start, startInclusive, end, endInclusive).keySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> keyIterator(Object start, boolean startInclusive) {
        return new ItrAdapter(this.map.subMap(start, (Object)startInclusive).keySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> keyIterator() {
        return new ItrAdapter(this.map.keySet().iterator());
    }

    public CloseableIterator<CachedDeserializable> valueIterator() {
        return new ItrAdapter(this.map.values().iterator());
    }

    public CloseableIterator<CachedDeserializable> valueIterator(Object start, boolean startInclusive) {
        return new ItrAdapter(this.map.tailMap(start, startInclusive).values().iterator());
    }

    @Override
    public void close() {
    }

    private CachedDeserializable toDeserializable(Object value) {
        if (value instanceof CachedDeserializable) {
            return (CachedDeserializable)value;
        }
        return new PreferBytesCachedDeserializable(value);
    }

    @Override
    public boolean containsKey(Object e) {
        return this.map.containsKey(e);
    }

    private static class IterImpl
    implements CloseableIterator<ResultMap.Entry> {
        private Iterator<Map.Entry<Object, Object>> iterator;

        public IterImpl(Iterator<Map.Entry<Object, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ResultMap.Entry next() {
            Map.Entry<Object, Object> next = this.iterator.next();
            return new EntryImpl((CachedDeserializable)next.getKey(), (CachedDeserializable)next.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    private static class EntryImpl
    implements ResultMap.Entry {
        private CachedDeserializable key;
        private CachedDeserializable value;

        public EntryImpl(CachedDeserializable key, CachedDeserializable value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public CachedDeserializable getKey() {
            return this.key;
        }

        @Override
        public CachedDeserializable getValue() {
            return this.value;
        }
    }
}

