/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.rebalance;

import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class RemoveOverRedundancy
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        return this.removeOverRedundancy();
    }

    private boolean removeOverRedundancy() {
        PartitionedRegionLoadModel.Move bestMove = null;
        PartitionedRegionLoadModel.BucketRollup first = null;
        while (bestMove == null) {
            if (this.model.getOverRedundancyBuckets().isEmpty()) {
                return false;
            }
            first = this.model.getOverRedundancyBuckets().first();
            bestMove = this.model.findBestRemove(first);
            if (bestMove != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping overredundancy bucket {} because couldn't find a member to remove from?", new Object[]{first});
            }
            this.model.ignoreOverRedundancyBucket(first);
        }
        PartitionedRegionLoadModel.Member targetMember = bestMove.getTarget();
        this.model.remoteOverRedundancyBucket(first, targetMember);
        return true;
    }
}

