/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.rebalance;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Set;

public class ExplicitMoveDirector
extends RebalanceDirectorAdapter {
    private PartitionedRegionLoadModel model;
    private final int bucketId;
    private final InternalDistributedMember source;
    private final InternalDistributedMember target;
    private final Object key;
    private InternalDistributedSystem ds;

    public ExplicitMoveDirector(Object key, int bucketId, DistributedMember source, DistributedMember target, DistributedSystem distributedSystem) {
        this.key = key;
        this.bucketId = bucketId;
        this.source = (InternalDistributedMember)source;
        this.target = (InternalDistributedMember)target;
        this.ds = (InternalDistributedSystem)distributedSystem;
    }

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        PartitionedRegionLoadModel.BucketRollup bucket = this.model.getBuckets()[this.bucketId];
        PartitionedRegionLoadModel.MemberRollup sourceMember = this.model.getMember(this.source);
        PartitionedRegionLoadModel.MemberRollup targetMember = this.model.getMember(this.target);
        if (sourceMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_SOURCE_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.source));
        }
        if (targetMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_TARGET_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.target));
        }
        if (bucket == null) {
            throw new IllegalStateException("The bucket for key " + this.key + ", bucket " + this.bucketId + ", region " + this.model.getName() + " does not exist");
        }
        if (!bucket.getMembersHosting().contains(sourceMember)) {
            throw new IllegalStateException("The bucket for key " + this.key + ", bucket " + this.bucketId + ", region " + this.model.getName() + " is not hosted by " + this.source + ". Members hosting: " + bucket.getMembersHosting());
        }
        PartitionedRegionLoadModel.RefusalReason reason = ((PartitionedRegionLoadModel.Member)targetMember).willAcceptBucket(bucket, sourceMember, this.model.enforceUniqueZones());
        if (reason.willAccept()) {
            if (!this.model.moveBucket(new PartitionedRegionLoadModel.Move(sourceMember, targetMember, bucket))) {
                Set allMembers = this.ds.getDistributionManager().getDistributionManagerIdsIncludingAdmin();
                if (!allMembers.contains(sourceMember)) {
                    throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_SOURCE_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.source));
                }
                if (!allMembers.contains(targetMember)) {
                    throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_TARGET_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.target));
                }
                throw new IllegalStateException("Unable to move bucket " + bucket + " from " + sourceMember + " to " + targetMember);
            }
        } else {
            throw new IllegalStateException("Unable to move bucket for " + this.model.getName() + ". " + reason.formatMessage(sourceMember, targetMember, bucket));
        }
        return false;
    }
}

