/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.rebalance;

import com.gemstone.gemfire.internal.cache.partitioned.rebalance.MoveBuckets;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.MovePrimaries;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RemoveOverRedundancy;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.SatisfyRedundancy;

public class CompositeDirector
extends RebalanceDirectorAdapter {
    private boolean initialRemoveOverRedundancy;
    private boolean initialSatisfyRedundancy;
    private boolean initialMoveBuckets;
    private boolean initialMovePrimaries;
    private boolean removeOverRedundancy;
    private boolean satisfyRedundancy;
    private boolean moveBuckets;
    private boolean movePrimaries;
    private final RemoveOverRedundancy removeOverRedundancyDirector = new RemoveOverRedundancy();
    private final SatisfyRedundancy satisfyRedundancyDirector = new SatisfyRedundancy();
    private final MovePrimaries movePrimariesDirector = new MovePrimaries();
    private final MoveBuckets moveBucketsDirector = new MoveBuckets();
    private PartitionedRegionLoadModel model;

    public CompositeDirector(boolean removeOverRedundancy, boolean satisfyRedundancy, boolean moveBuckets, boolean movePrimaries) {
        this.initialRemoveOverRedundancy = removeOverRedundancy;
        this.initialSatisfyRedundancy = satisfyRedundancy;
        this.initialMoveBuckets = moveBuckets;
        this.initialMovePrimaries = movePrimaries;
    }

    @Override
    public boolean isRebalanceNecessary(boolean redundancyImpaired, boolean withPersistence) {
        return redundancyImpaired || this.initialMovePrimaries && withPersistence;
    }

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
        this.removeOverRedundancy = this.initialRemoveOverRedundancy;
        this.satisfyRedundancy = this.initialSatisfyRedundancy;
        this.moveBuckets = this.initialMoveBuckets;
        this.movePrimaries = this.initialMovePrimaries;
        this.removeOverRedundancyDirector.initialize(model);
        this.satisfyRedundancyDirector.initialize(model);
        this.moveBucketsDirector.initialize(model);
        this.movePrimariesDirector.initialize(model);
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        boolean attemptedOperation = false;
        if (this.removeOverRedundancy) {
            attemptedOperation = this.removeOverRedundancyDirector.nextStep();
        }
        if (!attemptedOperation) {
            this.removeOverRedundancy = false;
        }
        if (!attemptedOperation && this.satisfyRedundancy) {
            attemptedOperation = this.satisfyRedundancyDirector.nextStep();
        }
        if (!attemptedOperation) {
            this.satisfyRedundancy = false;
        }
        if (!attemptedOperation && this.moveBuckets) {
            attemptedOperation = this.moveBucketsDirector.nextStep();
        }
        if (!attemptedOperation) {
            this.moveBuckets = false;
        }
        if (!attemptedOperation && this.movePrimaries) {
            attemptedOperation = this.movePrimariesDirector.nextStep();
        }
        if (!attemptedOperation) {
            this.movePrimaries = false;
        }
        return attemptedOperation;
    }
}

