/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class SizeMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private ArrayList<Integer> bucketIds;
    public static final short ESTIMATE = 64;
    private transient boolean estimate;

    public SizeMessage() {
    }

    private SizeMessage(Set recipients, int regionId, ReplyProcessor21 processor, ArrayList<Integer> bucketIds, boolean estimate) {
        super(recipients, regionId, processor);
        this.bucketIds = bucketIds != null && bucketIds.isEmpty() ? null : bucketIds;
        this.estimate = estimate;
    }

    public static SizeResponse send(Set recipients, PartitionedRegion r, ArrayList<Integer> bucketIds, boolean estimate) {
        Assert.assertTrue(recipients != null, "SizeMessage NULL recipients set");
        SizeResponse p = new SizeResponse(r.getSystem(), recipients);
        SizeMessage m = new SizeMessage(recipients, r.getPRId(), p, bucketIds, estimate);
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    protected final boolean failIfRegionMissing() {
        return false;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws ClassNotFoundException, IOException {
        super.setBooleans(s, in);
        this.estimate = (s & 0x40) != 0;
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.estimate) {
            s = (short)(s | 0x40);
        }
        return s;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        if (r != null) {
            PartitionedRegionDataStore ds = r.getDataStore();
            if (ds != null) {
                Map<Integer, PartitionedRegion.SizeEntry> sizes = this.bucketIds != null ? (this.estimate ? ds.getSizeEstimateLocallyForBuckets(this.bucketIds) : ds.getSizeLocallyForBuckets(this.bucketIds)) : (this.estimate ? ds.getSizeEstimateForLocalPrimaryBuckets() : ds.getSizeForLocalBuckets());
                r.getPrStats().endPartitionMessagesProcessing(startTime);
                SizeReplyMessage.send(this.getSender(), this.getProcessorId(), dm, sizes);
            } else {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.SizeMessage_SIZEMESSAGE_DATA_STORE_NOT_CONFIGURED_FOR_THIS_MEMBER));
                ReplyMessage.send(this.getSender(), this.getProcessorId(), new ReplyException(new ForceReattemptException(LocalizedStrings.SizeMessage_0_1_NO_DATASTORE_HERE_2.toLocalizedString())), dm, r.isInternalRegion());
            }
        } else {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.SizeMessage_SIZEMESSAGE_REGION_NOT_FOUND_FOR_THIS_MEMBER, this.regionId));
            ReplyMessage.send(this.getSender(), this.getProcessorId(), new ReplyException(new ForceReattemptException(LocalizedStrings.SizeMessage_0_COULD_NOT_FIND_PARTITIONED_REGION_WITH_ID_1.toLocalizedString(dm.getDistributionManagerId(), this.regionId))), dm, r != null && r.isInternalRegion());
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketIds=").append(this.bucketIds);
    }

    @Override
    public int getDSFID() {
        return 61;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketIds = DataSerializer.readArrayList(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList(this.bucketIds, out);
    }

    public static class SizeResponse
    extends ReplyProcessor21 {
        private final HashMap<Integer, PartitionedRegion.SizeEntry> returnValue = new HashMap();

        public SizeResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("SizeResponse ignoring exception: {}", new Object[]{ex.getMessage(), ex});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            block7: {
                try {
                    if (!(msg instanceof SizeReplyMessage)) break block7;
                    SizeReplyMessage reply = (SizeReplyMessage)msg;
                    HashMap<Integer, PartitionedRegion.SizeEntry> hashMap = this.returnValue;
                    synchronized (hashMap) {
                        for (Map.Entry<Integer, PartitionedRegion.SizeEntry> me : reply.getBucketSizes().entrySet()) {
                            Integer k = me.getKey();
                            if (this.returnValue.containsKey(k) && this.returnValue.get(k).isPrimary()) continue;
                            this.returnValue.put(k, me.getValue());
                        }
                    }
                }
                finally {
                    super.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<Integer, PartitionedRegion.SizeEntry> waitBucketSizes() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                logger.debug("{} waitBucketSizes ignoring exception: {}", new Object[]{this.getClass().getName(), e.getMessage(), e});
            }
            HashMap<Integer, PartitionedRegion.SizeEntry> hashMap = this.returnValue;
            synchronized (hashMap) {
                return this.returnValue;
            }
        }
    }

    public static final class SizeReplyMessage
    extends ReplyMessage {
        private Map<Integer, PartitionedRegion.SizeEntry> bucketSizes;

        public SizeReplyMessage() {
        }

        private SizeReplyMessage(int processorId, Map<Integer, PartitionedRegion.SizeEntry> bucketSizes) {
            this.processorId = processorId;
            this.bucketSizes = bucketSizes;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, Map<Integer, PartitionedRegion.SizeEntry> sizes) {
            Assert.assertTrue(recipient != null, "SizeReplyMessage NULL reply message");
            SizeReplyMessage m = new SizeReplyMessage(processorId, sizes);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} process invoking reply processor with processorId: {}", new Object[]{this.getClass().getName(), this.processorId});
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "{} processor not found", new Object[]{this.getClass().getName()});
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", new Object[]{processor, this});
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.bucketSizes, out);
        }

        @Override
        public int getDSFID() {
            return 62;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.bucketSizes = (Map)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName()).append(" processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning bucketSizes.size=").append(this.getBucketSizes().size());
            return sb.toString();
        }

        public Map<Integer, PartitionedRegion.SizeEntry> getBucketSizes() {
            return this.bucketSizes;
        }
    }
}

