/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.PartitionRebalanceDetailsImpl;
import com.gemstone.gemfire.internal.cache.control.ResourceManagerStats;
import com.gemstone.gemfire.internal.cache.partitioned.BecomePrimaryBucketMessage;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPRInfo;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPartitionDetails;
import com.gemstone.gemfire.internal.cache.partitioned.LoadProbe;
import com.gemstone.gemfire.internal.cache.partitioned.MoveBucketMessage;
import com.gemstone.gemfire.internal.cache.partitioned.OfflineMemberDetails;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveBucketMessage;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.BucketOperator;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.ParallelBucketOperator;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RebalanceDirector;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.SimulatedBucketOperator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PartitionedRegionRebalanceOp {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_PARALLEL_OPERATIONS = Integer.getInteger("gemfire.MAX_PARALLEL_BUCKET_RECOVERIES", 8);
    private final boolean DEBUG = Boolean.getBoolean("gemfire.LOG_REBALANCE");
    private final boolean simulate;
    private final boolean replaceOfflineData;
    private final PartitionedRegion leaderRegion;
    private final PartitionedRegion targetRegion;
    private Collection<PartitionedRegion> colocatedRegions;
    private final AtomicBoolean cancelled;
    private final ResourceManagerStats stats;
    private final boolean isRebalance;
    private volatile boolean membershipChange = false;
    private final RebalanceDirector director;

    public PartitionedRegionRebalanceOp(PartitionedRegion region, boolean simulate, RebalanceDirector director, boolean replaceOfflineData, boolean isRebalance) {
        this(region, simulate, director, replaceOfflineData, isRebalance, new AtomicBoolean(), null);
    }

    public PartitionedRegionRebalanceOp(PartitionedRegion region, boolean simulate, RebalanceDirector director, boolean replaceOfflineData, boolean isRebalance, AtomicBoolean cancelled, ResourceManagerStats stats) {
        PartitionedRegion leader = ColocationHelper.getLeaderRegion(region);
        Assert.assertTrue(leader != null);
        this.leaderRegion = leader;
        this.targetRegion = region;
        this.simulate = simulate;
        this.director = director;
        this.cancelled = cancelled;
        this.replaceOfflineData = replaceOfflineData;
        this.isRebalance = isRebalance;
        this.stats = simulate ? null : stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartitionRebalanceInfo> execute() {
        long start = System.nanoTime();
        InternalResourceManager resourceManager = InternalResourceManager.getInternalResourceManager(this.leaderRegion.getCache());
        MembershipChangeListener listener = new MembershipChangeListener();
        if (this.isRebalance) {
            InternalResourceManager.getResourceObserver().rebalancingStarted(this.targetRegion);
        } else {
            InternalResourceManager.getResourceObserver().recoveryStarted(this.targetRegion);
        }
        PartitionedRegion.RecoveryLock lock = null;
        try {
            if (!this.checkAndSetColocatedRegions()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            if (!this.isRebalanceNecessary()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            if (!this.simulate) {
                lock = this.leaderRegion.getRecoveryLock();
                lock.lock();
            }
            if (!this.isRebalanceNecessary()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            this.leaderRegion.getRegionAdvisor().addMembershipListener(listener);
            PartitionedRegionLoadModel model = null;
            GemFireCacheImpl cache = this.leaderRegion.getCache();
            Map<PartitionedRegion, InternalPRInfo> detailsMap = this.fetchDetails(cache);
            BucketOperatorWrapper serialOperator = this.getBucketOperator(detailsMap);
            ParallelBucketOperator parallelOperator = new ParallelBucketOperator(MAX_PARALLEL_OPERATIONS, cache.getDistributionManager().getWaitingThreadPool(), serialOperator);
            model = this.buildModel(parallelOperator, detailsMap, resourceManager);
            for (PartitionRebalanceDetailsImpl details : serialOperator.getDetailSet()) {
                details.setPartitionMemberDetailsBefore(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            this.director.initialize(model);
            do {
                if (this.cancelled.get()) {
                    Set set = Collections.emptySet();
                    return set;
                }
                if (this.membershipChange) {
                    this.membershipChange = false;
                    this.debug("Rebalancing {} detected membership changes. Refetching details", this.leaderRegion);
                    if (this.stats != null) {
                        this.stats.incRebalanceMembershipChanges(1);
                    }
                    model.waitForOperations();
                    detailsMap = this.fetchDetails(cache);
                    model = this.buildModel(parallelOperator, detailsMap, resourceManager);
                    this.director.membershipChanged(model);
                }
                this.leaderRegion.checkClosed();
                cache.getCancelCriterion().checkCancelInProgress(null);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Rebalancing {} Model:{}\n", new Object[]{this.leaderRegion, model});
            } while (this.director.nextStep());
            this.debug("Rebalancing {} complete. Model:{}\n", this.leaderRegion, model);
            long end = System.nanoTime();
            for (PartitionRebalanceDetailsImpl details : serialOperator.getDetailSet()) {
                if (!this.simulate) {
                    details.setTime(end - start);
                }
                details.setPartitionMemberDetailsAfter(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            Set<PartitionRebalanceDetailsImpl> set = Collections.unmodifiableSet(serialOperator.getDetailSet());
            return set;
        }
        finally {
            if (lock != null) {
                try {
                    lock.unlock();
                }
                catch (CancelException cancelException) {
                }
                catch (Exception e) {
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_UNABLE_TO_RELEASE_RECOVERY_LOCK), (Throwable)e);
                }
            }
            try {
                if (this.isRebalance) {
                    InternalResourceManager.getResourceObserver().rebalancingFinished(this.targetRegion);
                } else {
                    InternalResourceManager.getResourceObserver().recoveryFinished(this.targetRegion);
                }
            }
            catch (Exception e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_ERROR_IN_RESOURCE_OBSERVER), (Throwable)e);
            }
            try {
                this.leaderRegion.getRegionAdvisor().removeMembershipListener(listener);
            }
            catch (Exception e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_ERROR_IN_RESOURCE_OBSERVER), (Throwable)e);
            }
        }
    }

    protected boolean checkAndSetColocatedRegions() {
        if (!ColocationHelper.checkMembersColocation(this.leaderRegion, this.leaderRegion.getDistributionManager().getDistributionManagerId())) {
            return false;
        }
        Map<String, PartitionedRegion> colocatedRegionsMap = ColocationHelper.getAllColocationRegions(this.targetRegion);
        colocatedRegionsMap.put(this.targetRegion.getFullPath(), this.targetRegion);
        LinkedList<PartitionedRegion> colocatedRegions = new LinkedList<PartitionedRegion>();
        for (PartitionedRegion colocatedRegion : colocatedRegionsMap.values()) {
            if (!colocatedRegion.isInitialized()) {
                return false;
            }
            if (colocatedRegion.getColocatedWith() == null) {
                colocatedRegions.addFirst(colocatedRegion);
                continue;
            }
            colocatedRegions.addLast(colocatedRegion);
        }
        this.colocatedRegions = colocatedRegions;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartitionRebalanceInfo> executeFPA() {
        if (logger.isDebugEnabled()) {
            logger.debug("Rebalancing buckets for fixed partitioned region {}", new Object[]{this.targetRegion});
        }
        long start = System.nanoTime();
        GemFireCacheImpl cache = this.leaderRegion.getCache();
        InternalResourceManager resourceManager = InternalResourceManager.getInternalResourceManager(cache);
        InternalResourceManager.getResourceObserver().recoveryStarted(this.targetRegion);
        try {
            if (!this.checkAndSetColocatedRegions()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            PartitionedRegionLoadModel model = null;
            Map<PartitionedRegion, InternalPRInfo> detailsMap = this.fetchDetails(cache);
            BucketOperatorWrapper operator = this.getBucketOperator(detailsMap);
            model = this.buildModel(operator, detailsMap, resourceManager);
            for (PartitionRebalanceDetailsImpl details : operator.getDetailSet()) {
                details.setPartitionMemberDetailsBefore(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing FPR {} Model:{}\n", new Object[]{this.leaderRegion, model});
            }
            this.director.initialize(model);
            this.director.nextStep();
            if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing FPR {} complete. Model:{}\n", new Object[]{this.leaderRegion, model});
            }
            long end = System.nanoTime();
            for (PartitionRebalanceDetailsImpl details : operator.getDetailSet()) {
                if (!this.simulate) {
                    details.setTime(end - start);
                }
                details.setPartitionMemberDetailsAfter(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            Set<PartitionRebalanceDetailsImpl> set = Collections.unmodifiableSet(operator.getDetailSet());
            return set;
        }
        finally {
            try {
                InternalResourceManager.getResourceObserver().recoveryFinished(this.targetRegion);
            }
            catch (Exception e) {
                logger.debug((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_ERROR_IN_RESOURCE_OBSERVER), (Throwable)e);
            }
        }
    }

    private Map<PartitionedRegion, InternalPRInfo> fetchDetails(GemFireCacheImpl cache) {
        LoadProbe probe = cache.getResourceManager().getLoadProbe();
        LinkedHashMap<PartitionedRegion, InternalPRInfo> detailsMap = new LinkedHashMap<PartitionedRegion, InternalPRInfo>(this.colocatedRegions.size());
        for (PartitionedRegion colocatedRegion : this.colocatedRegions) {
            if (!ColocationHelper.isColocationComplete(colocatedRegion)) continue;
            InternalPRInfo info = colocatedRegion.getRedundancyProvider().buildPartitionedRegionInfo(true, probe);
            detailsMap.put(colocatedRegion, info);
        }
        return detailsMap;
    }

    private BucketOperatorWrapper getBucketOperator(Map<PartitionedRegion, InternalPRInfo> detailsMap) {
        HashSet<PartitionRebalanceDetailsImpl> rebalanceDetails = new HashSet<PartitionRebalanceDetailsImpl>(detailsMap.size());
        for (Map.Entry<PartitionedRegion, InternalPRInfo> entry : detailsMap.entrySet()) {
            rebalanceDetails.add(new PartitionRebalanceDetailsImpl(entry.getKey()));
        }
        BucketOperator operator = this.simulate ? new SimulatedBucketOperator() : new BucketOperatorImpl();
        BucketOperatorWrapper wrapper = new BucketOperatorWrapper(operator, rebalanceDetails);
        return wrapper;
    }

    private PartitionedRegionLoadModel buildModel(BucketOperator operator, Map<PartitionedRegion, InternalPRInfo> detailsMap, InternalResourceManager resourceManager) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        final DM dm = this.leaderRegion.getDistributionManager();
        PartitionedRegionLoadModel.AddressComparor comparor = new PartitionedRegionLoadModel.AddressComparor(){

            @Override
            public boolean areSameZone(InternalDistributedMember member1, InternalDistributedMember member2) {
                return dm.areInSameZone(member1, member2);
            }

            @Override
            public boolean enforceUniqueZones() {
                return dm.enforceUniqueZone();
            }
        };
        int redundantCopies = this.leaderRegion.getRedundantCopies();
        int totalNumberOfBuckets = this.leaderRegion.getTotalNumberOfBuckets();
        Set<InternalDistributedMember> criticalMembers = resourceManager.getResourceAdvisor().adviseCritialMembers();
        boolean removeOverRedundancy = true;
        this.debug("Building Model for rebalancing " + this.leaderRegion + ". redundantCopies=" + redundantCopies + ", totalNumBuckets=" + totalNumberOfBuckets + ", criticalMembers=" + criticalMembers + ", simulate=" + this.simulate, new Object[0]);
        PartitionedRegionLoadModel model = new PartitionedRegionLoadModel(operator, redundantCopies, totalNumberOfBuckets, comparor, criticalMembers, this.leaderRegion);
        for (Map.Entry<PartitionedRegion, InternalPRInfo> entry : detailsMap.entrySet()) {
            PartitionedRegion region = entry.getKey();
            InternalPRInfo details = entry.getValue();
            OfflineMemberDetails offlineDetails = this.replaceOfflineData ? OfflineMemberDetails.EMPTY_DETAILS : details.getOfflineMembers();
            boolean enforceLocalMaxMemory = !region.isEntryEvictionPossible();
            this.debug("Added Region to model region=" + region + ", offlineDetails=" + offlineDetails + ", enforceLocalMaxMemory=" + enforceLocalMaxMemory, new Object[0]);
            for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                this.debug("For Region: " + region + ", Member: " + memberDetails.getDistributedMember() + "LOAD=" + ((InternalPartitionDetails)memberDetails).getPRLoad() + ", equivalentMembers=" + dm.getMembersInSameZone((InternalDistributedMember)memberDetails.getDistributedMember()), new Object[0]);
            }
            Set<InternalPartitionDetails> memberDetailSet = details.getInternalPartitionDetails();
            model.addRegion(region.getFullPath(), memberDetailSet, offlineDetails, enforceLocalMaxMemory);
        }
        model.initialize();
        this.debug("Rebalancing {} starting. Model:\n{}", this.leaderRegion, model);
        return model;
    }

    private void debug(String message, Object ... params) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, params);
        } else if (logger.isInfoEnabled() && this.DEBUG) {
            logger.info(message, params);
        }
    }

    public static boolean createRedundantBucketForRegion(InternalDistributedMember target, int bucketId, PartitionedRegion pr, boolean forRebalance, boolean replaceOfflineData) {
        return pr.getRedundancyProvider().createBackupBucketOnMember(bucketId, target, forRebalance, replaceOfflineData, null, true);
    }

    public static boolean removeRedundantBucketForRegion(InternalDistributedMember target, int bucketId, PartitionedRegion pr) {
        boolean removed = false;
        if (pr.getDistributionManager().getId().equals(target)) {
            removed = pr.getDataStore().removeBucket(bucketId, false);
        } else {
            RemoveBucketMessage.RemoveBucketResponse response = RemoveBucketMessage.send(target, pr, bucketId, false);
            if (response != null) {
                removed = response.waitForResponse();
            }
        }
        return removed;
    }

    public static boolean movePrimaryBucketForRegion(InternalDistributedMember target, int bucketId, PartitionedRegion pr, boolean forRebalance) {
        boolean movedPrimary = false;
        if (pr.getDistributionManager().getId().equals(target)) {
            BucketAdvisor bucketAdvisor = pr.getRegionAdvisor().getBucketAdvisor(bucketId);
            if (bucketAdvisor.isHosting()) {
                movedPrimary = bucketAdvisor.becomePrimary(forRebalance);
            }
        } else {
            BecomePrimaryBucketMessage.BecomePrimaryBucketResponse response = BecomePrimaryBucketMessage.send(target, pr, bucketId, forRebalance);
            if (response != null) {
                movedPrimary = response.waitForResponse();
            }
        }
        return movedPrimary;
    }

    public static boolean moveBucketForRegion(InternalDistributedMember source, InternalDistributedMember target, int bucketId, PartitionedRegion pr) {
        boolean movedBucket = false;
        if (pr.getDistributionManager().getId().equals(target)) {
            movedBucket = pr.getDataStore().moveBucket(bucketId, source, false);
        } else {
            MoveBucketMessage.MoveBucketResponse response = MoveBucketMessage.send(target, pr, bucketId, source);
            if (response != null) {
                movedBucket = response.waitForResponse();
            }
        }
        return movedBucket;
    }

    private boolean isRebalanceNecessary() {
        return this.isRebalance || this.director.isRebalanceNecessary(this.leaderRegion.getRedundancyProvider().isRedundancyImpaired(), this.leaderRegion.getDataPolicy().withPersistence());
    }

    private class BucketOperatorWrapper
    implements BucketOperator {
        private final BucketOperator delegate;
        private final Set<PartitionRebalanceDetailsImpl> detailSet;
        private final int regionCount;

        public BucketOperatorWrapper(BucketOperator delegate, Set<PartitionRebalanceDetailsImpl> rebalanceDetails) {
            this.delegate = delegate;
            this.detailSet = rebalanceDetails;
            this.regionCount = this.detailSet.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveBucket(InternalDistributedMember sourceMember, InternalDistributedMember targetMember, int id, Map<String, Long> colocatedRegionBytes) {
            long start = System.nanoTime();
            boolean result = false;
            long elapsed = 0L;
            long totalBytes = 0L;
            if (PartitionedRegionRebalanceOp.this.stats != null) {
                PartitionedRegionRebalanceOp.this.stats.startBucketTransfer(this.regionCount);
            }
            try {
                result = this.delegate.moveBucket(sourceMember, targetMember, id, colocatedRegionBytes);
                elapsed = System.nanoTime() - start;
                if (result) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rebalancing {} bucket {} moved from {} to {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, id, sourceMember, targetMember});
                    }
                    for (PartitionRebalanceDetailsImpl details : this.detailSet) {
                        String regionPath = details.getRegionPath();
                        Long regionBytes = colocatedRegionBytes.get(regionPath);
                        if (regionBytes == null) continue;
                        details.incTransfers(regionBytes, details.getRegion().equals(PartitionedRegionRebalanceOp.this.leaderRegion) ? elapsed : 0L);
                        totalBytes += regionBytes.longValue();
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} bucket {} moved failed from {} to {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, id, sourceMember, targetMember});
                }
            }
            finally {
                if (PartitionedRegionRebalanceOp.this.stats != null) {
                    PartitionedRegionRebalanceOp.this.stats.endBucketTransfer(this.regionCount, result, totalBytes, elapsed);
                }
            }
            return result;
        }

        @Override
        public void createRedundantBucket(final InternalDistributedMember targetMember, final int i, final Map<String, Long> colocatedRegionBytes, BucketOperator.Completion completion) {
            if (PartitionedRegionRebalanceOp.this.stats != null) {
                PartitionedRegionRebalanceOp.this.stats.startBucketCreate(this.regionCount);
            }
            final long start = System.nanoTime();
            this.delegate.createRedundantBucket(targetMember, i, colocatedRegionBytes, new BucketOperator.Completion(){

                @Override
                public void onSuccess() {
                    long totalBytes = 0L;
                    long elapsed = System.nanoTime() - start;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rebalancing {} redundant bucket {} created on {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, i, targetMember});
                    }
                    for (PartitionRebalanceDetailsImpl details : BucketOperatorWrapper.this.detailSet) {
                        String regionPath = details.getRegionPath();
                        Long lrb = (Long)colocatedRegionBytes.get(regionPath);
                        if (lrb == null) continue;
                        long regionBytes = lrb;
                        details.incCreates(regionBytes, details.getRegion().equals(PartitionedRegionRebalanceOp.this.leaderRegion) ? elapsed : 0L);
                        totalBytes += regionBytes;
                    }
                    if (PartitionedRegionRebalanceOp.this.stats != null) {
                        PartitionedRegionRebalanceOp.this.stats.endBucketCreate(BucketOperatorWrapper.this.regionCount, true, totalBytes, elapsed);
                    }
                }

                @Override
                public void onFailure() {
                    long elapsed = System.nanoTime() - start;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rebalancing {} redundant bucket {} failed creation on {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, i, targetMember});
                    }
                    if (PartitionedRegionRebalanceOp.this.stats != null) {
                        PartitionedRegionRebalanceOp.this.stats.endBucketCreate(BucketOperatorWrapper.this.regionCount, false, 0L, elapsed);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeBucket(InternalDistributedMember targetMember, int i, Map<String, Long> colocatedRegionBytes) {
            boolean result = false;
            long elapsed = 0L;
            long totalBytes = 0L;
            if (PartitionedRegionRebalanceOp.this.stats != null) {
                PartitionedRegionRebalanceOp.this.stats.startBucketRemove(this.regionCount);
            }
            try {
                long start = System.nanoTime();
                result = this.delegate.removeBucket(targetMember, i, colocatedRegionBytes);
                elapsed = System.nanoTime() - start;
                if (result) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rebalancing {} redundant bucket {} removed from {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, i, targetMember});
                    }
                    for (PartitionRebalanceDetailsImpl details : this.detailSet) {
                        String regionPath = details.getRegionPath();
                        Long lrb = colocatedRegionBytes.get(regionPath);
                        if (lrb == null) continue;
                        long regionBytes = lrb;
                        details.incRemoves(regionBytes, details.getRegion().equals(PartitionedRegionRebalanceOp.this.leaderRegion) ? elapsed : 0L);
                        totalBytes += regionBytes;
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} redundant bucket {} failed removal o{}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, i, targetMember});
                }
            }
            finally {
                if (PartitionedRegionRebalanceOp.this.stats != null) {
                    PartitionedRegionRebalanceOp.this.stats.endBucketRemove(this.regionCount, result, totalBytes, elapsed);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean movePrimary(InternalDistributedMember source, InternalDistributedMember target, int bucketId) {
            boolean result = false;
            long elapsed = 0L;
            if (PartitionedRegionRebalanceOp.this.stats != null) {
                PartitionedRegionRebalanceOp.this.stats.startPrimaryTransfer(this.regionCount);
            }
            try {
                long start = System.nanoTime();
                result = this.delegate.movePrimary(source, target, bucketId);
                elapsed = System.nanoTime() - start;
                if (result) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rebalancing {} primary bucket {} moved from {} to {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, bucketId, source, target});
                    }
                    for (PartitionRebalanceDetailsImpl details : this.detailSet) {
                        details.incPrimaryTransfers(details.getRegion().equals(PartitionedRegionRebalanceOp.this.leaderRegion) ? elapsed : 0L);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} primary bucket {} failed to move from {} to {}", new Object[]{PartitionedRegionRebalanceOp.this.leaderRegion, bucketId, source, target});
                }
            }
            finally {
                if (PartitionedRegionRebalanceOp.this.stats != null) {
                    PartitionedRegionRebalanceOp.this.stats.endPrimaryTransfer(this.regionCount, result, elapsed);
                }
            }
            return result;
        }

        @Override
        public void waitForOperations() {
            this.delegate.waitForOperations();
        }

        public Set<PartitionRebalanceDetailsImpl> getDetailSet() {
            return this.detailSet;
        }
    }

    private class BucketOperatorImpl
    implements BucketOperator {
        private BucketOperatorImpl() {
        }

        @Override
        public boolean moveBucket(InternalDistributedMember source, InternalDistributedMember target, int bucketId, Map<String, Long> colocatedRegionBytes) {
            InternalResourceManager.getResourceObserver().movingBucket(PartitionedRegionRebalanceOp.this.leaderRegion, bucketId, source, target);
            return PartitionedRegionRebalanceOp.moveBucketForRegion(source, target, bucketId, PartitionedRegionRebalanceOp.this.leaderRegion);
        }

        @Override
        public boolean movePrimary(InternalDistributedMember source, InternalDistributedMember target, int bucketId) {
            InternalResourceManager.getResourceObserver().movingPrimary(PartitionedRegionRebalanceOp.this.leaderRegion, bucketId, source, target);
            return PartitionedRegionRebalanceOp.movePrimaryBucketForRegion(target, bucketId, PartitionedRegionRebalanceOp.this.leaderRegion, PartitionedRegionRebalanceOp.this.isRebalance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createRedundantBucket(InternalDistributedMember targetMember, int bucketId, Map<String, Long> colocatedRegionBytes, BucketOperator.Completion completion) {
            boolean result = false;
            try {
                result = PartitionedRegionRebalanceOp.createRedundantBucketForRegion(targetMember, bucketId, PartitionedRegionRebalanceOp.this.leaderRegion, PartitionedRegionRebalanceOp.this.isRebalance, PartitionedRegionRebalanceOp.this.replaceOfflineData);
            }
            finally {
                if (result) {
                    completion.onSuccess();
                } else {
                    completion.onFailure();
                }
            }
        }

        @Override
        public void waitForOperations() {
        }

        @Override
        public boolean removeBucket(InternalDistributedMember targetMember, int bucketId, Map<String, Long> colocatedRegionBytes) {
            return PartitionedRegionRebalanceOp.removeRedundantBucketForRegion(targetMember, bucketId, PartitionedRegionRebalanceOp.this.leaderRegion);
        }
    }

    private class MembershipChangeListener
    implements MembershipListener {
        private MembershipChangeListener() {
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionRebalanceOP - membership changed, restarting rebalancing for region {}", new Object[]{PartitionedRegionRebalanceOp.this.targetRegion});
            }
            PartitionedRegionRebalanceOp.this.membershipChange = true;
        }

        @Override
        public void memberJoined(InternalDistributedMember id) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionRebalanceOP - membership changed, restarting rebalancing for region {}", new Object[]{PartitionedRegionRebalanceOp.this.targetRegion});
            }
            PartitionedRegionRebalanceOp.this.membershipChange = true;
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }
}

