/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class PRUpdateEntryVersionMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Operation op;
    private EventID eventId;
    protected VersionTag versionTag;

    public PRUpdateEntryVersionMessage() {
    }

    public PRUpdateEntryVersionMessage(Collection<InternalDistributedMember> recipients, int regionId, DirectReplyProcessor processor) {
        super(recipients, regionId, processor);
    }

    public PRUpdateEntryVersionMessage(Set recipients, int regionId, DirectReplyProcessor processor, EntryEventImpl event) {
        super(recipients, regionId, processor, event);
        this.key = event.getKey();
        this.op = event.getOperation();
        this.eventId = event.getEventId();
        this.versionTag = event.getVersionTag();
    }

    @Override
    public int getDSFID() {
        return 159;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, DataLocationException, InterruptedException, IOException {
        if (pr.keyRequiresRegionContext()) {
            ((KeyWithRegionContext)this.key).setRegionContext(pr);
        }
        EntryEventImpl event = EntryEventImpl.create((LocalRegion)pr, this.getOperation(), this.getKey(), null, null, false, (DistributedMember)this.getSender(), false, false);
        event.disallowOffHeapValues();
        Assert.assertTrue(this.eventId != null);
        if (this.versionTag != null) {
            event.setVersionTag(this.versionTag);
        }
        event.setEventId(this.eventId);
        event.setPossibleDuplicate(this.posDup);
        event.setInvokePRCallbacks(false);
        event.setCausedByMessage(this);
        boolean sendReply = true;
        if (!this.notificationOnly) {
            PartitionedRegionDataStore ds = pr.getDataStore();
            Assert.assertTrue(ds != null, "This process should have storage for an item in " + this.toString());
            try {
                Integer bucket = PartitionedRegionHelper.getHashKey(event);
                pr.getDataView().updateEntryVersion(event);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("{}: updateEntryVersionLocally in bucket: {}, key: {}", new Object[]{this.getClass().getName(), bucket, this.key});
                }
            }
            catch (EntryNotFoundException eee) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: operateOnRegion caught EntryNotFoundException", new Object[]{this.getClass().getName()});
                }
                this.sendReply(this.getSender(), this.getProcessorId(), dm, null, pr, startTime);
                sendReply = false;
            }
            catch (PrimaryBucketException pbe) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), pr, startTime);
                return false;
            }
        }
        return sendReply;
    }

    private Operation getOperation() {
        return this.op;
    }

    private Object getKey() {
        return this.key;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.getKey(), out);
        out.writeByte(this.op.ordinal);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey());
        buff.append("; op=").append(this.op);
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        if (this.versionTag != null) {
            buff.append("; version=").append(this.versionTag);
        }
    }

    public static UpdateEntryVersionResponse send(InternalDistributedMember recipient, PartitionedRegion r, EntryEventImpl event) throws ForceReattemptException {
        Set<InternalDistributedMember> recipients = Collections.singleton(recipient);
        UpdateEntryVersionResponse p = new UpdateEntryVersionResponse(r.getSystem(), recipient, event.getKey());
        PRUpdateEntryVersionMessage m = new PRUpdateEntryVersionMessage(recipients, r.getPRId(), p, event);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.UpdateEntryVersionMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static final class UpdateEntryVersionResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean versionUpdated;
        private final Object key;

        public UpdateEntryVersionResponse(InternalDistributedSystem dm, InternalDistributedMember member, Object k) {
            super(dm, member);
            this.key = k;
        }

        public UpdateEntryVersionResponse(InternalDistributedSystem dm, Set recipients, Object k) {
            super(dm, recipients, false);
            this.key = k;
        }

        public void setResponse(ReplyMessage msg) {
            this.versionUpdated = true;
        }

        public void waitForResult() throws CacheException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (!this.versionUpdated && logger.isDebugEnabled()) {
                logger.debug("UpdateEntryVersionResponse: Update entry version failed for key: {}", new Object[]{this.key});
            }
        }
    }
}

