/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.tier.InterestType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.ObjectIntProcedure;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class FetchKeysMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Integer bucketId;
    private int interestType;
    private Object interestArg;
    private boolean allowTombstones;
    public Version[] serializationVersions = null;

    private FetchKeysMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, Integer bucketId, int itype, Object interestArg, boolean allowTombstones) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.interestType = itype;
        this.interestArg = interestArg;
        this.allowTombstones = allowTombstones;
    }

    public FetchKeysMessage() {
    }

    public static FetchKeysResponse send(InternalDistributedMember recipient, PartitionedRegion r, Integer bucketId, boolean allowTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchKeysMessage NULL recipient");
        FetchKeysMessage tmp = new FetchKeysMessage();
        FetchKeysResponse p = (FetchKeysResponse)tmp.createReplyProcessor(r, Collections.singleton(recipient));
        FetchKeysMessage m = new FetchKeysMessage(recipient, r.getPRId(), p, bucketId, 1, ".*", allowTombstones);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static FetchKeysResponse sendInterestQuery(InternalDistributedMember recipient, PartitionedRegion r, Integer bucketId, int itype, Object arg, boolean allowTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchKeysMessage NULL recipient");
        FetchKeysMessage tmp = new FetchKeysMessage();
        FetchKeysResponse p = (FetchKeysResponse)tmp.createReplyProcessor(r, Collections.singleton(recipient));
        FetchKeysMessage m = new FetchKeysMessage(recipient, r.getPRId(), p, bucketId, itype, arg, allowTombstones);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new FetchKeysResponse(r.getSystem(), r, recipients);
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        PartitionedRegionDataStore ds;
        if (logger.isDebugEnabled()) {
            logger.debug("FetchKeysMessage operateOnRegion: {} bucketId: {} type: {} {}", new Object[]{r.getFullPath(), this.bucketId, InterestType.getString(this.interestType), this.allowTombstones ? " with tombstones" : " without tombstones"});
        }
        if ((ds = r.getDataStore()) != null) {
            try {
                Set keys = ds.handleRemoteGetKeys(this.bucketId, this.interestType, this.interestArg, this.allowTombstones);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("FetchKeysMessage sending {} keys back using processorId: : {}", new Object[]{keys.size(), this.getProcessorId(), keys});
                }
                r.getPrStats().endPartitionMessagesProcessing(startTime);
                FetchKeysReplyMessage.send(this.getSender(), this.getProcessorId(), dm, keys);
            }
            catch (PRLocallyDestroyedException pde) {
                if (logger.isDebugEnabled()) {
                    logger.debug("FetchKeysMessage Encountered PRLocallyDestroyedException");
                }
                throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_ENCOUNTERED_PRLOCALLYDESTROYEDEXCEPTION.toLocalizedString(), pde);
            }
        } else {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.FetchKeysMessage_FETCHKEYSMESSAGE_DATA_STORE_NOT_CONFIGURED_FOR_THIS_MEMBER));
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 48;
    }

    @Override
    public Version[] getSerializationVersions() {
        return this.serializationVersions;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.interestType = in.readInt();
        this.interestArg = DataSerializer.readObject(in);
        this.allowTombstones = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeInt(this.interestType);
        DataSerializer.writeObject(this.interestArg, out);
        out.writeBoolean(this.allowTombstones);
    }

    public static class FetchKeysResponse
    extends PartitionMessage.PartitionResponse {
        private final PartitionedRegion pr;
        private final Set returnValue;
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile int chunksExpected;
        private volatile boolean lastChunkReceived;

        public FetchKeysResponse(InternalDistributedSystem ds, PartitionedRegion pr, Set recipients) {
            super(ds, recipients);
            this.pr = pr;
            this.returnValue = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processChunk(FetchKeysReplyMessage msg) {
            boolean doneProcessing = false;
            if (msg.getException() != null) {
                this.process(msg);
            } else {
                try {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                    DataInputStream in = new DataInputStream(byteStream);
                    boolean requiresRegionContext = this.pr.keyRequiresRegionContext();
                    while (in.available() > 0) {
                        Object key = DataSerializer.readObject(in);
                        if (key != null) {
                            if (requiresRegionContext) {
                                ((KeyWithRegionContext)key).setRegionContext(this.pr);
                            }
                            Set set = this.returnValue;
                            synchronized (set) {
                                this.returnValue.add(key);
                                continue;
                            }
                        }
                        Assert.assertTrue(in.available() == 0);
                    }
                    Object object = this.endLock;
                    synchronized (object) {
                        ++this.chunksProcessed;
                        if (msg.seriesNum + 1 == msg.numSeries && msg.lastInSeries) {
                            this.lastChunkReceived = true;
                            this.chunksExpected = msg.msgNum + 1;
                        }
                        if (this.lastChunkReceived && this.chunksExpected == this.chunksProcessed) {
                            doneProcessing = true;
                        }
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.debug("{} chunksProcessed={},lastChunkReceived={},chunksExpected={},done={}", new Object[]{this, this.chunksProcessed, this.lastChunkReceived, this.chunksExpected, doneProcessing});
                        }
                    }
                }
                catch (Exception e) {
                    this.processException(new ReplyException(LocalizedStrings.FetchKeysMessage_ERROR_DESERIALIZING_KEYS.toLocalizedString(), e));
                    this.checkIfDone();
                }
                if (doneProcessing) {
                    this.process(msg);
                }
            }
        }

        public Set waitForKeys() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("FetchKeysResponse got remote CacheClosedException; forcing reattempt. {}", new Object[]{t.getMessage(), t});
                    throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_FETCHKEYSRESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION_FORCING_REATTEMPT.toLocalizedString(), t);
                }
                if (t instanceof ForceReattemptException) {
                    logger.debug("FetchKeysResponse got remote ForceReattemptException; rethrowing. {}", new Object[]{e.getMessage(), e});
                    throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_PEER_REQUESTS_REATTEMPT.toLocalizedString(), t);
                }
                e.handleAsUnexpected();
            }
            if (!this.lastChunkReceived) {
                throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_NO_REPLIES_RECEIVED.toLocalizedString());
            }
            return this.returnValue;
        }
    }

    public static final class FetchKeysReplyMessage
    extends ReplyMessage {
        int seriesNum;
        int msgNum;
        int numSeries;
        boolean lastInSeries;
        transient HeapDataOutputStream chunkStream;
        transient byte[] chunk;

        public FetchKeysReplyMessage() {
        }

        private FetchKeysReplyMessage(InternalDistributedMember recipient, int processorId, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            this.setRecipient(recipient);
            this.setProcessorId(processorId);
            this.seriesNum = seriesNum;
            this.msgNum = msgNum;
            this.numSeries = numSeries;
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
        }

        public static void send(final InternalDistributedMember recipient, final int processorId, final DM dm, Set keys) throws ForceReattemptException {
            Assert.assertTrue(recipient != null, "FetchKeysReplyMessage NULL reply message");
            boolean numSeries = true;
            boolean seriesNum = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Starting pr keys chunking for {} kets to member {}", new Object[]{keys.size(), recipient});
            }
            try {
                boolean finished = FetchKeysReplyMessage.chunkSet(recipient, keys, InitialImageOperation.CHUNK_SIZE_IN_BYTES, false, new ObjectIntProcedure(){
                    int msgNum = 0;
                    boolean last = false;

                    @Override
                    public boolean executeWith(Object a, int b) {
                        HeapDataOutputStream chunk = (HeapDataOutputStream)a;
                        this.last = b > 0;
                        try {
                            boolean okay = FetchKeysReplyMessage.sendChunk(recipient, processorId, dm, chunk, 0, this.msgNum++, 1, this.last);
                            return okay;
                        }
                        catch (CancelException e) {
                            return false;
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("{} pr keys chunking", new Object[]{finished ? "Finished" : "DID NOT complete"});
                }
            }
            catch (IOException io) {
                throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_UNABLE_TO_SEND_RESPONSE_TO_FETCH_KEYS_REQUEST.toLocalizedString(), io);
            }
        }

        static boolean sendChunk(InternalDistributedMember recipient, int processorId, DM dm, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            FetchKeysReplyMessage reply = new FetchKeysReplyMessage(recipient, processorId, chunk, seriesNum, msgNum, numSeries, lastInSeries);
            Set failures = dm.putOutgoing(reply);
            return failures == null || failures.size() == 0;
        }

        static boolean chunkSet(InternalDistributedMember recipient, Set set, int CHUNK_SIZE_IN_BYTES, boolean includeValues, ObjectIntProcedure proc) throws IOException {
            Iterator it = set.iterator();
            boolean keepGoing = true;
            boolean sentLastChunk = false;
            HeapDataOutputStream mos = new HeapDataOutputStream(InitialImageOperation.CHUNK_SIZE_IN_BYTES + 2048, recipient.getVersionObject());
            do {
                mos.reset();
                int avgItemSize = 0;
                int itemCount = 0;
                while (mos.size() + avgItemSize < InitialImageOperation.CHUNK_SIZE_IN_BYTES && it.hasNext()) {
                    Object key = it.next();
                    DataSerializer.writeObject(key, mos);
                    avgItemSize = mos.size() / ++itemCount;
                }
                DataSerializer.writeObject(null, mos);
                int lastMsg = it.hasNext() ? 0 : 1;
                keepGoing = proc.executeWith(mos, lastMsg);
                boolean bl = sentLastChunk = lastMsg == 1 && keepGoing;
            } while (keepGoing && it.hasNext());
            return sentLastChunk;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchKeysResponse processor = (FetchKeysResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "FetchKeysReplyMessage processor not found");
                }
                return;
            }
            processor.processChunk(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", new Object[]{processor, this});
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
        }

        @Override
        public int getDSFID() {
            return -99;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.chunk = DataSerializer.readByteArray(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FetchKeysReplyMessage ").append("processorid=").append(this.processorId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",seriesNum=").append(this.seriesNum).append(",msgNum=").append(this.msgNum).append(",numSeries=").append(this.numSeries).append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            } else if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            }
            if (this.getException() != null) {
                sb.append(", exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

