/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class DestroyRegionOnDataStoreMessage
extends PartitionMessage {
    private Object callbackArg;

    public DestroyRegionOnDataStoreMessage() {
    }

    private DestroyRegionOnDataStoreMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 rp, Object callbackArg) {
        super(recipient, regionId, rp);
        this.callbackArg = callbackArg;
    }

    public static void send(InternalDistributedMember recipient, PartitionedRegion r, Object callbackArg) {
        DM dm = r.getDistributionManager();
        ReplyProcessor21 rp = new ReplyProcessor21(dm, recipient);
        int procId = rp.getProcessorId();
        DestroyRegionOnDataStoreMessage m = new DestroyRegionOnDataStoreMessage(recipient, r.getPRId(), rp, callbackArg);
        r.getDistributionManager().putOutgoing(m);
        rp.waitForRepliesUninterruptibly();
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        if (pr == null || !pr.isInitialized()) {
            return true;
        }
        Logger logger = LogService.getLogger();
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace("DestroyRegionOnDataStore operateOnRegion: " + pr.getFullPath());
        }
        pr.destroyRegion(this.callbackArg);
        return true;
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public int getDSFID() {
        return 2165;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.callbackArg = DataSerializer.readObject(in);
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.callbackArg, out);
    }
}

