/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class BucketSizeMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;

    public BucketSizeMessage() {
    }

    private BucketSizeMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
    }

    @Override
    public final int getProcessorType() {
        return 73;
    }

    public static BucketSizeResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "BucketSizeMessage NULL reply message");
        BucketSizeResponse p = new BucketSizeResponse(r.getSystem(), Collections.singleton(recipient));
        BucketSizeMessage m = new BucketSizeMessage(recipient, r.getPRId(), p, bucketId);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        PartitionedRegionDataStore ds = r.getDataStore();
        if (ds == null) {
            throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_NO_DATASTORE_IN_0.toLocalizedString(dm.getDistributionManagerId()));
        }
        long size = ds.getBucketSize(this.bucketId);
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        BucketSizeReplyMessage.send(this.getSender(), this.getProcessorId(), dm, size);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 42;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    public static class BucketSizeResponse
    extends ReplyProcessor21 {
        private volatile long returnValue;

        public BucketSizeResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof BucketSizeReplyMessage) {
                    BucketSizeReplyMessage reply = (BucketSizeReplyMessage)msg;
                    this.returnValue = reply.getSize();
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "BucketSizeResponse return value is {}", new Object[]{this.returnValue});
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public long waitForSize() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("BucketSizeResponse got remote cancellation; forcing reattempt. {}", new Object[]{t.getMessage(), t});
                    throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_BUCKETSIZERESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION_FORCING_REATTEMPT.toLocalizedString(), t);
                }
                if (t instanceof ForceReattemptException) {
                    logger.debug("BucketSizeResponse got remote Region destroyed; forcing reattempt. {}", new Object[]{t.getMessage(), t});
                    throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_BUCKETSIZERESPONSE_GOT_REMOTE_REGION_DESTROYED_FORCING_REATTEMPT.toLocalizedString(), t);
                }
                e.handleAsUnexpected();
            }
            return this.returnValue;
        }
    }

    public static final class BucketSizeReplyMessage
    extends HighPriorityDistributionMessage {
        private int processorId;
        private long size;

        public BucketSizeReplyMessage() {
        }

        private BucketSizeReplyMessage(int processorId, long size) {
            this.processorId = processorId;
            this.size = size;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, long size) {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            BucketSizeReplyMessage m = new BucketSizeReplyMessage(processorId, size);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        protected void process(DistributionManager dm) {
            ReplyProcessor21 processor;
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "PRDistributedBucketSizeReplyMessage process invoking reply processor with processorId: {}", new Object[]{this.processorId});
            }
            if ((processor = ReplyProcessor21.getProcessor(this.processorId)) == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("PRDistributedBucketSizeReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", new Object[]{processor, this});
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 63;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.size = in.readLong();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeLong(this.size);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PRDistributedBucketSizeReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning numEntries=").append(this.getSize());
            return sb.toString();
        }

        public long getSize() {
            return this.size;
        }
    }
}

