/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class BecomePrimaryBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private boolean isRebalance;

    public BecomePrimaryBucketMessage() {
    }

    private BecomePrimaryBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, boolean isRebalance) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.isRebalance = isRebalance;
    }

    public static BecomePrimaryBucketResponse send(InternalDistributedMember recipient, PartitionedRegion pr, int bid, boolean isRebalance) {
        Assert.assertTrue(recipient != null, "BecomePrimaryBucketMessage NULL recipient");
        BecomePrimaryBucketResponse response = new BecomePrimaryBucketResponse(pr.getSystem(), recipient, pr);
        BecomePrimaryBucketMessage msg = new BecomePrimaryBucketMessage(recipient, pr.getPRId(), response, bid, isRebalance);
        Set failures = pr.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        pr.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public BecomePrimaryBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        byte responseCode = 0;
        BucketAdvisor bucketAdvisor = region.getRegionAdvisor().getBucketAdvisor(this.bucketId);
        if (bucketAdvisor.isHosting() && bucketAdvisor.becomePrimary(this.isRebalance)) {
            responseCode = 1;
        }
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        BecomePrimaryBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, null, responseCode);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; isRebalance=").append(this.isRebalance);
    }

    @Override
    public int getDSFID() {
        return 132;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.isRebalance = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeBoolean(this.isRebalance);
    }

    public static class BecomePrimaryBucketResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean success;

        public BecomePrimaryBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof BecomePrimaryBucketReplyMessage) {
                    BecomePrimaryBucketReplyMessage reply = (BecomePrimaryBucketReplyMessage)msg;
                    this.success = reply.isSuccess();
                    if (reply.isSuccess()) {
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.trace(LogMarker.DM, "BecomePrimaryBucketResponse return OK");
                        }
                    } else if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "BecomePrimaryBucketResponse return NOT_PRIMARY");
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("BecomePrimaryBucketMessage ignoring exception {}", new Object[]{ex.getMessage(), ex});
        }

        public boolean waitForResponse() {
            this.waitForRepliesUninterruptibly();
            return this.success;
        }
    }

    public static final class BecomePrimaryBucketReplyMessage
    extends ReplyMessage {
        static final byte NOT_SECONDARY = 0;
        static final byte OK = 1;
        private byte responseCode = 0;

        public BecomePrimaryBucketReplyMessage() {
        }

        public BecomePrimaryBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private BecomePrimaryBucketReplyMessage(int processorId, ReplyException re, byte responseCode) {
            this.setProcessorId(processorId);
            this.setException(re);
            this.responseCode = responseCode;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException re, byte responseCode) {
            Assert.assertTrue(recipient != null, "BecomePrimaryBucketReplyMessage NULL recipient");
            BecomePrimaryBucketReplyMessage m = new BecomePrimaryBucketReplyMessage(processorId, re, responseCode);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean isSuccess() {
            return this.responseCode == 1;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "BecomePrimaryBucketReplyMessage process invoking reply processor with processorId:{}", new Object[]{this.processorId});
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "BecomePrimaryBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "processed {}", new Object[]{this});
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeByte(this.responseCode);
        }

        @Override
        public int getDSFID() {
            return 133;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.responseCode = in.readByte();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("BecomePrimaryBucketReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning responseCode=").append(this.responseCode);
            return sb.toString();
        }
    }
}

