/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;

class ThreadIdentifierCustomExpiry
implements CustomExpiry {
    private static final ExpirationAttributes DEFAULT_THREAD_ID_EXP_ATTS = new ExpirationAttributes(300, ExpirationAction.LOCAL_INVALIDATE);
    private static volatile ExpirationAttributes testExpAtts = null;

    ThreadIdentifierCustomExpiry() {
    }

    public ExpirationAttributes getExpiry(Region.Entry entry) {
        Object key = entry.getKey();
        if (key instanceof ThreadIdentifier) {
            int expTime = HARegionQueue.threadIdExpiryTime;
            if (expTime != 300) {
                ExpirationAttributes result = testExpAtts;
                if (result == null || result.getTimeout() != expTime) {
                    testExpAtts = result = new ExpirationAttributes(expTime, ExpirationAction.LOCAL_INVALIDATE);
                }
                return result;
            }
            return DEFAULT_THREAD_ID_EXP_ATTS;
        }
        return null;
    }

    @Override
    public void close() {
    }
}

