/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute.util;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;

public class FindRestEnabledServersFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 7851518767859544678L;

    @Override
    public void execute(FunctionContext context) {
        try {
            String protocolType;
            GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            DistributionConfig config = InternalDistributedSystem.getAnyInstance().getConfig();
            String string = protocolType = config.getHttpServiceSSLEnabled() ? "https" : "http";
            if (c.isRESTServiceRunning()) {
                context.getResultSender().lastResult(protocolType + "://" + config.getHttpServiceBindAddress() + ":" + config.getHttpServicePort());
            } else {
                context.getResultSender().lastResult("");
            }
        }
        catch (CacheClosedException ex) {
            context.getResultSender().lastResult("");
        }
    }

    @Override
    public String getId() {
        return GemFireCacheImpl.FIND_REST_ENABLED_SERVERS_FUNCTION_ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

