/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionException;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class LocalResultCollectorImpl
implements LocalResultCollector {
    private final ResultCollector userRC;
    private CountDownLatch latch = new CountDownLatch(1);
    protected volatile boolean endResultRecieved = false;
    private volatile boolean resultCollected = false;
    protected volatile boolean resultsCleared = false;
    private FunctionException functionException = null;
    private Function function = null;
    private AbstractExecution execution = null;

    public LocalResultCollectorImpl(Function function, ResultCollector rc, Execution execution) {
        this.function = function;
        this.userRC = rc;
        this.execution = (AbstractExecution)execution;
    }

    @Override
    public synchronized void addResult(DistributedMember memberID, Object resultOfSingleExecution) {
        if (this.resultsCleared) {
            return;
        }
        if (!this.endResultRecieved) {
            if (resultOfSingleExecution instanceof Throwable) {
                Throwable t = (Throwable)resultOfSingleExecution;
                if (this.execution.isIgnoreDepartedMembers()) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                    this.userRC.addResult(memberID, t);
                } else if (!(t instanceof InternalFunctionException)) {
                    if (this.functionException == null) {
                        if (resultOfSingleExecution instanceof FunctionException) {
                            this.functionException = (FunctionException)resultOfSingleExecution;
                            if (t.getCause() != null) {
                                t = t.getCause();
                            }
                        } else {
                            this.functionException = new FunctionException(t);
                        }
                    }
                    this.functionException.addException(t);
                } else {
                    this.userRC.addResult(memberID, t.getCause());
                }
            } else {
                this.userRC.addResult(memberID, resultOfSingleExecution);
            }
        }
    }

    @Override
    public void endResults() {
        this.endResultRecieved = true;
        this.userRC.endResults();
        this.latch.countDown();
    }

    @Override
    public synchronized void clearResults() {
        this.latch = new CountDownLatch(1);
        this.endResultRecieved = false;
        this.functionException = null;
        this.userRC.clearResults();
        this.resultsCleared = true;
    }

    @Override
    public Object getResult() throws FunctionException {
        if (this.resultCollected) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_RESULTS_ALREADY_COLLECTED.toLocalizedString());
        }
        this.resultCollected = true;
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            this.latch.countDown();
            Thread.currentThread().interrupt();
        }
        this.latch = new CountDownLatch(1);
        if (this.functionException != null && !this.execution.isIgnoreDepartedMembers()) {
            if (this.function.isHA() && this.functionException.getCause() instanceof InternalFunctionInvocationTargetException) {
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.function) : this.execution.execute(this.function.getId());
                return newRc.getResult();
            }
            throw this.functionException;
        }
        Object result = this.userRC.getResult();
        return result;
    }

    @Override
    public Object getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        boolean resultRecieved = false;
        if (this.resultCollected) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_RESULTS_ALREADY_COLLECTED.toLocalizedString());
        }
        this.resultCollected = true;
        try {
            resultRecieved = this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            this.latch.countDown();
            Thread.currentThread().interrupt();
        }
        if (!resultRecieved) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_RESULTS_NOT_COLLECTED_IN_TIME_PROVIDED.toLocalizedString());
        }
        this.latch = new CountDownLatch(1);
        if (this.functionException != null && !this.execution.isIgnoreDepartedMembers()) {
            if (this.function.isHA() && this.functionException.getCause() instanceof InternalFunctionInvocationTargetException) {
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.function) : this.execution.execute(this.function.getId());
                return newRc.getResult(timeout, unit);
            }
            throw this.functionException;
        }
        Object result = this.userRC.getResult(timeout, unit);
        return result;
    }

    @Override
    public void setException(Throwable exception) {
        this.functionException = exception instanceof FunctionException ? (FunctionException)exception : new FunctionException(exception);
    }

    @Override
    public ReplyProcessor21 getProcessor() {
        return null;
    }

    @Override
    public void setProcessor(ReplyProcessor21 processor) {
    }
}

