/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.cache.execute.FunctionServiceStats;

public class FunctionStats {
    public static String statName = "FunctionStatistics";
    private static final StatisticsType _type;
    private FunctionServiceStats aggregateStats;
    private static final String FUNCTION_EXECUTIONS_COMPLETED = "functionExecutionsCompleted";
    private static final String FUNCTION_EXECUTIONS_COMPLETED_PROCESSING_TIME = "functionExecutionsCompletedProcessingTime";
    private static final String FUNCTION_EXECUTIONS_RUNNING = "functionExecutionsRunning";
    private static final String RESULTS_SENT_TO_RESULTCOLLECTOR = "resultsSentToResultCollector";
    private static final String FUNCTION_EXECUTION_CALLS = "functionExecutionCalls";
    private static final String FUNCTION_EXECUTIONS_HASRESULT_COMPLETED_PROCESSING_TIME = "functionExecutionsHasResultCompletedProcessingTime";
    private static final String FUNCTION_EXECUTIONS_HASRESULT_RUNNING = "functionExecutionsHasResultRunning";
    private static final String RESULTS_RECEIVED = "resultsReceived";
    private static final String FUNCTION_EXECUTION_EXCEPTIONS = "functionExecutionsExceptions";
    private static final int _functionExecutionsCompletedId;
    private static final int _functionExecutionsCompletedProcessingTimeId;
    private static final int _functionExecutionsRunningId;
    private static final int _resultsSentToResultCollectorId;
    private static final int _functionExecutionCallsId;
    private static final int _functionExecutionsHasResultCompletedProcessingTimeId;
    private static final int _functionExecutionsHasResultRunningId;
    private static final int _resultsReceived;
    private static final int _functionExecutionExceptions;
    private final Statistics _stats;
    private static FunctionStats disabledStats;

    private FunctionStats() {
        InternalDistributedSystem iDS = InternalDistributedSystem.getAnyInstance();
        this._stats = iDS.createAtomicStatistics(_type);
        this.aggregateStats = iDS.getFunctionServiceStats();
    }

    public FunctionStats(StatisticsFactory factory, String name) {
        this._stats = factory.createAtomicStatistics(_type, name);
        this.aggregateStats = ((InternalDistributedSystem)factory).getFunctionServiceStats();
    }

    public void close() {
        this._stats.close();
    }

    public int getFunctionExecutionsCompleted() {
        return this._stats.getInt(_functionExecutionsCompletedId);
    }

    public void incFunctionExecutionsCompleted() {
        this._stats.incInt(_functionExecutionsCompletedId, 1);
        this.aggregateStats.incFunctionExecutionsCompleted();
    }

    public long getFunctionExecutionCompleteProcessingTime() {
        return this._stats.getLong(_functionExecutionsCompletedProcessingTimeId);
    }

    public int getFunctionExecutionsRunning() {
        return this._stats.getInt(_functionExecutionsRunningId);
    }

    public void incFunctionExecutionsRunning() {
        this._stats.incInt(_functionExecutionsRunningId, 1);
        this.aggregateStats.incFunctionExecutionsRunning();
    }

    public int getResultsSentToResultCollector() {
        return this._stats.getInt(_resultsSentToResultCollectorId);
    }

    public void incResultsReturned() {
        this._stats.incInt(_resultsSentToResultCollectorId, 1);
        this.aggregateStats.incResultsReturned();
    }

    public int getResultsReceived() {
        return this._stats.getInt(_resultsReceived);
    }

    public void incResultsReceived() {
        this._stats.incInt(_resultsReceived, 1);
        this.aggregateStats.incResultsReceived();
    }

    public int getFunctionExecutionCalls() {
        return this._stats.getInt(_functionExecutionCallsId);
    }

    public void incFunctionExecutionCalls() {
        this._stats.incInt(_functionExecutionCallsId, 1);
        this.aggregateStats.incFunctionExecutionCalls();
    }

    public int getFunctionExecutionHasResultCompleteProcessingTime() {
        return this._stats.getInt(_functionExecutionsHasResultCompletedProcessingTimeId);
    }

    public int getFunctionExecutionHasResultRunning() {
        return this._stats.getInt(_functionExecutionsHasResultRunningId);
    }

    public void incFunctionExecutionHasResultRunning() {
        this._stats.incInt(_functionExecutionsHasResultRunningId, 1);
        this.aggregateStats.incFunctionExecutionHasResultRunning();
    }

    public int getFunctionExecutionExceptions() {
        return this._stats.getInt(_functionExecutionExceptions);
    }

    public void incFunctionExecutionExceptions() {
        this._stats.incInt(_functionExecutionExceptions, 1);
        this.aggregateStats.incFunctionExecutionExceptions();
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    public void startFunctionExecution(boolean haveResult) {
        this._stats.incInt(_functionExecutionCallsId, 1);
        this._stats.incInt(_functionExecutionsRunningId, 1);
        if (haveResult) {
            this._stats.incInt(_functionExecutionsHasResultRunningId, 1);
        }
        this.aggregateStats.startFunctionExecution(haveResult);
    }

    public void endFunctionExecution(long start, boolean haveResult) {
        long ts = DistributionStats.getStatTime();
        this._stats.incInt(_functionExecutionsCompletedId, 1);
        this._stats.incInt(_functionExecutionsRunningId, -1);
        long elapsed = ts - start;
        this._stats.incLong(_functionExecutionsCompletedProcessingTimeId, elapsed);
        if (haveResult) {
            this._stats.incInt(_functionExecutionsHasResultRunningId, -1);
            this._stats.incLong(_functionExecutionsHasResultCompletedProcessingTimeId, elapsed);
        }
        this.aggregateStats.endFunctionExecution(start, haveResult);
    }

    public void endFunctionExecutionWithException(boolean haveResult) {
        this._stats.incInt(_functionExecutionsRunningId, -1);
        this._stats.incInt(_functionExecutionExceptions, 1);
        if (haveResult) {
            this._stats.incInt(_functionExecutionsHasResultRunningId, -1);
        }
        this.aggregateStats.endFunctionExecutionWithException(haveResult);
    }

    public static FunctionStats getFunctionStats(String functionID, InternalDistributedSystem ds) {
        boolean statsDisabled = Boolean.getBoolean("gemfire.statsDisabled");
        if (statsDisabled) {
            if (disabledStats == null) {
                disabledStats = new FunctionStats();
            }
            return disabledStats;
        }
        if (ds == null) {
            ds = InternalDistributedSystem.getAnyInstance();
        }
        return ds.getFunctionStats(functionID);
    }

    static {
        String statDescription = "This is the stats for the individual Function's Execution";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createIntCounter(FUNCTION_EXECUTIONS_COMPLETED, "Total number of completed function.execute() calls for given function", "operations"), f.createLongCounter(FUNCTION_EXECUTIONS_COMPLETED_PROCESSING_TIME, "Total time consumed for all completed invocations of the given function", "nanoseconds"), f.createIntGauge(FUNCTION_EXECUTIONS_RUNNING, "number of currently running invocations of the given function", "operations"), f.createIntCounter(RESULTS_SENT_TO_RESULTCOLLECTOR, "Total number of results sent to the ResultCollector", "operations"), f.createIntCounter(RESULTS_RECEIVED, "Total number of results received and passed to the ResultCollector", "operations"), f.createIntCounter(FUNCTION_EXECUTION_CALLS, "Total number of FunctionService.execute() calls for given function", "operations"), f.createLongCounter(FUNCTION_EXECUTIONS_HASRESULT_COMPLETED_PROCESSING_TIME, "Total time consumed for all completed given function.execute() calls where hasResult() returns true.", "nanoseconds"), f.createIntGauge(FUNCTION_EXECUTIONS_HASRESULT_RUNNING, "A gauge indicating the number of currently active execute() calls for functions where hasResult() returns true.", "operations"), f.createIntCounter(FUNCTION_EXECUTION_EXCEPTIONS, "Total number of Exceptions Occured while executing function", "operations")});
        _functionExecutionsCompletedId = _type.nameToId(FUNCTION_EXECUTIONS_COMPLETED);
        _functionExecutionsCompletedProcessingTimeId = _type.nameToId(FUNCTION_EXECUTIONS_COMPLETED_PROCESSING_TIME);
        _functionExecutionsRunningId = _type.nameToId(FUNCTION_EXECUTIONS_RUNNING);
        _resultsSentToResultCollectorId = _type.nameToId(RESULTS_SENT_TO_RESULTCOLLECTOR);
        _functionExecutionCallsId = _type.nameToId(FUNCTION_EXECUTION_CALLS);
        _functionExecutionsHasResultCompletedProcessingTimeId = _type.nameToId(FUNCTION_EXECUTIONS_HASRESULT_COMPLETED_PROCESSING_TIME);
        _functionExecutionsHasResultRunningId = _type.nameToId(FUNCTION_EXECUTIONS_HASRESULT_RUNNING);
        _functionExecutionExceptions = _type.nameToId(FUNCTION_EXECUTION_EXCEPTIONS);
        _resultsReceived = _type.nameToId(RESULTS_RECEIVED);
    }
}

