/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.cache.DistributedRegionFunctionStreamingMessage;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionException;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class DistributedRegionFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    DistributedRegionFunctionStreamingMessage msg = null;
    private final DM dm;
    private ResultCollector rc;
    private boolean isLocal;
    private ServerToClientFunctionResultSender sender;
    private final Function functionObject;
    private boolean enableOrderedResultStreming;
    private boolean localLastResultRecieved = false;

    public DistributedRegionFunctionResultSender(DM dm, DistributedRegionFunctionStreamingMessage msg, Function function) {
        this.msg = msg;
        this.dm = dm;
        this.functionObject = function;
    }

    public DistributedRegionFunctionResultSender(DM dm, ResultCollector rc, Function function, ServerToClientFunctionResultSender sender) {
        this.dm = dm;
        this.isLocal = true;
        this.rc = rc;
        this.functionObject = function;
        this.sender = sender;
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.localLastResultRecieved) {
            return;
        }
        this.localLastResultRecieved = true;
        if (this.sender != null) {
            this.sender.lastResult(oneResult);
            if (this.rc != null) {
                this.rc.endResults();
            }
        } else {
            if (this.isLocal) {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                this.rc.endResults();
                FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReceived();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    public void lastResult(Object oneResult, DistributedMember memberID) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        this.localLastResultRecieved = true;
        if (this.sender != null) {
            this.sender.lastResult(oneResult, memberID);
            if (this.rc != null) {
                this.rc.endResults();
            }
        } else {
            if (this.isLocal) {
                this.rc.addResult(memberID, oneResult);
                this.rc.endResults();
                FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm == null ? null : this.dm.getSystem()).incResultsReceived();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm == null ? null : this.dm.getSystem()).incResultsReturned();
        }
    }

    @Override
    public synchronized void sendResult(Object oneResult) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.sender != null) {
            this.sender.sendResult(oneResult);
        } else {
            if (this.isLocal) {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReceived();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    public synchronized void sendResult(Object oneResult, DistributedMember memberID) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.sender != null) {
            this.sender.sendResult(oneResult, memberID);
        } else {
            if (this.isLocal) {
                this.rc.addResult(memberID, oneResult);
                FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm == null ? null : this.dm.getSystem()).incResultsReceived();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            FunctionStats.getFunctionStats(this.functionObject.getId(), this.dm == null ? null : this.dm.getSystem()).incResultsReturned();
        }
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultRecieved = true;
    }

    @Override
    public void setException(Throwable exception) {
        if (this.sender != null) {
            this.sender.setException(exception);
        } else {
            ((LocalResultCollector)this.rc).setException(exception);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributedRegionFunctionResultSender_UNEXPECTED_EXCEPTION_DURING_FUNCTION_EXECUTION_ON_LOCAL_NODE), exception);
        }
        this.rc.endResults();
        this.localLastResultRecieved = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultRecieved;
    }
}

